/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree;

import java.util.List;
import org.neodatis.OrderByConstants;
import org.neodatis.btree.AbstractBTreeIterator;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;

public class BTreeIteratorMultipleValuesPerKey
extends AbstractBTreeIterator {
    private int currenListIndex = 0;
    private List currentValue = null;

    public BTreeIteratorMultipleValuesPerKey(IBTree tree, OrderByConstants orderByType) {
        super(tree, orderByType);
    }

    public Object next() {
        if (this.currentNode != null && this.currentValue != null) {
            int listSize = this.currentValue.size();
            if (listSize > this.currenListIndex) {
                Object value = this.currentValue.get(this.currenListIndex);
                ++this.currenListIndex;
                ++this.nbReturnedElements;
                return value;
            }
            this.currenListIndex = 0;
            this.currentValue = null;
        }
        return super.next();
    }

    public Object getValueAt(IBTreeNode node, int currentIndex) {
        int listSize;
        if (this.currentValue == null) {
            this.currentValue = (List)node.getValueAsObjectAt(currentIndex);
        }
        if ((listSize = this.currentValue.size()) > this.currenListIndex) {
            Object value = this.currentValue.get(this.currenListIndex);
            ++this.currenListIndex;
            return value;
        }
        this.currenListIndex = 0;
        this.currentValue = null;
        return null;
    }
}

