/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import jdbm.RecordManagerOptions;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRUNativeLong;
import jdbm.helper.Serializer;
import jdbm.helper.maps.LongKeyChainedHashMap;
import jdbm.helper.maps.LongKeyMap;
import jdbm.recman.BlockIo;
import jdbm.recman.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordFile
implements CachePolicyListener {
    final TransactionManager txnMgr;
    private int cleanMRUSize = 1000;
    private int maxFreeSize = 100;
    private int maxDirtySize = 10000;
    private final LinkedList<BlockIo> free = new LinkedList();
    private MRUNativeLong clean = new MRUNativeLong(this.cleanMRUSize);
    private final LongKeyMap<BlockIo> inUse = new LongKeyChainedHashMap<BlockIo>();
    private final LongKeyMap<BlockIo> dirty = new LongKeyChainedHashMap<BlockIo>();
    private final LongKeyMap<BlockIo> inTxn = new LongKeyChainedHashMap<BlockIo>();
    private boolean transactionsDisabled = false;
    private boolean syncOnClose = true;
    public static final int BLOCK_SIZE = 8192;
    static final String extension = RecordManagerOptions.FILE_EXTENSION;
    static final byte[] cleanData = new byte[8192];
    private RandomAccessFile file;
    private final String fileName;
    private long cleanBlocksEvictedCount = 0L;
    private long freeBlocksAddedCount = 0L;
    private long freeBlocksUsedCount = 0L;
    private long cleanBlocksHitCount = 0L;
    private long fetchBlockCount = 0L;
    private long writeBlockCount = 0L;
    private long extendBlockCount = 0L;
    private long triggerRate = 0L;
    private long triggerCount = 0L;

    RecordFile(String fileName) throws IOException {
        this.fileName = fileName;
        if (new File(fileName + extension).exists()) {
            // empty if block
        }
        String fullFileName = fileName + extension;
        this.file = new RandomAccessFile(fullFileName, "rw");
        this.txnMgr = new TransactionManager(this);
        this.clean.addListener(this);
    }

    String getFileName() {
        return this.fileName;
    }

    void disableTransactions(int maxDirtySize, boolean syncOnClose) {
        this.transactionsDisabled = true;
        this.maxDirtySize = maxDirtySize;
        this.syncOnClose = syncOnClose;
    }

    void disableTransactions(int maxDirtySize) {
        this.disableTransactions(maxDirtySize, this.syncOnClose);
    }

    void disableTransactions() {
        this.disableTransactions(this.maxDirtySize);
    }

    void setCleanMRUCapacity(int val) {
        this.cleanMRUSize = val;
        this.clean = new MRUNativeLong(this.cleanMRUSize);
    }

    void setFreeListCapacity(int val) {
        this.maxFreeSize = val;
    }

    void setCounterDisplayRate(long val) {
        this.triggerRate = val;
    }

    BlockIo get(long blockid) throws IOException {
        long key = blockid;
        BlockIo node = this.inTxn.get(key);
        if (node != null) {
            this.inTxn.remove(key);
            this.inUse.put(key, node);
            return node;
        }
        node = this.dirty.get(key);
        if (node != null) {
            this.dirty.remove(key);
            this.inUse.put(key, node);
            return node;
        }
        node = (BlockIo)this.clean.get(new Long(key));
        if (node != null) {
            this.clean.remove(new Long(key));
            ++this.cleanBlocksHitCount;
            this.inUse.put(key, node);
            return node;
        }
        if (this.inUse.get(key) != null) {
            throw new Error("double get for block " + blockid);
        }
        node = this.getNewNode(blockid);
        long offset = blockid * 8192L;
        if (this.file.length() > 0L && offset <= this.file.length()) {
            RecordFile.read(this.file, offset, node.getData(), 8192);
            ++this.fetchBlockCount;
            this.showCounters();
        } else {
            System.arraycopy(cleanData, 0, node.getData(), 0, 8192);
            ++this.extendBlockCount;
            this.showCounters();
        }
        this.inUse.put(key, node);
        node.setClean();
        return node;
    }

    void release(long blockid, boolean isDirty) throws IOException {
        BlockIo node = this.inUse.get(blockid);
        if (node == null) {
            throw new IOException("bad blockid " + blockid + " on release");
        }
        if (!node.isDirty() && isDirty) {
            node.setDirty();
        }
        this.release(node);
    }

    void release(BlockIo block) throws IOException {
        long key = block.getBlockId();
        this.inUse.remove(key);
        if (block.isDirty()) {
            this.dirty.put(key, block);
            if (this.transactionsDisabled && this.dirty.size() > this.maxDirtySize) {
                this.commit();
            }
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(key, block);
        } else {
            this.putClean(key, block);
        }
    }

    private void putClean(long key, BlockIo block) {
        try {
            this.clean.put(new Long(key), block, false, (Serializer)null);
        }
        catch (CacheEvictionException ex) {
            throw new RuntimeException(ex);
        }
    }

    void discard(BlockIo block) {
        long key = block.getBlockId();
        this.inUse.remove(key);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (this.triggerRate != 0L) {
            this.showCounters(false);
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        Iterator<BlockIo> i = this.dirty.values().iterator();
        while (i.hasNext()) {
            BlockIo node = i.next();
            i.remove();
            if (this.transactionsDisabled) {
                long offset = node.getBlockId() * 8192L;
                this.file.seek(offset);
                this.file.write(node.getData());
                ++this.writeBlockCount;
                this.showCounters();
                node.setClean();
                this.putClean(node.getBlockId(), node);
                continue;
            }
            this.txnMgr.add(node);
            this.inTxn.put(node.getBlockId(), node);
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
        if (this.triggerRate != 0L) {
            this.showCounters(true);
        }
    }

    void rollback() throws IOException {
        if (this.transactionsDisabled) {
            throw new IOException("Rollback not allowed if transactions are disabled");
        }
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        this.txnMgr.shutdown();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.values().iterator());
            throw new Error("Dirty blocks at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.values().iterator());
            throw new Error("inUse blocks at close time");
        }
        if (this.transactionsDisabled && this.syncOnClose) {
            this.sync();
        }
        this.file.close();
        this.file = null;
    }

    void forceClose() throws IOException {
        this.txnMgr.forceClose();
        this.file.close();
    }

    private void showList(Iterator<BlockIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    private BlockIo getNewNode(long blockid) throws IOException {
        BlockIo retval = null;
        if (!this.free.isEmpty()) {
            retval = this.free.removeFirst();
            ++this.freeBlocksUsedCount;
        }
        if (retval == null) {
            retval = new BlockIo(0L, new byte[8192]);
        }
        retval.setBlockId(blockid);
        retval.setView(null);
        return retval;
    }

    void synch(BlockIo node) throws IOException {
        byte[] data = node.getData();
        if (data != null) {
            long offset = node.getBlockId() * 8192L;
            this.file.seek(offset);
            this.file.write(data);
            ++this.writeBlockCount;
            this.showCounters();
        }
    }

    void releaseFromTransaction(BlockIo node, boolean recycle) throws IOException {
        long key = node.getBlockId();
        if (this.inTxn.remove(key) != null && recycle) {
            this.putClean(key, node);
        }
    }

    void sync() throws IOException {
        this.file.getFD().sync();
    }

    private static void read(RandomAccessFile file, long offset, byte[] buffer, int nBytes) throws IOException {
        file.seek(offset);
        int remaining = nBytes;
        int pos = 0;
        while (remaining > 0) {
            int read = file.read(buffer, pos, remaining);
            if (read == -1) {
                System.arraycopy(cleanData, 0, buffer, pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
    }

    private void showCounters() {
        ++this.triggerCount;
        if (this.triggerRate != 0L && this.triggerCount % this.triggerRate == 0L) {
            this.showCounters(false);
        }
    }

    private void showCounters(boolean reset) {
        long nblocks = this.inTxn.size() + this.dirty.size() + this.inUse.size() + this.clean.size() + this.free.size();
        long memused = nblocks * 8192L / 0x100000L;
        System.err.println("memory used (mb): " + memused);
        System.err.println("# blocks in mem : " + nblocks);
        System.err.println("# inTxn blocks  : " + this.inTxn.size());
        System.err.println("# dirty blocks  : " + this.dirty.size());
        System.err.println("# inUse blocks  : " + this.inUse.size());
        System.err.println("# fetch blocks  : " + this.fetchBlockCount);
        System.err.println("# write blocks  : " + this.writeBlockCount);
        System.err.println("# extend blocks : " + this.extendBlockCount);
        System.err.println("# clean blocks  : " + this.clean.size());
        System.err.println("# clean hit     : " + this.cleanBlocksHitCount);
        System.err.println("# clean evicted : " + this.cleanBlocksEvictedCount);
        System.err.println("# free blocks   : " + this.free.size());
        System.err.println("# free added    : " + this.freeBlocksAddedCount);
        System.err.println("# free used     : " + this.freeBlocksUsedCount);
        System.err.println("-----------------------------------\n");
        if (reset) {
            this.resetCounters();
        }
    }

    private void resetCounters() {
        this.cleanBlocksEvictedCount = 0L;
        this.freeBlocksAddedCount = 0L;
        this.freeBlocksUsedCount = 0L;
        this.cleanBlocksHitCount = 0L;
        this.fetchBlockCount = 0L;
        this.writeBlockCount = 0L;
        this.extendBlockCount = 0L;
        this.triggerCount = 0L;
    }

    @Override
    public void cacheObjectEvicted(Object key, Object obj, boolean dirty, Serializer<?> ser) throws CacheEvictionException {
        ++this.cleanBlocksEvictedCount;
        if (this.free.size() < this.maxFreeSize) {
            ++this.freeBlocksAddedCount;
            this.free.add((BlockIo)obj);
        }
    }
}

