/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.PhysicalRowId;

final class Location {
    private final long block;
    private final short offset;
    private int _hashCode = 0;

    Location(long block, short offset) {
        this.block = block;
        this.offset = offset;
    }

    Location(long blockOffset) {
        this.offset = (short)(blockOffset & 0xFFFFL);
        this.block = blockOffset >> 16;
    }

    Location(PhysicalRowId src) {
        this.block = src.getBlock();
        this.offset = src.getOffset();
    }

    long getBlock() {
        return this.block;
    }

    short getOffset() {
        return this.offset;
    }

    long toLong() {
        return (this.block << 16) + (long)this.offset;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = new Long(this.toLong()).hashCode();
        }
        return this._hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Location ol = (Location)o;
        return ol.block == this.block && ol.offset == this.offset;
    }

    public boolean isZero() {
        return this.block == 0L && this.offset == 0;
    }

    public String toString() {
        return "PL(" + this.block + ":" + this.offset + ")";
    }
}

