/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 583;
    public static final transient int wasteMargin = 128;
    public static final transient int wasteMargin2 = 4;
    FreePhysicalRowId[] slots = new FreePhysicalRowId[583];

    FreePhysicalRowIdPage(BlockIo block) {
        super(block);
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)view;
        }
        return new FreePhysicalRowIdPage(block);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    void free(int slot) {
        this.get(slot).setSize(0);
        this.setCount((short)(this.getCount() - 1));
    }

    FreePhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        return this.get(slot);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getSize() != 0;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    FreePhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new FreePhysicalRowId(this.block, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 14);
    }

    int getFirstFree() {
        for (int i = 0; i < 583; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int getFirstLargerThan(int size) {
        long waste;
        int bestSlot = -1;
        int bestSlotSize = 0;
        for (int i = 0; i < 583; ++i) {
            long theSize = this.get(i).getSize();
            long waste2 = theSize - (long)size;
            if (waste2 < 0L) continue;
            if (waste2 < 128L) {
                return i;
            }
            if (bestSlotSize < size) continue;
            bestSlot = i;
            bestSlotSize = size;
        }
        if (bestSlot != -1 && (waste = (long)(bestSlotSize - size)) >= 0L && waste < 4L) {
            return bestSlot;
        }
        return -1;
    }
}

