/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BPage;
import jdbm.btree.BTree;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.ISerializationHandler;
import jdbm.helper.Serializer;
import jdbm.helper.WrappedRuntimeException;
import jdbm.helper.compression.CompressionProvider;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.BlockIo;
import jdbm.recman.DataPage;
import jdbm.recman.FreeLogicalRowIdPage;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageHeader;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;
import jdbm.recman.RecordHeader;
import jdbm.recman.TranslationPage;

public class DumpUtility
extends BaseRecordManager {
    private int pageMarkerCount = 10;
    private int _pageLimit = 0;
    private IRecordAnalyzer _recordAnalyzer = new DefaultRecordAnalyzer();
    private int[] _binDecls = defaultBinDecls;
    public static final int[] defaultBinDecls = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 32768, 65536, 131072, 0};
    public static final int[] fineGrainBinDecls = new int[]{2, 4, 8, 16, 18, 20, 22, 24, 26, 28, 30, 32, 36, 40, 44, 48, 52, 56, 60, 64, 72, 80, 88, 96, 104, 112, 120, 128, 144, 160, 176, 192, 208, 224, 240, 256, 288, 320, 352, 384, 416, 448, 480, 512, 576, 640, 704, 768, 832, 896, 960, 1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 3840, 4096, 4608, 5120, 5632, 6144, 6656, 7168, 7680, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 32768, 65536, 131072, 0};

    public int getPageMarkerCount() {
        return this.pageMarkerCount;
    }

    public void setPageMarkerCount(int value) {
        this.pageMarkerCount = value;
    }

    public int getPageLimit() {
        return this._pageLimit;
    }

    public void setPageLimit(int value) {
        this._pageLimit = value;
    }

    private static String exists(String filename) {
        if (!new File(filename + ".db").exists()) {
            throw new IllegalArgumentException("Could not find file: " + filename);
        }
        return filename;
    }

    public DumpUtility(String filename) throws IOException {
        super(DumpUtility.exists(filename));
        this._file.disableTransactions();
    }

    public void setRecordAnalyzer(IRecordAnalyzer recordAnalyzer) {
        if (recordAnalyzer == null) {
            throw new IllegalArgumentException();
        }
        this._recordAnalyzer = recordAnalyzer;
    }

    public IRecordAnalyzer getRecordAnalyzer() {
        return this._recordAnalyzer;
    }

    public synchronized void delete(long recid) throws IOException {
        throw new IOException("read-only");
    }

    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        throw new IOException("read-only");
    }

    public int[] getHistogramBins() {
        return this._binDecls;
    }

    public int[] setHistogramBins(int[] bins) {
        if (bins == null) {
            throw new IllegalArgumentException();
        }
        Arrays.sort(bins);
        int[] ret = this._binDecls;
        this._binDecls = bins;
        return ret;
    }

    protected static int getBin(int[] bins, int n) {
        for (int i = 0; i < bins.length; ++i) {
            if (bins[i] < n) continue;
            return i;
        }
        throw new AssertionError((Object)("Could not find bin: n=" + n));
    }

    protected static void writeHistogram(PrintStream ps, String label, long[] bins, int[] binDecls) {
        int i;
        boolean threshold = true;
        long sum = 0L;
        for (i = 0; i < bins.length; ++i) {
            sum += bins[i];
        }
        ps.println(label + ": #samples=" + sum);
        ps.println("count\tpercent\tbinSize");
        for (i = 0; i < bins.length; ++i) {
            int percent;
            if (bins[i] == 0L || (percent = (int)((double)bins[i] / (double)sum * 100.0 * 100.0) / 100) < 1) continue;
            ps.println(bins[i] + "\t" + percent + "%\t" + binDecls[i]);
        }
    }

    public void writeHistogram(PrintStream ps, String label, Map typedata) throws IOException {
        boolean threshold = false;
        long nsamples = 0L;
        TreeMap<Long, RecordTypeData> order = new TreeMap<Long, RecordTypeData>();
        for (RecordTypeData tdata : typedata.values()) {
            long count = tdata.getCount();
            nsamples += count;
            order.put(new Long(count), tdata);
        }
        ps.println(label + ": #samples=" + nsamples);
        ps.println("count\tpercent\ttype");
        for (RecordTypeData tdata : order.values()) {
            String type = tdata.getType();
            long count = tdata.getCount();
            int percent = (int)((double)count / (double)nsamples * 100.0 * 100.0) / 100;
            if (percent < 0) continue;
            ps.println(count + "\t" + percent + "%\t" + type);
        }
        for (RecordTypeData tdata : order.values()) {
            String type = tdata.getType();
            tdata.writeSizeHistogram(ps, "\nRecord size histogram: " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFreePageListSummary(PrintStream ps) throws IOException {
        this.checkIfClosed();
        ps.println("\n*** Free Page List Summary.");
        long npages = 0L;
        PageCursor curs = new PageCursor(this._pageman, 0);
        int pageLimit = this.getPageLimit();
        while (curs.next() != 0L && (pageLimit == 0 || npages < (long)pageLimit)) {
            if (npages > 0L && npages % (long)this.pageMarkerCount == 0L) {
                System.err.print(".");
            }
            long blockId = curs.getCurrent();
            try {
                BlockIo block = this._file.get(blockId);
                PageHeader view = PageHeader.getView(block);
                ++npages;
            }
            finally {
                this._file.release(curs.getCurrent(), false);
            }
        }
        ps.println("\nScanned " + npages + " page(s) on the free page list.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFreeLogicalRowIdPageListSummary(PrintStream ps) throws IOException {
        this.checkIfClosed();
        ps.println("\n*** Free Logical Row Id Page List Summary.");
        long npages = 0L;
        int slotsPerPage = 817;
        ps.println("#slots per page=817");
        PageCursor curs = new PageCursor(this._pageman, 3);
        int pageLimit = this.getPageLimit();
        while (curs.next() != 0L) {
            if (pageLimit != 0 && npages >= (long)pageLimit) {
                System.err.println("\n*** Stopping after: " + npages + " pages.");
                break;
            }
            if (npages > 0L && npages % (long)this.pageMarkerCount == 0L) {
                System.err.print(".");
            }
            long blockId = curs.getCurrent();
            ps.print("Scanning free logical row id page=" + blockId);
            try {
                BlockIo block = this._file.get(blockId);
                FreeLogicalRowIdPage view = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(block);
                short nfreeThisPage = view.getCount();
                ps.println(" #of unused logical row ids (this page)=" + nfreeThisPage);
                for (int slot = 0; slot < 817; ++slot) {
                    if (view.isFree(slot)) continue;
                    PhysicalRowId tmp = view.get(slot);
                    ps.println("Slot=" + slot + " has unused logical row id=" + new Location(tmp));
                }
                ++npages;
            }
            finally {
                this._file.release(curs.getCurrent(), false);
            }
        }
        ps.println("\nScanned " + npages + " page(s) on the free logical row id page list.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFreePhysicalRowIdPageListSummary(PrintStream ps) throws IOException {
        this.checkIfClosed();
        ps.println("\n*** Free Physical Row Id Page List Summary.");
        long npages = 0L;
        long freecapacity = 0L;
        long nfreerecs = 0L;
        long[] freecapacitybin = new long[this.getHistogramBins().length];
        int slotsPerPage = 583;
        ps.println("#slots per page=583");
        PageCursor curs = new PageCursor(this._pageman, 4);
        int pageLimit = this.getPageLimit();
        while (curs.next() != 0L) {
            if (pageLimit != 0 && npages >= (long)pageLimit) {
                System.err.println("\n*** Stopping after: " + npages + " pages.");
                break;
            }
            if (npages > 0L && npages % (long)this.pageMarkerCount == 0L) {
                System.err.print(".");
            }
            long blockId = curs.getCurrent();
            ps.print("Scanning free physical row id page=" + blockId);
            try {
                BlockIo block = this._file.get(blockId);
                FreePhysicalRowIdPage view = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(block);
                short nfreeThisPage = view.getCount();
                ps.println(" #of free physical rows (this page)=" + nfreeThisPage);
                for (int slot = 0; slot < 583; ++slot) {
                    if (view.isFree(slot)) continue;
                    FreePhysicalRowId tmp = view.get(slot);
                    int capacity = tmp.getSize();
                    ps.println("Slot=" + slot + " has free physical row " + new Location(tmp) + " with capacity=" + capacity);
                    freecapacity += (long)capacity;
                    int n = DumpUtility.getBin(this.getHistogramBins(), capacity);
                    freecapacitybin[n] = freecapacitybin[n] + 1L;
                    ++nfreerecs;
                }
                ++npages;
            }
            finally {
                this._file.release(curs.getCurrent(), false);
            }
        }
        ps.println("\nScanned " + npages + " page(s) on the free physical row id page list.");
        ps.println("There are " + nfreerecs + " deleted records in the store.");
        ps.println("Total capacity of deleted records is " + freecapacity + " bytes.");
        DumpUtility.writeHistogram(ps, "\nFree capacity histogram", freecapacitybin, this.getHistogramBins());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTranslationPageListSummary(PrintStream ps, StringScanner scanner) throws IOException {
        this.checkIfClosed();
        ps.println("\n*** Translation Page List Summary.");
        long npages = 0L;
        long nuserecs = 0L;
        long usesize = 0L;
        long nwasterecs = 0L;
        long totalwaste = 0L;
        long usecapacity = 0L;
        long wastecapacity = 0L;
        long[] usesizebin = new long[this.getHistogramBins().length];
        TreeMap typedata = new TreeMap();
        HashMap<Long, BTreeStatistics> btrees = new HashMap<Long, BTreeStatistics>();
        PageCursor tcurs = new PageCursor(this._pageman, 2);
        int pageLimit = this.getPageLimit();
        while (tcurs.next() != 0L) {
            if (pageLimit != 0 && npages >= (long)pageLimit) {
                System.err.println("\n*** Stopping after: " + npages + " pages.");
                break;
            }
            if (npages > 0L && npages % (long)this.pageMarkerCount == 0L) {
                System.err.print(".");
            }
            long blockId = tcurs.getCurrent();
            TranslationPageSlot[] slots = (TranslationPageSlot[])new TranslationPageScanner(this).scanPage(blockId);
            for (int i = 0; i < slots.length; ++i) {
                int size;
                long recid = slots[i].getRecid();
                Location physid = slots[i].getPhysicalRowId();
                try {
                    BlockIo block2 = this._file.get(physid.getBlock());
                    RecordHeader head = new RecordHeader(block2, physid.getOffset());
                    size = head.getCurrentSize();
                    int capacity = head.getAvailableSize();
                    if (size <= 0) {
                        throw new AssertionError((Object)("Not expecting deleted record to be listed in translation page list: physid=" + physid + ", header=" + head));
                    }
                    ++nuserecs;
                    usesize += (long)size;
                    usecapacity += (long)capacity;
                    int n = DumpUtility.getBin(this.getHistogramBins(), capacity);
                    usesizebin[n] = usesizebin[n] + 1L;
                    int waste = capacity - size;
                    if (waste > 0) {
                        totalwaste += (long)waste;
                        wastecapacity += (long)capacity;
                        ++nwasterecs;
                    }
                }
                finally {
                    this._file.release(physid.getBlock(), false);
                }
                String className = this.collectRecordTypeData(recid, physid, typedata, scanner);
                if (BTree.class.getName().equals(className) && !btrees.containsKey(new Long(recid))) {
                    btrees.put(new Long(recid), new BTreeStatistics(recid));
                }
                if (!BPage.class.getName().equals(className)) continue;
                try {
                    BPage bpage = (BPage)this.fetch(recid);
                    long btreeId = bpage.getBTree().getRecid();
                    BTreeStatistics stats = (BTreeStatistics)btrees.get(new Long(btreeId));
                    if (stats == null) {
                        stats = new BTreeStatistics(btreeId);
                        btrees.put(new Long(btreeId), stats);
                    }
                    stats.collect(recid, size, bpage);
                    continue;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            ++npages;
        }
        ps.println("\nScanned " + npages + " pages on the 'translation' page list.");
        ps.println("There are " + nuserecs + " in use records with a capacity of " + usecapacity + " bytes.");
        ps.println("Total waste of " + totalwaste + " bytes across " + nwasterecs + " records in which waste occurs.");
        ps.println("Wasted capacity for in use records: " + (double)((int)((double)totalwaste / (double)usecapacity * 100.0 * 100.0)) / 100.0 + "%");
        ps.println("Average waste per record with waste: " + totalwaste / nwasterecs + " bytes.");
        ps.println("Average size of record with waste: " + wastecapacity / nwasterecs + " bytes.");
        ps.println("Waste per record with waste: " + (double)((int)((double)totalwaste / (double)wastecapacity * 100.0 * 100.0)) / 100.0 + "%");
        ps.println("Average in use record size: " + usesize / nuserecs);
        DumpUtility.writeHistogram(ps, "\nIn use size histogram ", usesizebin, this.getHistogramBins());
        this.writeHistogram(ps, "\nRecord type histogram", typedata);
        ps.println("\nBTrees: #btree=" + btrees.size());
        for (Map.Entry entry : btrees.entrySet()) {
            long recid = (Long)entry.getKey();
            BTreeStatistics stats = (BTreeStatistics)entry.getValue();
            this.writeBTreeSummary(ps, recid, stats);
        }
        if (scanner != null) {
            ps.println("\nString scanner summary");
            scanner.writeReport(ps);
        }
    }

    public void writeBTreeSummary(PrintStream ps, long recid, BTreeStatistics stats) throws IOException {
        BTree btree;
        try {
            btree = BTree.load(this, recid);
        }
        catch (Throwable t) {
            if (t instanceof WrappedRuntimeException && ((WrappedRuntimeException)t).getException() instanceof ClassNotFoundException) {
                System.err.println("Check CLASSPATH - could not fetch BTree: " + t);
                return;
            }
            throw new RuntimeException(t);
        }
        ps.println("\nBTree: recid=" + recid + ", pageSize=" + btree.getPageSize() + ", height=" + btree.getHeight() + ", entryCount=" + btree.entryCount());
        Comparator keyComparator = btree.getComparator();
        CompressionProvider keyCompressionProvider = btree.getKeyCompressionProvider();
        Serializer keySerializer = btree.getKeySerializer();
        Serializer valueSerializer = btree.getValueSerializer();
        ps.println("keyComparator: " + (keyComparator != null ? keyComparator.getClass() : null));
        ps.println("keySerializer: " + (keySerializer != null ? keySerializer.getClass() : null));
        ps.println("valueSerializer: " + (valueSerializer != null ? valueSerializer.getClass() : null));
        ps.println("keyCompressionProvider: " + (keyCompressionProvider != null ? keyCompressionProvider.getClass() : null));
        long totalBytes = stats.getTotalNodeSize();
        long totalMB = stats.getTotalNodeSize() / 0x100000L;
        long nodeCount = stats.getNodeCount();
        ps.println("#of nodes in btree: " + nodeCount);
        ps.println("Total record size for nodes in btree: " + totalBytes + "(bytes) " + totalMB + "(mb)");
        ps.println("Average node size in btree: " + totalBytes / nodeCount + "(bytes)");
    }

    protected String collectRecordTypeData(long recid, Location physid, Map typedata, StringScanner scanner) throws IOException {
        String type;
        byte[] data = this._physMgr.fetch(physid);
        try {
            data = this._compressor.decompress(data);
        }
        catch (RuntimeException ex) {
            System.out.println("WARN: Could not decompress record: recid=" + recid + ", ex=" + ex);
        }
        if (scanner != null) {
            scanner.scan(data);
        }
        if ((type = this.getRecordAnalyzer().getRecordType(this, recid, data)) == null || type.length() == 0) {
            throw new AssertionError((Object)"Record type must be non-null and non-empty label.");
        }
        RecordTypeData tdata = (RecordTypeData)typedata.get(type);
        if (tdata == null) {
            tdata = new RecordTypeData(type, this.getHistogramBins());
            typedata.put(type, tdata);
        }
        int size = data.length;
        int capacity = 0;
        tdata.inc(size, capacity);
        try {
            Class.forName(type);
            return type;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUsedPageListSummary(PrintStream ps) throws IOException {
        this.checkIfClosed();
        ps.println("\n*** Used Page List Summary");
        long npages = 0L;
        long nrecs = 0L;
        long nuserecs = 0L;
        long nfreerecs = 0L;
        long usesize = 0L;
        long nwasterecs = 0L;
        long totalwaste = 0L;
        long usecapacity = 0L;
        long freecapacity = 0L;
        long wastecapacity = 0L;
        long[] usesizebin = new long[this.getHistogramBins().length];
        long[] freecapacitybin = new long[this.getHistogramBins().length];
        PageCursor tcurs = new PageCursor(this._pageman, 1);
        while (tcurs.next() != 0L) {
            long usedBlockId = tcurs.getCurrent();
            try {
                RecordHeader head;
                BlockIo usedBlock = this._file.get(usedBlockId);
                DataPage dataPageView = DataPage.getDataPageView(usedBlock);
                short offset = dataPageView.getFirst();
                if (offset == 0) continue;
                do {
                    head = new RecordHeader(usedBlock, offset);
                    int size = head.getCurrentSize();
                    int capacity = head.getAvailableSize();
                    if (capacity == 0) break;
                    if (size <= 0) {
                        freecapacity += (long)capacity;
                        ++nfreerecs;
                        int n = DumpUtility.getBin(this._binDecls, capacity);
                        freecapacitybin[n] = freecapacitybin[n] + 1L;
                    } else {
                        ++nuserecs;
                        usesize += (long)size;
                        usecapacity += (long)capacity;
                        int n = DumpUtility.getBin(this._binDecls, capacity);
                        usesizebin[n] = usesizebin[n] + 1L;
                        int waste = capacity - size;
                        if (waste > 0) {
                            totalwaste += (long)waste;
                            wastecapacity += (long)capacity;
                            ++nwasterecs;
                        }
                    }
                    ++nrecs;
                } while ((offset = (short)(offset + (head.getAvailableSize() + 8))) < 8184);
                ++npages;
            }
            finally {
                this._file.release(tcurs.getCurrent(), false);
            }
        }
        long totalcapacity = usecapacity + freecapacity;
        ps.println("\nScanned " + npages + " pages on the 'used' page list.");
        ps.println("Records: used=" + nuserecs + ", free=" + nfreerecs + ", total=" + nrecs);
        ps.println("Capacity: used=" + usecapacity + ", free=" + freecapacity + ", total=" + totalcapacity);
        ps.println("% free capacity: " + (double)((int)((double)freecapacity / (double)totalcapacity * 100.0 * 100.0)) / 100.0);
        ps.println("Total waste of " + totalwaste + " bytes across " + nwasterecs + " records in which waste occurs.");
        ps.println("% wasted capacity: " + (double)((int)((double)totalwaste / (double)totalcapacity * 100.0 * 100.0)) / 100.0);
        ps.println("Average waste per record with waste: " + totalwaste / nwasterecs + " bytes.");
        ps.println("Average size of record with waste: " + wastecapacity / nwasterecs + " bytes.");
        ps.println("% waste per record with waste: " + (double)totalwaste / (double)wastecapacity * 100.0);
        ps.println("Average in use record size: " + usesize / nuserecs);
        DumpUtility.writeHistogram(ps, "\nIn use size histogram ", usesizebin, this.getHistogramBins());
        DumpUtility.writeHistogram(ps, "\nFree capacity histogram", freecapacitybin, this.getHistogramBins());
    }

    public static final void usage(String msg, String[] args) {
        System.err.println(msg);
        System.err.println("DumpUtility [options] filename\n   -A\tAll (equivilent to -F -T -U -L -P).\n   -F\tSummarize the free page list.\n   -T\tSummarize the translation page list (includes record type breakdown).\n   -U\tSummarize the used page list (includes deleted record summary).\n   -L\tSummarize the free logical row id page list.\n   -P\tSummarize the free physical row id page list.\n   -fg\tUse fine grained histograms.\n   -ss\tScan for strings in data.\n   -ssi\tCase insensitive string scan (default is case sensitive).\n   -ssml#\tMinimum length for scanned strings to # (default is 5).\n   -ssML#\tMaximum length for scanned strings to # (default is 80).\n   -ssmf#\tMinimum frequency count to report for scanned strings to # (default is 2).\n   -pm#\tSets the page marker count to #.\n   -pl#\tSets the page limit count to #.\n   -ra{cl} Names the {@link IRecordAnalyzer} implementation class.\n\nThe default behavior is equivilent to (-U).");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        String filename = null;
        boolean defaultSummary = true;
        boolean summarizeFreePageList = false;
        boolean summarizeTranslationPageList = false;
        boolean summarizeUsedPageList = false;
        boolean summarizeFreeLogicalRowIdPageList = false;
        boolean summarizeFreePhysicalRowIdPageList = false;
        boolean fineGrained = false;
        boolean scanStrings = false;
        boolean scannerCaseSensitive = true;
        int scannerMinLength = 5;
        int scannerMaxLength = 80;
        int scannerMinFreq = 2;
        int pageMarkerCount = 10;
        int pageLimitCount = 0;
        String recordAnalyzer = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String tmp;
                if (arg.equals("-A")) {
                    defaultSummary = false;
                    summarizeFreePageList = true;
                    summarizeTranslationPageList = true;
                    summarizeUsedPageList = true;
                    summarizeFreeLogicalRowIdPageList = true;
                    summarizeFreePhysicalRowIdPageList = true;
                    continue;
                }
                if (arg.equals("-F")) {
                    defaultSummary = false;
                    summarizeFreePageList = true;
                    continue;
                }
                if (arg.equals("-T")) {
                    defaultSummary = false;
                    summarizeTranslationPageList = true;
                    continue;
                }
                if (arg.equals("-U")) {
                    defaultSummary = false;
                    summarizeUsedPageList = true;
                    continue;
                }
                if (arg.equals("-L")) {
                    defaultSummary = false;
                    summarizeFreeLogicalRowIdPageList = true;
                    continue;
                }
                if (arg.equals("-P")) {
                    defaultSummary = false;
                    summarizeFreePhysicalRowIdPageList = true;
                    continue;
                }
                if (arg.equals("-fg")) {
                    fineGrained = true;
                    continue;
                }
                if (arg.equals("-ss")) {
                    scanStrings = true;
                    continue;
                }
                if (arg.equals("-ssi")) {
                    scannerCaseSensitive = false;
                    continue;
                }
                if (arg.startsWith("-ssml")) {
                    scannerMinLength = Integer.parseInt(arg.substring(5));
                    continue;
                }
                if (arg.startsWith("-ssML")) {
                    scannerMaxLength = Integer.parseInt(arg.substring(5));
                    continue;
                }
                if (arg.startsWith("-ssmf")) {
                    scannerMinFreq = Integer.parseInt(arg.substring(5));
                    continue;
                }
                if (arg.startsWith("-pm")) {
                    tmp = arg.substring(3);
                    pageMarkerCount = new Integer(tmp);
                    continue;
                }
                if (arg.startsWith("-pl")) {
                    tmp = arg.substring(3);
                    pageLimitCount = new Integer(tmp);
                    continue;
                }
                if (arg.startsWith("-ra")) {
                    recordAnalyzer = tmp = arg.substring(3);
                    continue;
                }
                DumpUtility.usage("Do not understand: " + arg, args);
                continue;
            }
            filename = arg;
        }
        if (filename == null) {
            DumpUtility.usage("Must specify filename.", args);
        }
        if (defaultSummary) {
            summarizeUsedPageList = true;
        }
        Properties properties = new Properties();
        properties.setProperty("dump", "true");
        RecordManager recman = RecordManagerFactory.createRecordManager(filename, properties);
        DumpUtility du = (DumpUtility)recman.getBaseRecordManager();
        du.setPageLimit(pageLimitCount);
        du.setPageMarkerCount(pageMarkerCount);
        if (recordAnalyzer != null) {
            try {
                du.setRecordAnalyzer((IRecordAnalyzer)Class.forName(recordAnalyzer).newInstance());
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                DumpUtility.usage("Could not establish record analyzer: class=" + recordAnalyzer, args);
            }
        }
        if (fineGrained) {
            du.setHistogramBins(fineGrainBinDecls);
        }
        if (summarizeFreePageList) {
            du.writeFreePageListSummary(System.out);
        }
        if (summarizeTranslationPageList) {
            StringScanner scanner = scanStrings ? new StringScanner(scannerCaseSensitive, scannerMinLength, scannerMaxLength, scannerMinFreq) : null;
            du.writeTranslationPageListSummary(System.out, scanner);
        }
        if (summarizeUsedPageList) {
            du.writeUsedPageListSummary(System.out);
        }
        if (summarizeFreeLogicalRowIdPageList) {
            du.writeFreeLogicalRowIdPageListSummary(System.out);
        }
        if (summarizeFreePhysicalRowIdPageList) {
            du.writeFreePhysicalRowIdPageListSummary(System.out);
        }
        du.close();
        System.exit(0);
    }

    public static class DefaultRecordAnalyzer
    implements IRecordAnalyzer {
        public Object deserialize(DumpUtility dump, long recid, byte[] serialized) throws IOException {
            ISerializationHandler defaultSerializer = dump.getSerializationHandler();
            try {
                Object obj = defaultSerializer.deserialize(dump, recid, serialized);
                return obj;
            }
            catch (Throwable t) {
                if (!(defaultSerializer instanceof DefaultSerializer)) {
                    try {
                        Object obj = DefaultSerializer.INSTANCE.deserialize(serialized);
                        return obj;
                    }
                    catch (Throwable t2) {
                        return null;
                    }
                }
                return null;
            }
        }

        public String guessClassName(byte[] serialized) throws IOException {
            if (serialized.length < 8) {
                return "<tiny:" + serialized.length + ">";
            }
            DataInputStream ois = new DataInputStream(new ByteArrayInputStream(serialized));
            for (int i = 0; i < 6; ++i) {
                ois.read();
            }
            int nchars = ois.readUnsignedShort();
            if (nchars == 0) {
                return "<unknown>";
            }
            if (serialized.length - 8 - nchars < 0) {
                return "<unknown2>";
            }
            char[] chars = new char[nchars];
            int j = 0;
            for (int i = 0; i < nchars; ++i) {
                char ch = (char)ois.readUnsignedByte();
                if (ch < ' ' || ch >= '\u007f') continue;
                chars[j++] = ch;
            }
            String cname = new String(chars);
            ois.close();
            return cname;
        }

        public String getRecordType(DumpUtility dump, long recid, byte[] data) throws IOException {
            Object obj = this.deserialize(dump, recid, data);
            if (obj != null) {
                String name = obj.getClass().getName();
                return name;
            }
            return this.guessClassName(data);
        }
    }

    public static interface IRecordAnalyzer {
        public String getRecordType(DumpUtility var1, long var2, byte[] var4) throws IOException;
    }

    public static class StringScanner {
        private final boolean m_caseSensitive;
        private final int m_minLength;
        private final int m_maxLength;
        private final int m_minReport;
        private final Map freqCount;
        private long ninstances = 0L;
        private static final Long ONE = new Long(1L);

        public long getStringCount() {
            return this.freqCount.size();
        }

        public long getInstanceCount() {
            return this.ninstances;
        }

        public StringScanner() {
            this(true, 5, 80, 2);
        }

        public StringScanner(boolean caseSensitive, int minLength, int maxLength, int minReport) {
            this.m_caseSensitive = caseSensitive;
            this.m_minLength = minLength;
            this.m_maxLength = maxLength;
            this.m_minReport = minReport;
            this.freqCount = new TreeMap();
        }

        public void writeReport(PrintStream ps) {
            ps.println("minLength=" + this.m_minLength);
            ps.println("maxLength=" + this.m_maxLength);
            ps.println("minReport=" + this.m_minReport);
            ps.println("caseSensitive=" + this.m_caseSensitive);
            ps.println("Strings: #distinct=" + this.getStringCount() + ", #instances=" + this.getInstanceCount());
            TreeMap<Long, String> ordered = new TreeMap<Long, String>(new ReverseLongComparator());
            for (Map.Entry entry : this.freqCount.entrySet()) {
                String key = (String)entry.getKey();
                Long value = (Long)entry.getValue();
                if (value < (long)this.m_minReport) continue;
                ordered.put(value, key);
            }
            Iterator itr = ordered.entrySet().iterator();
            ps.println("freq\tkb\tstring");
            while (itr.hasNext()) {
                Map.Entry entry;
                entry = itr.next();
                Long freq = (Long)entry.getKey();
                String str = (String)entry.getValue();
                long kb = freq * (long)str.length() / 1024L;
                ps.println("" + freq + "\t" + kb + "\t" + str);
            }
        }

        public void scan(byte[] data) {
            int len = data.length;
            int i = 0;
            int j = 0;
            char[] chars = new char[len];
            while (true) {
                if (i >= len) {
                    if (j > 0) {
                        this.report(j, chars);
                    }
                    return;
                }
                char ch = (char)data[i];
                if (ch >= ' ' && ch < '\u007f') {
                    chars[j++] = ch;
                } else if (j > 0) {
                    this.report(j, chars);
                    j = 0;
                }
                ++i;
            }
        }

        private void report(int n, char[] chars) {
            if (n >= this.m_minLength) {
                Long oldCount;
                n = Math.min(n, this.m_maxLength);
                String s = new String(chars, 0, n);
                if (!this.m_caseSensitive) {
                    s.toUpperCase();
                }
                if ((oldCount = (Long)this.freqCount.get(s)) == null) {
                    this.freqCount.put(s, ONE);
                } else {
                    Long newCount = new Long(oldCount + 1L);
                    this.freqCount.put(s, newCount);
                }
                ++this.ninstances;
            }
        }

        private static class ReverseLongComparator
        implements Comparator {
            private ReverseLongComparator() {
            }

            public int compare(Object o1, Object o2) {
                return -((Long)o1).compareTo((Long)o2);
            }
        }
    }

    static class RecordTypeData {
        private final String m_type;
        private final int[] m_binDecls;
        private long m_count = 0L;
        private final long[] sizebin;
        private final long[] capbin;

        public RecordTypeData(String type, int[] binDecls) {
            this.m_type = type;
            this.m_binDecls = binDecls;
            this.sizebin = new long[binDecls.length];
            this.capbin = new long[binDecls.length];
        }

        public void inc(int size, int capacity) {
            ++this.m_count;
            int n = DumpUtility.getBin(this.m_binDecls, size);
            this.sizebin[n] = this.sizebin[n] + 1L;
            int n2 = DumpUtility.getBin(this.m_binDecls, capacity);
            this.capbin[n2] = this.capbin[n2] + 1L;
        }

        public String getType() {
            return this.m_type;
        }

        public long getCount() {
            return this.m_count;
        }

        public void writeSizeHistogram(PrintStream ps, String label) {
            DumpUtility.writeHistogram(ps, label, this.sizebin, this.m_binDecls);
        }

        public void writeCapacityHistogram(PrintStream ps, String label) {
            DumpUtility.writeHistogram(ps, label, this.capbin, this.m_binDecls);
        }
    }

    public static class BTreeStatistics {
        private final long m_btreeId;
        private long m_totalNodeSize = 0L;
        private long m_nodeCount = 0L;

        public BTreeStatistics(long btreeId) {
            this.m_btreeId = btreeId;
        }

        public long getBTreeId() {
            return this.m_btreeId;
        }

        public long getTotalNodeSize() {
            return this.m_totalNodeSize;
        }

        public long getNodeCount() {
            return this.m_nodeCount;
        }

        public void collect(long recid, int size, BPage bpage) {
            if (bpage.getBTree().getRecid() != this.getBTreeId()) {
                throw new AssertionError();
            }
            this.m_totalNodeSize += (long)size;
            ++this.m_nodeCount;
        }
    }

    public static class TranslationPageScanner
    implements PageScanner {
        final RecordFile _file;

        public TranslationPageScanner(BaseRecordManager recman) {
            this._file = recman._file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Slot[] scanPage(long blockId) throws IOException {
            Vector<TranslationPageSlot> slots = new Vector<TranslationPageSlot>();
            try {
                BlockIo transBlock = this._file.get(blockId);
                TranslationPage xlatPage = TranslationPage.getTranslationPageView(transBlock);
                for (int i = 0; i < 817; ++i) {
                    short offset = (short)(18 + i * 10);
                    long recid = new Location(blockId, offset).toLong();
                    Location physid = new Location(xlatPage.get(offset));
                    if (physid.getBlock() == 0L) continue;
                    TranslationPageSlot slot = new TranslationPageSlot(recid, physid);
                    slots.add(slot);
                }
            }
            finally {
                this._file.release(blockId, false);
            }
            return slots.toArray(new TranslationPageSlot[0]);
        }
    }

    public static class TranslationPageSlot
    implements Slot {
        private long _recid;
        private Location _physid;

        public long getRecid() {
            return this._recid;
        }

        public Location getPhysicalRowId() {
            return this._physid;
        }

        public TranslationPageSlot(long recid, Location physid) {
            this._recid = recid;
            this._physid = physid;
        }
    }

    public static interface PageScanner {
    }

    public static interface Slot {
    }
}

