/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.DefaultSerializationHandler;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.ISerializationHandler;
import jdbm.helper.Serializer;
import jdbm.helper.compessor.DefaultRecordCompressor;
import jdbm.helper.compessor.IRecordCompressor;
import jdbm.recman.BufferedRecordInstallManager;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRecordManager
implements RecordManager {
    RecordFile _file;
    PhysicalRowIdManager _physMgr;
    LogicalRowIdManager _logMgr;
    PageManager _pageman;
    BufferedRecordInstallManager _bufMgr;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final int STICKY_OPTIONS_ROOT = 1;
    public static final int DEFAULT_SERIALIZER_ROOT = 2;
    public static final int FIRST_FREE_ROOT = 3;
    ISerializationHandler _serializer = new DefaultSerializationHandler();
    private transient long m_serializationElapsed = 0L;
    private transient long m_deserializationElapsed = 0L;
    IRecordCompressor _compressor = new DefaultRecordCompressor();
    public static final boolean DEBUG = false;
    private Map<String, Long> _nameDirectory;

    @Override
    public ISerializationHandler getSerializationHandler() {
        this.checkIfClosed();
        return this._serializer;
    }

    public BaseRecordManager(String filename) throws IOException {
        this._file = new RecordFile(filename);
        this._pageman = new PageManager(this._file);
        this._physMgr = new PhysicalRowIdManager(this._file, this._pageman);
        this._logMgr = new LogicalRowIdManager(this._file, this._pageman);
        this._bufMgr = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public RecordManager getRecordManager() {
        if (this._file == null) {
            return null;
        }
        return this;
    }

    @Override
    public RecordManager getBaseRecordManager() {
        return this.getRecordManager();
    }

    public synchronized TransactionManager getTransactionManager() {
        this.checkIfClosed();
        return this._file.txnMgr;
    }

    public synchronized void disableTransactions() {
        this.checkIfClosed();
        this._file.disableTransactions();
    }

    public synchronized void disableTransactions(int autoCommitInterval, boolean syncOnClose) {
        this.checkIfClosed();
        this._file.disableTransactions(autoCommitInterval, syncOnClose);
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        if (this._bufMgr != null) {
            this._bufMgr.commit();
            this._bufMgr = null;
        }
        this._pageman.close();
        this._pageman = null;
        this._file.close();
        this._file = null;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, null);
    }

    @Override
    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        long recid;
        this.checkIfClosed();
        long beginTime = System.currentTimeMillis();
        byte[] data = serializer == null ? this._serializer.serialize(this, 0L, obj) : serializer.serialize(obj);
        this.m_serializationElapsed += System.currentTimeMillis() - beginTime;
        data = this._compressor.compress(data);
        if (this._bufMgr != null) {
            Location physRowId = new Location(0L, 0);
            recid = this._logMgr.insert(physRowId).toLong();
            Location logRowId = new Location(recid);
            this._bufMgr.update(logRowId, data);
        } else {
            Location physRowId = this._physMgr.insert(data, 0, data.length);
            recid = this._logMgr.insert(physRowId).toLong();
        }
        return recid;
    }

    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        Location logRowId = new Location(recid);
        Location physRowId = this._logMgr.fetch(logRowId);
        if (physRowId.getBlock() != 0L) {
            this._physMgr.delete(physRowId);
        }
        if (this._bufMgr != null) {
            this._bufMgr.delete(logRowId);
        }
        this._logMgr.delete(logRowId);
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, null);
    }

    @Override
    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        Location logRecid = new Location(recid);
        Location physRecid = this._logMgr.fetch(logRecid);
        long beginTime = System.currentTimeMillis();
        byte[] data = serializer == null ? this._serializer.serialize(this, recid, obj) : serializer.serialize(obj);
        this.m_serializationElapsed += System.currentTimeMillis() - beginTime;
        data = this._compressor.compress(data);
        if (this._bufMgr != null) {
            this._bufMgr.update(logRecid, data);
            return;
        }
        Location newRecid = physRecid.getBlock() == 0L ? this._physMgr.insert(data, 0, data.length) : this._physMgr.update(physRecid, data, 0, data.length);
        if (!newRecid.equals(physRecid)) {
            this._logMgr.update(logRecid, newRecid);
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, null);
    }

    @Override
    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        byte[] data = null;
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        Location logRowId = new Location(recid);
        if (this._bufMgr != null) {
            data = this._bufMgr.fetch(logRowId);
        }
        if (data == null) {
            Location physRowId = this._logMgr.fetch(logRowId);
            data = this._physMgr.fetch(physRowId);
        }
        if (data == null) {
            return null;
        }
        data = this._compressor.decompress(data);
        long beginTime = System.currentTimeMillis();
        Object obj = serializer == null ? this._serializer.deserialize(this, recid, data) : serializer.deserialize(data);
        this.m_deserializationElapsed += System.currentTimeMillis() - beginTime;
        return obj;
    }

    @Override
    public int getRootCount() {
        return 1013;
    }

    @Override
    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this._pageman.getFileHeader().getRoot(id);
    }

    @Override
    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this._pageman.getFileHeader().setRoot(id, rowid);
    }

    @Override
    public long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        Long recid = nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    @Override
    public void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        if (recid == 0L) {
            nameDirectory.remove(name);
        } else {
            nameDirectory.put(name, new Long(recid));
        }
        this.saveNameDirectory(nameDirectory);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        if (this._bufMgr != null) {
            this._bufMgr.commit();
        }
        this._pageman.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        if (this._bufMgr != null) {
            this._bufMgr.abort();
        }
        this._pageman.rollback();
    }

    private Map<String, Long> getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this._nameDirectory = new HashMap<String, Long>();
            nameDirectory_recid = this.insert(this._nameDirectory, DefaultSerializer.INSTANCE);
            this.setRoot(0, nameDirectory_recid);
        } else {
            this._nameDirectory = (Map)this.fetch(nameDirectory_recid, DefaultSerializer.INSTANCE);
        }
        return this._nameDirectory;
    }

    private void saveNameDirectory(Map<String, Long> directory) throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new IOException("Name directory must exist");
        }
        this.update(recid, this._nameDirectory, DefaultSerializer.INSTANCE);
    }

    void checkIfClosed() throws IllegalStateException {
        if (this._file == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }
}

