/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.Stateless;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashBucket<K, V>
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList<K> _keys;
    private ArrayList<V> _values;

    public HashBucket() {
    }

    public HashBucket(int level) {
        if (level > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keys = new ArrayList(8);
        this._values = new ArrayList(8);
    }

    public int getElementCount() {
        return this._keys.size();
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public V addElement(K key, V value) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V before = this._values.get(existing);
            this._values.set(existing, value);
            return before;
        }
        this._keys.add(key);
        this._values.add(value);
        return null;
    }

    public V removeElement(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V obj = this._values.get(existing);
            this._keys.remove(existing);
            this._values.remove(existing);
            return obj;
        }
        return null;
    }

    public V getValue(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            return this._values.get(existing);
        }
        return null;
    }

    ArrayList<K> getKeys() {
        return this._keys;
    }

    ArrayList<V> getValues() {
        return this._values;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(this._depth);
        int entries = this._keys.size();
        out.writeInt(entries);
        for (i = 0; i < entries; ++i) {
            out.writeObject(this._keys.get(i));
        }
        for (i = 0; i < entries; ++i) {
            out.writeObject(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this._depth = in.readInt();
        int entries = in.readInt();
        int size = Math.max(entries, 8);
        this._keys = new ArrayList(size);
        this._values = new ArrayList(size);
        for (i = 0; i < entries; ++i) {
            this._keys.add(in.readObject());
        }
        for (i = 0; i < entries; ++i) {
            this._values.add(in.readObject());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashBucket {depth=");
        buf.append(this._depth);
        buf.append(", keys=");
        buf.append(this._keys);
        buf.append(", values=");
        buf.append(this._values);
        buf.append("}");
        return buf.toString();
    }

    public static class Serializer0
    implements IStreamSerializer,
    Stateless {
        public void serialize(DataOutput out, Object obj) throws IOException {
            int i;
            HashBucket tmp = (HashBucket)obj;
            out.writeInt(tmp._depth);
            int entries = tmp._keys.size();
            out.writeInt(entries);
            for (i = 0; i < entries; ++i) {
                out.serialize(tmp._keys.get(i));
            }
            for (i = 0; i < entries; ++i) {
                out.serialize(tmp._values.get(i));
            }
        }

        public Object deserialize(DataInput in, Object obj) throws IOException {
            int i;
            HashBucket tmp = (HashBucket)obj;
            tmp._depth = in.readInt();
            int entries = in.readInt();
            int size = Math.max(entries, 8);
            tmp._keys = new ArrayList(size);
            tmp._values = new ArrayList(size);
            for (i = 0; i < entries; ++i) {
                tmp._keys.add(in.deserialize());
            }
            for (i = 0; i < entries; ++i) {
                tmp._values.add(in.deserialize());
            }
            return tmp;
        }
    }
}

