/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.MRU;
import jdbm.helper.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCache<K, V>
implements CachePolicy<K, V> {
    public static final int L1_DEFAULT_CAPACITY = 128;
    public static final int L2_INITIAL_CAPACITY = 128;
    public static final float L2_DEFAULT_LOAD_FACTOR = 1.5f;
    private final ReferenceQueue<V> _clearQueue = new ReferenceQueue();
    private final CachePolicy<K, V> _internal;
    private final Map<K, Entry<K, V>> _cacheMap;
    private int _capacity;
    private float _loadFactor;
    private int _highTide = 0;
    private int _ninserts = 0;

    public WeakCache() {
        this(new MRU(128));
    }

    public WeakCache(CachePolicy<K, V> internal) throws NullPointerException {
        this(128, 1.5f, internal);
    }

    public WeakCache(float loadFactor, CachePolicy<K, V> internal) throws IllegalArgumentException, NullPointerException {
        this(128, loadFactor, internal);
    }

    public WeakCache(int capacity, float loadFactor, CachePolicy<K, V> internal) throws IllegalArgumentException, NullPointerException {
        if (internal == null) {
            throw new NullPointerException("Internal cache cannot be null.");
        }
        this._internal = internal;
        this._capacity = capacity;
        this._loadFactor = loadFactor;
        this._cacheMap = new HashMap<K, Entry<K, V>>(capacity, loadFactor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public CachePolicy<K, V> getDelegate() {
        return this._internal;
    }

    @Override
    public void put(K key, V value, boolean dirty, Serializer<V> ser) throws CacheEvictionException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        this._internal.put(key, value, dirty, ser);
        this.removeClearedEntries();
        this._cacheMap.put(key, new Entry<K, V>(key, value, this._clearQueue));
        ++this._ninserts;
        int size = this._cacheMap.size();
        if (size > this._highTide) {
            this._highTide = size;
        }
    }

    @Override
    public V get(K key) {
        V value = this._internal.get(key);
        if (value != null) {
            return value;
        }
        this.removeClearedEntries();
        Entry<K, V> entry = this._cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        value = entry.getValue();
        if (value == null) {
            return null;
        }
        try {
            this._internal.put(key, value, false, null);
        }
        catch (CacheEvictionException e) {
            this._cacheMap.remove(key);
            return null;
        }
        return value;
    }

    @Override
    public void remove(K key) {
        this._cacheMap.remove(key);
        this._internal.remove(key);
    }

    @Override
    public void removeAll() {
        this._cacheMap.clear();
        this._internal.removeAll();
    }

    @Override
    public Enumeration elements() {
        return this._internal.elements();
    }

    @Override
    public Enumeration entries() {
        return this._internal.entries();
    }

    @Override
    public void addListener(CachePolicyListener listener) throws IllegalArgumentException {
        this._internal.addListener(listener);
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this._internal.removeListener(listener);
    }

    private final void removeClearedEntries() {
        Reference<V> r = this._clearQueue.poll();
        while (r != null) {
            Object key = ((Entry)r).getKey();
            this._cacheMap.remove(key);
            r = this._clearQueue.poll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<K, V>
    extends WeakReference<V>
    implements ICacheEntry<K, V> {
        private final K _key;

        public Entry(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this._key = key;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public boolean isDirty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDirty(boolean dirty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Serializer getSerializer() {
            throw new UnsupportedOperationException();
        }
    }
}

