/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import jdbm.extser.Stateless;
import jdbm.helper.Conversion;
import jdbm.helper.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleSerializer
implements Serializer<Double>,
Stateless {
    public static final transient Serializer<Double> INSTANCE = new DoubleSerializer();
    private static final long serialVersionUID = 4148669273975369802L;

    @Override
    public byte[] serialize(Double obj) throws IOException {
        long bits = Double.doubleToRawLongBits(obj);
        return Conversion.convertToByteArray(bits);
    }

    @Override
    public Double deserialize(byte[] serialized) throws IOException {
        long bits = Conversion.convertToLong(serialized);
        return new Double(Double.longBitsToDouble(bits));
    }
}

