/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser.profiler;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jdbm.extser.AbstractExtensibleSerializer;
import jdbm.extser.ISerializer;
import jdbm.extser.profiler.ClassStatistics;
import jdbm.extser.profiler.Statistics;

public class Profiler
extends Statistics {
    private final AbstractExtensibleSerializer serializer;
    private boolean enabled = false;
    private Map classStatistics;

    public boolean enable(boolean val) {
        boolean tmp = this.enabled;
        this.enabled = val;
        return tmp;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.enabled && (this.nread > 0L || this.nwritten > 0L)) {
            this.writeOn(System.err);
        }
    }

    public Profiler(AbstractExtensibleSerializer serializer) {
        super(serializer);
        this.reset();
        this.serializer = serializer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClassStatistics get(int classId) {
        Integer classId2 = new Integer(classId);
        ClassStatistics stats = (ClassStatistics)this.classStatistics.get(classId2);
        if (stats == null) {
            stats = new ClassStatistics(this.getSerializer(), classId);
            this.classStatistics.put(classId2, stats);
        }
        return stats;
    }

    public synchronized void serialized(ISerializer ser, int classId, short versionId, int nbytes) {
        if (this.enabled) {
            ++this.nread;
            this.bytesRead += (long)nbytes;
            this.get(classId).read(ser, versionId, nbytes);
        }
    }

    public synchronized void deserialized(ISerializer ser, int classId, short versionId, int nbytes) {
        if (this.enabled) {
            ++this.nwritten;
            this.bytesWritten += (long)nbytes;
            this.get(classId).write(ser, versionId, nbytes);
        }
    }

    public void writeOn(PrintStream ps) {
        ps.println("----- serialization statistics -----");
        ps.println("read(#read,#bytesRead,avgPerRead), write(#written,#bytesWritten,avgPerWrite)");
        super.writeOn(ps);
        for (ClassStatistics stats : this.classStatistics.values()) {
            stats.writeOn(ps);
        }
        ps.println("------------------------------------");
    }

    public void reset() {
        super.reset();
        this.classStatistics = new HashMap();
    }
}

