/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IExtensibleSerializer;
import jdbm.extser.ISerializer;
import jdbm.extser.ISimpleSerializer;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.LongPacker;
import jdbm.extser.NativeType;
import jdbm.extser.SerializerIdProtocol;
import jdbm.extser.ShortPacker;
import jdbm.extser.Stateless;
import jdbm.extser.StringSerializer;
import jdbm.extser.profiler.Profiler;

public abstract class AbstractExtensibleSerializer
implements Externalizable,
IExtensibleSerializer {
    private static final long serialVersionUID = -8387008101267090833L;
    private Profiler _profiler = new Profiler(this);
    private int m_nextClassId;
    private Map m_classId = null;
    private Map m_className = null;
    private Map m_serializer = null;
    private transient Map m_versionIds = new WeakHashMap();
    private transient Map _cache = new HashMap();
    private static final transient int VERSION_MASK = 1;
    private static final transient int SERIALIZER_MASK = 2;
    private static final transient int STATELESS_MASK = 4;
    private static final transient int RESERVED_MASK = 8;
    private static final transient int NBITFIELDS = 4;
    private static final transient int SIZEOF_LONG = 8;
    private static final transient int SIZEOF_INT = 4;
    private static final transient int SIZEOF_SHORT = 2;
    private static final transient int SIZEOF_BYTE = 1;
    private static final transient short VERSION = 0;

    public Profiler getProfiler() {
        return this._profiler;
    }

    protected abstract void update();

    protected static int writeDataHeader(DataOutput os, int classId, short versionId, boolean stateless, long serializerId) throws IOException {
        int tmp = classId << 4;
        if (versionId != 0) {
            if (stateless) {
                throw new AssertionError();
            }
            tmp |= 1;
        }
        if (serializerId != 0L) {
            if (stateless) {
                throw new AssertionError();
            }
            tmp |= 2;
        }
        if (stateless) {
            tmp |= 4;
        }
        int nbytes = os.writePackedInt(tmp);
        if (versionId != 0) {
            os.writePackedShort(versionId);
            nbytes += 2;
        }
        if (serializerId != 0L) {
            nbytes += os.writePackedLong(serializerId);
        }
        return nbytes;
    }

    public synchronized byte[] serialize(long recid, Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = this.getDataOutputStream(recid, baos);
        dos.serialize(obj);
        dos.flush();
        dos.close();
        return baos.toByteArray();
    }

    public synchronized Object deserialize(long recid, byte[] serialized) throws IOException {
        DataInputStream dis = this.getDataInputStream(recid, new MyByteArrayInputStream(serialized));
        Object obj = dis.deserialize();
        return obj;
    }

    protected static Object newInstance(Class cl) {
        try {
            Object obj = cl.newInstance();
            return obj;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not create instance: " + cl, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Could not create instance: " + cl, ex);
        }
    }

    public synchronized short getVersionId(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        Short versionId = (Short)this.m_versionIds.get(cl);
        if (versionId == null) {
            try {
                Field f = cl.getField("SERIAL_VERSION_ID");
                Object val = f.get(null);
                if (!(val instanceof Short)) {
                    throw new RuntimeException("Field has wrong datatype: SERIAL_VERSION_ID on " + cl.getName());
                }
                versionId = (Short)val;
                this.m_versionIds.put(cl, versionId);
            }
            catch (NullPointerException ex) {
                RuntimeException ex2 = new RuntimeException("Field must be static: SERIAL_VERSION_ID on " + cl.getName());
                ex2.initCause(ex);
                throw ex2;
            }
            catch (NoSuchFieldException ex) {
                return 0;
            }
            catch (IllegalAccessException ex) {
                RuntimeException ex2 = new RuntimeException("Unable to access SERIAL_VERSION_ID on " + cl.getName());
                ex2.initCause(ex);
                throw ex2;
            }
        }
        return versionId;
    }

    public synchronized void invalidateVersionIdCache(Class cl) {
        if (cl == null) {
            this.m_versionIds.clear();
        } else {
            this.m_versionIds.remove(cl);
        }
    }

    public synchronized long getSerializerId(long recid, Object obj) {
        if (obj instanceof SerializerIdProtocol) {
            return ((SerializerIdProtocol)obj).getSerializerId(recid);
        }
        return 0L;
    }

    public synchronized int getClassCount() {
        if (this.m_classId == null) {
            return 0;
        }
        return this.m_nextClassId;
    }

    private synchronized int getNextClassId() {
        return this.m_nextClassId++;
    }

    public synchronized int getClassId(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        this.registerSerializers();
        String name = cl.getName();
        Integer classId = (Integer)this.m_className.get(name);
        if (classId == null) {
            boolean updated = this._registerClass(cl);
            classId = (Integer)this.m_className.get(name);
            if (classId == null) {
                throw new AssertionError();
            }
            this.update();
        }
        return classId;
    }

    protected synchronized void registerSerializers() {
        if (this.m_classId != null) {
            return;
        }
        this.m_nextClassId = 18;
        this.m_classId = new HashMap();
        this.m_className = new HashMap();
        this.m_serializer = new HashMap();
        this.setupSerializers();
        this.update();
    }

    protected void setupSerializers() {
        this._registerClass(String.class, StringSerializer.class, (short)0);
    }

    public synchronized boolean registerClass(Class cl) {
        if (this._registerClass(cl)) {
            this.update();
            return true;
        }
        return false;
    }

    public synchronized boolean registerSerializer(Class cl, Class serializerClass) {
        return this.registerSerializer(cl, serializerClass, (short)0);
    }

    public synchronized boolean registerSerializer(Class cl, Class serializerClass, short versionId) {
        if (this._registerClass(cl, serializerClass, versionId)) {
            this.update();
            return true;
        }
        return false;
    }

    protected synchronized boolean _registerClass(Class cl, Class serializerClass, short versionId) {
        String oldClassName;
        String newClassName;
        HashMap<Short, String> versions;
        if (cl == null) {
            throw new IllegalArgumentException("class is null.");
        }
        if (serializerClass == null) {
            throw new IllegalArgumentException("serializer class is null.");
        }
        if (!ISerializer.class.isAssignableFrom(serializerClass)) {
            throw new IllegalArgumentException("Class does not implement " + ISerializer.class.getName() + ": serializerClass=" + serializerClass.getName());
        }
        ISerializer serializer = (ISerializer)this._cache.get(serializerClass.getName());
        if (serializer == null) {
            serializer = (ISerializer)AbstractExtensibleSerializer.newInstance(serializerClass);
            this._cache.put(serializerClass.getName(), serializer);
        }
        this.registerSerializers();
        String name = cl.getName();
        Integer classId = (Integer)this.m_className.get(name);
        boolean updated = false;
        if (classId == null) {
            classId = new Integer(this.getNextClassId());
            this.m_className.put(name, classId);
            this.m_classId.put(classId, name);
            updated = true;
        }
        if ((versions = (HashMap<Short, String>)this.m_serializer.get(classId)) == null) {
            versions = new HashMap<Short, String>();
            this.m_serializer.put(classId, versions);
        }
        if (!(newClassName = serializerClass.getName()).equals(oldClassName = versions.put(new Short(versionId), newClassName))) {
            updated = true;
            if (oldClassName != null) {
                System.err.println("WARN: Replacing serializer: record class=" + name + ", oldSerializer=" + oldClassName + ", newSerializer=" + newClassName);
            }
        }
        return updated;
    }

    protected synchronized boolean _registerClass(Class cl) {
        this.registerSerializers();
        String name = cl.getName();
        Integer classId = (Integer)this.m_className.get(name);
        if (classId == null) {
            classId = new Integer(this.getNextClassId());
            this.m_className.put(name, classId);
            this.m_classId.put(classId, name);
            return true;
        }
        return false;
    }

    public synchronized String getClassName(int classId) {
        if (classId == 0) {
            return null;
        }
        this.registerSerializers();
        String name = (String)this.m_classId.get(new Integer(classId));
        if (name == null) {
            throw new IllegalArgumentException("Unknown classId=" + classId);
        }
        return name;
    }

    public synchronized Class getClass(int classId) {
        String className = this.getClassName(classId);
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("class=" + className, ex);
        }
        return cl;
    }

    public synchronized ISerializer getSerializer(int classId, short versionId) {
        this.registerSerializers();
        Map versions = (Map)this.m_serializer.get(new Integer(classId));
        if (versions == null) {
            return null;
        }
        String className = (String)versions.get(new Short(versionId));
        if (className != null) {
            ISerializer serializer = (ISerializer)this._cache.get(className);
            if (serializer == null) {
                Class<?> cl;
                try {
                    cl = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                serializer = (ISerializer)AbstractExtensibleSerializer.newInstance(cl);
                this._cache.put(className, serializer);
            }
            return serializer;
        }
        return null;
    }

    public synchronized void writeOn(PrintStream ps) {
        ps.println("# Grammar: (classId -> className ([ versionId -> serializer ])*;)*");
        if (this.m_classId == null) {
            return;
        }
        for (Map.Entry entry : this.m_classId.entrySet()) {
            Integer classId = (Integer)entry.getKey();
            String className = (String)entry.getValue();
            ps.print(classId + "\t->\t" + className);
            Map versions = (Map)this.m_serializer.get(classId);
            if (versions != null && versions.size() > 0) {
                ps.println("");
                for (Map.Entry entry2 : versions.entrySet()) {
                    Short versionId = (Short)entry2.getKey();
                    String serializerClass = (String)entry2.getValue();
                    ps.println("[ " + versionId + "\t->\t" + serializerClass + " ]");
                }
                ps.println(";");
                continue;
            }
            ps.println(" ;");
        }
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(0);
        switch (0) {
            case 0: {
                this.writeExternal0(out);
                break;
            }
            default: {
                throw new IOException("Unknown version=0");
            }
        }
    }

    private synchronized void writeExternal0(ObjectOutput out) throws IOException {
        out.writeInt(this.m_nextClassId);
        out.writeObject(this.m_classId);
        out.writeObject(this.m_className);
        out.writeObject(this.m_serializer);
    }

    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        switch (version) {
            case 0: {
                this.readExternal0(in);
                break;
            }
            default: {
                throw new IOException("Unknown version=" + version);
            }
        }
    }

    private void readExternal0(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_nextClassId = in.readInt();
        this.m_classId = (HashMap)in.readObject();
        this.m_className = (HashMap)in.readObject();
        this.m_serializer = (HashMap)in.readObject();
    }

    public static abstract class DataInputStream
    extends java.io.DataInputStream
    implements DataInput {
        private final MyByteArrayInputStream _bais;
        private final long _recid;
        private final IExtensibleSerializer _serializer;

        public final long getRecid() {
            return this._recid;
        }

        public final IExtensibleSerializer getSerializationHandler() {
            return this._serializer;
        }

        protected DataInputStream(long recid, IExtensibleSerializer serializer, ByteArrayInputStream is) throws IOException {
            super(is);
            this._recid = recid;
            this._serializer = serializer;
            this._bais = (MyByteArrayInputStream)is;
        }

        public long readPackedLong() throws IOException {
            return LongPacker.unpackLong(this);
        }

        public int readPackedInt() throws IOException {
            return (int)this.readPackedLong();
        }

        public short readPackedShort() throws IOException {
            return ShortPacker.unpackShort(this);
        }

        public Object deserialize() throws IOException {
            ISerializer serializer;
            int classId = this.readPackedInt();
            boolean hasVersionId = (classId & 1) != 0;
            boolean hasSerializerId = (classId & 2) != 0;
            boolean stateless = (classId & 4) != 0;
            short versionId = hasVersionId ? this.readPackedShort() : (short)0;
            long serializerId = hasSerializerId ? this.readPackedLong() : 0L;
            IExtensibleSerializer ser = this.getSerializationHandler();
            if ((classId >>= 4) >= 0 && classId <= 17) {
                Object obj = NativeType.deserialize(this, classId, versionId);
                ser.getProfiler().deserialized(ser, classId, versionId, this._bais.position());
                return obj;
            }
            long recid = this.getRecid();
            int nclasses = ser.getClassCount();
            if (classId <= 0 || classId > nclasses) {
                throw new IOException("Invalid header: classId=" + classId + ", but only [1:" + nclasses + "] are valid.");
            }
            if (stateless) {
                Class cl = ser.getClass(classId);
                Object obj = AbstractExtensibleSerializer.newInstance(cl);
                ser.getProfiler().deserialized(ser, classId, versionId, this._bais.position());
                return obj;
            }
            int headerSize = 4 + (hasVersionId ? 2 : 0) + (hasSerializerId ? 8 : 0);
            ISerializer iSerializer = serializer = serializerId != 0L ? ser.getSerializer(serializerId) : ser.getSerializer(classId, versionId);
            if (serializerId != 0L && serializer == null) {
                throw new IOException("Serializer not found: classId=" + classId + ", class=" + ser.getClassName(classId) + ", serializerId=" + serializerId);
            }
            if (versionId != 0 && serializer == null) {
                throw new IOException("Serializer not registered: classId=" + classId + ", class=" + ser.getClassName(classId) + ", versionId=" + versionId);
            }
            if (serializer != null) {
                if (serializer instanceof ISimpleSerializer) {
                    int dataSize = this.readPackedInt();
                    byte[] serialized = new byte[dataSize];
                    this.readFully(serialized);
                    Object obj = ((ISimpleSerializer)serializer).deserialize(serialized);
                    ser.getProfiler().deserialized(serializer, classId, versionId, this._bais.position());
                    return obj;
                }
                if (serializer instanceof IStreamSerializer) {
                    Class cl = ser.getClass(classId);
                    Object obj = AbstractExtensibleSerializer.newInstance(cl);
                    obj = ((IStreamSerializer)serializer).deserialize(this, obj);
                    ser.getProfiler().deserialized(serializer, classId, versionId, this._bais.position());
                    return obj;
                }
                throw new IOException("Unknown ISerializer family: " + serializer.getClass());
            }
            Class cl = ser.getClass(classId);
            ObjectInputStream ois = new ObjectInputStream(this);
            if (Externalizable.class.isAssignableFrom(cl)) {
                Object obj = AbstractExtensibleSerializer.newInstance(cl);
                try {
                    ((Externalizable)obj).readExternal(ois);
                    int nbytes = this._bais.position();
                    ser.getProfiler().deserialized(ser, classId, versionId, nbytes);
                    return obj;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("While deserializing class=" + ser.getClassName(classId), ex);
                }
            }
            if (Serializable.class.isAssignableFrom(cl)) {
                try {
                    Object obj = ois.readObject();
                    ser.getProfiler().deserialized(ser, classId, versionId, this._bais.position());
                    return obj;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("While deserializing class=" + ser.getClassName(classId), ex);
                }
            }
            throw new UnsupportedOperationException("Do not know how to deserialize: class=" + ser.getClassName(classId));
        }
    }

    private class MyByteArrayInputStream
    extends ByteArrayInputStream {
        public MyByteArrayInputStream(byte[] data) {
            super(data);
        }

        int position() {
            return this.pos;
        }
    }

    public static abstract class DataOutputStream
    extends java.io.DataOutputStream
    implements DataOutput {
        private final ByteArrayOutputStream _baos;
        private final long _recid;
        private final IExtensibleSerializer _serializer;

        public final long getRecid() {
            return this._recid;
        }

        public final IExtensibleSerializer getSerializationHandler() {
            return this._serializer;
        }

        public int writePackedLong(long val) throws IOException {
            return LongPacker.packLong(this, val);
        }

        public int writePackedInt(int val) throws IOException {
            return this.writePackedLong(val);
        }

        public int writePackedShort(short val) throws IOException {
            return ShortPacker.packShort(this, val);
        }

        protected DataOutputStream(long recid, IExtensibleSerializer serializer, ByteArrayOutputStream baos) throws IOException {
            super(baos);
            this._recid = recid;
            this._serializer = serializer;
            this._baos = baos;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serialize(Object obj) throws IOException {
            ISerializer serializer;
            IExtensibleSerializer ser = this.getSerializationHandler();
            int classId = NativeType.getNativeType(obj);
            if (classId >= 0 && classId <= 17) {
                boolean versionId = false;
                boolean stateless = false;
                long serializerId = 0L;
                AbstractExtensibleSerializer.writeDataHeader(this, classId, (short)0, false, 0L);
                NativeType.serialize(this, classId, obj);
                ser.getProfiler().serialized(ser, classId, (short)0, this._baos.size());
                return;
            }
            long recid = this.getRecid();
            Class<?> cl = obj.getClass();
            classId = ser.getClassId(cl);
            boolean stateless = obj instanceof Stateless;
            if (stateless) {
                boolean versionId = false;
                long serializerId = 0L;
                AbstractExtensibleSerializer.writeDataHeader(this, classId, (short)0, stateless, 0L);
                ser.getProfiler().serialized(ser, classId, (short)0, this._baos.size());
                return;
            }
            short versionId = ser.getVersionId(cl);
            long serializerId = ser.getSerializerId(recid, obj);
            ISerializer iSerializer = serializer = serializerId != 0L ? ser.getSerializer(serializerId) : ser.getSerializer(classId, versionId);
            if (serializerId != 0L && serializer == null) {
                throw new IOException("Serializer not found: classId=" + classId + ", class=" + ser.getClassName(classId) + ", serializerId=" + serializerId);
            }
            AbstractExtensibleSerializer.writeDataHeader(this, classId, versionId, stateless, serializerId);
            if (serializer != null) {
                if (serializer instanceof IStreamSerializer) {
                    ((IStreamSerializer)serializer).serialize(this, obj);
                    ser.getProfiler().serialized(serializer, classId, versionId, this._baos.size());
                    return;
                } else {
                    if (!(serializer instanceof ISimpleSerializer)) throw new IOException("Unknown ISerializer family: " + serializer.getClass());
                    byte[] data = ((ISimpleSerializer)serializer).serialize(obj);
                    int length = data.length;
                    this.writePackedInt(data.length);
                    this.write(data);
                    ser.getProfiler().serialized(serializer, classId, versionId, this._baos.size());
                }
                return;
            } else {
                ObjectOutputStream oos = new ObjectOutputStream(this);
                if (obj instanceof Externalizable) {
                    ((Externalizable)obj).writeExternal(oos);
                } else {
                    if (!(obj instanceof Serializable)) throw new IOException("Do not know how to serialize: " + obj.getClass());
                    oos.writeObject(obj);
                }
                oos.flush();
                oos.close();
                ser.getProfiler().serialized(ser, classId, versionId, this._baos.size());
            }
        }
    }
}

