var gMM3ProxySwitch = null;
var oPrefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
var noEvent=false;

function MM3ProxySwitch(){
	gMM3ProxySwitch = this;

	window.removeEventListener('load', this, true);

this.init=function(){try{//log("init");

	try{
		oPrefs.getIntPref('network.proxy.MM3ProxySwitch.type');
	}
	catch(ex){
		oPrefs.setIntPref('network.proxy.MM3ProxySwitch.type', 0);
	}
	
	var myPrefObserver = {
		register: function(){
			//http://kb.mozillazine.org/Category:Preferences
			//http://developer.mozilla.org/en/docs/Code_snippets:Preferences
			//http://developer.mozilla.org/en/docs/Adding_preferences_to_an_extension
			//nsIPrefBranchInternal Gecko 1.7
			//nsIPrefBranch2        Gecko 1.8
			var prefService = Components.classes["@mozilla.org/preferences-service;1"]
												.getService(Components.interfaces.nsIPrefService);
			this._branch = prefService.getBranch("network.");
			this._branch.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			this._branch.addObserver("proxy", this, false);
		},

		unregister: function(){
			if(!this._branch) return;
			this._branch.removeObserver("proxy", this);
		},

		observe: function(subject, topic, data) { if(!noEvent) gMM3ProxySwitch.selectUI(); }
	}
	myPrefObserver.register();

	window.addEventListener("unload", function(e) { myPrefObserver.unregister(); }, false);

	gMM3ProxySwitch.updateUI();

	try{	// version <2007.390
		var imortIE=oPrefs.getBoolPref('network.proxy.MM3ProxySwitch.importIE');
		oPrefs.clearUserPref('network.proxy.MM3ProxySwitch.importIE');

		//thunderbird1.5 map.key > map['key']

		if(imortIE){
			var map = gMM3ProxySwitch.load();
			if(map['import']==null){
				map['import']='IE';
				var text = gMM3ProxySwitch.format(map);
				gMM3ProxySwitch.save(text);
			}
		}
	}catch(ex){}
	

	var map = gMM3ProxySwitch.load();

	var v = map['testUrl'];
	if(v!=null) testUrl(v);

	v = map['import'];
	if(v!=null){
		v = v.toUpperCase();
				 if(v.indexOf('IP' )>=0) initIP(v); 
		else if(v.indexOf('DNS')>=0) initDNS(v);
				 if(v.indexOf('IE' )>=0) initIE();
	}

}catch(ex){err("init", ex);}}

this.updateUIDragDrop=function(){try{//log("updateUIDragDrop");
gMM3ProxySwitch.updateUI();
}catch(ex){err("updateUIDragDrop", ex);}}

this.updateUI=function(){try{//log("updateUI");

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	if(list==null) return;

	var items = list.getElementsByAttribute('type', 'checkbox');
	for(var i = items.length; i-->0;){
		var item = items[i];
		var id = item.getAttribute('key');
		if(id!=null && id.length>0){
			try{
				var key    = document.getElementById(id);
				var parent = key.parentNode;
				parent.removeChild(key);
			}catch(ex){err('keySet',ex);}
		}
		list.removeChild(item);
	}

	var keysets = document.getElementsByTagName('keyset');

	var proxys = this.load();
	for(var name in proxys){
		var proxy = proxys[name];
		if(typeof(proxy)!='string'){
			var item = document.createElement('menuitem');
			item.setAttribute('label',     name);
			item.setAttribute('type',      'checkbox');
			item.setAttribute('oncommand', 'gMM3ProxySwitch.selectProxyItem(this); event.stopPropagation();');

			try{
				var keycode = proxy['keycode'];
				if(keycode!=null){
					var modifiers = proxy['modifiers'];

					var key = document.createElement('key');
					key.setAttribute('id',        'key_MM3_'+name);
					key.setAttribute('oncommand', 'gMM3ProxySwitch.selectProxyKey(this)');
					key.setAttribute(keycode.length>=4 ? 'keycode' : 'key', keycode); //VK_
					if(modifiers!=null)key.setAttribute('modifiers', modifiers); 

					keysets[0].appendChild(key);
					item.setAttribute('key', 'key_MM3_'+name);
				}
			}catch(ex){err('Error add KeyCode',ex);}

			var info ='';
			for(var protocol in proxy) info+=protocol+'='+proxy[protocol]+' ';
			item.setAttribute('tooltiptext', info);
			list.appendChild(item);
		}
	}

	this.selectUI();
}catch(ex){err("updateUI", ex);}}
	
this.selectUI=function(){try{//log("selectUI");
	onOffProxyUI();

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	var items = list.getElementsByAttribute('type', 'checkbox');
	for(var i = items.length; i-->0;) items[i].setAttribute('checked', 'false'); //string > true false

	var tooltip =getText('manual');
	var proxys = this.load();

	var type = oPrefs.getIntPref('network.proxy.type');
	if(type==0) type = oPrefs.getIntPref('network.proxy.MM3ProxySwitch.type');

	if(type==1){
		var http  = getProxy('http');
		var ssl   = getProxy('ssl');
		var ftp   = getProxy('ftp');
		var gopher= getProxy('gopher');
		var socks = getProxy('socks');

		var isShare=false;
		try{
			isShare = oPrefs.getBoolPref('network.proxy.share_proxy_settings');
		}
		catch(ex){}

		if(isShare || (http==ssl && http==ftp && http==gopher && http==socks)){
			for(var i = items.length; i-->0;){
				var name  = items[i].getAttribute('label');
				var proxy = proxys[name];

				if(http==proxy['all']){
					tooltip = name;
					items[i].setAttribute('checked', 'true');
					break;
				}
			}
		}
		else{

			for(var i = items.length; i-->0;){
				var name  = items[i].getAttribute('label');
				var proxy = proxys[name];

				if (http  == proxy['http']
				 && ftp   == proxy['ftp']
				 && ssl   == proxy['ssl']
				 && gopher== proxy['gopher']
				 && socks == proxy['socks']){
					//noProxy?

					tooltip = name;
					items[i].setAttribute('checked', 'true');
					break;
				}
			}
		}
	}
	else if(type==2){

		var url = oPrefs.getCharPref('network.proxy.autoconfig_url');
		for(var i = items.length; i-->0;){
			var name  = items[i].getAttribute('label');
			var proxy = proxys[name];

			if(url == proxy['url']){
				tooltip = name;
				items[i].setAttribute('checked', 'true');
				break;
			}
		}
	}

	var button = document.getElementById('MM3ProxySwitch-Toolbar-button');
	button.setAttribute('label', tooltip); //proxy configuration name
	//document.getElementById('MM3ProxySwitch-Toolbar-button2').setAttribute('value', tooltip); //statusbar

	button.setAttribute('tooltiptext', getText2(
				(oPrefs.getIntPref('network.proxy.type')==0	?'switchFromDirect':'switchToDirect'), [tooltip]));
}catch(ex){err("selectUI", ex);}}

var getProxy=function(protocol){
	var host = oPrefs.getCharPref('network.proxy.'+protocol);
	var port = oPrefs.getIntPref( 'network.proxy.'+protocol+'_port');
	return host.length>0 && port>0
					? host+':'+port
					: null;
}

//firefox statusbar
this.onOffProxyClick=function(e){
	if(e.button && e.button!=0) return;  //0Left 1Middle 2Right 
	this.onOffProxy();
}

this.onOffProxy=function(){try{//log('onOffProxy');

	var proxy=null;
	var list=document.getElementById('MM3ProxySwitch-popup-list');
	var items = list.getElementsByAttribute('type', 'checkbox');
	for(var i = items.length; i-->0;){
		if(items[i].getAttribute('checked')=='true'){
			var proxys = this.load();
			proxy = proxys[items[i].getAttribute('label')];
			break;
		}
	}

	var type=oPrefs.getIntPref('network.proxy.type');
	if(type==0){
		type=oPrefs.getIntPref('network.proxy.MM3ProxySwitch.type');
		if(type==0){
			if(proxy!=null) type = proxy['url']!=null ? 2 : 1;
		}
	}
	else type=0;
	oPrefs.setIntPref('network.proxy.type', type);
	if(proxy!=null){
		if(proxy['export']!=null) exportIE(proxy, type==1 ? 1 : 0);
		if( type!=0 && proxy['clear']!=null) clearCache();
	}

	onOffProxyUI();
}catch(ex){err('onOffProxy', ex);}}

var onOffProxyUI=function(){try{//log('onOffProxyUI');

	var b = document.getElementById('MM3ProxySwitch-Toolbar-button');
	var is = b.getAttribute('pbbstatus');
	var so = oPrefs.getIntPref('network.proxy.type')==0 ? 'off' : 'on';
	
	if(is!=so) b.setAttribute('pbbstatus', so);
	//.setAttribute("src", "chrome://mm3-proxyswitch/skin/MM3Small"+(oPrefs.getIntPref('network.proxy.type')==0 ? 'Off' : 'On')+".png"); //icon
}catch(ex){err('onOffProxyUI', ex);}}

this.selectProxyKey=function(item){

	var name = item.id.substring(8); //key_MM3_

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	if(list!=null){
		var items = list.getElementsByAttribute('type', 'checkbox');
		for(var i = items.length; i-->0;){
			item = items[i];
			if(item.getAttribute('label')==name){
				if(item.getAttribute('checked')=='true'){
					this.onOffProxy();
					return;
				}
				break;
			}
		}
	}
	selectProxy(name, true);
}

this.selectProxyItem=function(item){selectProxy(item.getAttribute('label'), true);}
var selectProxy=function(name, manual){try{//log('selectProxy');

	noEvent=true;

	var proxys= gMM3ProxySwitch.load();
	var proxy = proxys[name];

	var type=0;
	if(proxy['url']!=null){
		type = 2;
		oPrefs.setCharPref('network.proxy.autoconfig_url', proxy['url']);
	}
	else{
		type = 1;
		if(proxy['all']!=null){
			var host = proxy['all'];
			var port=0;
			if(host==null) host='';
			else{
				port=80;
				var index = host.indexOf(':');
				if(index > -1){
					port = parseInt(host.substring(index + 1));
					host = host.substring(0, index);
				}
			}
			oPrefs.setCharPref('network.proxy.http',       host);
			oPrefs.setIntPref ('network.proxy.http_port',  port);
			oPrefs.setCharPref('network.proxy.ssl',        host);
			oPrefs.setIntPref ('network.proxy.ssl_port',   port);
			oPrefs.setCharPref('network.proxy.ftp',        host);
			oPrefs.setIntPref ('network.proxy.ftp_port',   port);
			oPrefs.setCharPref('network.proxy.gopher',     host);
			oPrefs.setIntPref ('network.proxy.gopher_port',port);
			oPrefs.setCharPref('network.proxy.socks',      host);
			oPrefs.setIntPref ('network.proxy.socks_port', port);

			oPrefs.setBoolPref('network.proxy.share_proxy_settings', true);
		}
		else{
			oPrefs.setBoolPref('network.proxy.share_proxy_settings', false);
			setProxy('http'  ,proxy);
			setProxy('ssl'   ,proxy);
			setProxy('ftp'   ,proxy);
			setProxy('gopher',proxy);
			setProxy('socks' ,proxy);
		}
		oPrefs.setCharPref('network.proxy.no_proxies_on', proxy['noProxy']!=null ? proxy['noProxy'] : '');
	}
	
	oPrefs.setIntPref('network.proxy.MM3ProxySwitch.type', type);
	if(proxy['direct']=='yes'){
		type=0;
	}
	if(oPrefs.getIntPref('network.proxy.type')!=type) oPrefs.setIntPref('network.proxy.type', type);

	if(proxy['export']!=null) exportIE(proxy, type==1 ? 1 : 0);
	if(type!=0 && proxy['clear']!=null) clearCache();
	if(manual && proxy['homepage']!=null){
		try{
		var browser = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator)
								.getMostRecentWindow("navigator:browser").getBrowser();
		browser.selectedTab = browser.addTab(proxy['homepage'], null); //document.location.href=proxy['homepage'];
		}catch (ex){ err('load HomePage: '+proxy['homepage'],ex); }
	}
	noEvent=false;
	gMM3ProxySwitch.selectUI();
}catch(ex){err('selectProxy', ex);}}

var setProxy=function(protocol, proxy){

	var host = proxy[protocol];

	if(host==getProxy(protocol)) return;

	var port=0;
	if(host==null) host='';
	else{
		port=80;
		var index = host.indexOf(':');
		if(index > -1){
			port = parseInt(host.substring(index + 1));
			host = host.substring(0, index);
		}
	}
	oPrefs.setCharPref('network.proxy.'+protocol,         host);
	oPrefs.setIntPref ('network.proxy.'+protocol+'_port', port);
}

//https://developer.mozilla.org/En/Reading_textual_data
this.load=function(){try{//log('load');

	var map = new Object();

	var file = Components.classes['@mozilla.org/file/directory_service;1']
					 .getService(Components.interfaces.nsIProperties)
					 .get('ProfD', Components.interfaces.nsIFile);
	file.append('MM3-ProxySwitch.txt');

	if(!file.exists()) this.save('[MM3-WebAssistant\nhttp=127.0.0.1:8080\nftp=127.0.0.1:8080\nssl=127.0.0.1:8080\nnoProxy=127.0.0.1:8080\nclear=cache\n]\n');

	if(file.exists()){
		var fis = Components.classes['@mozilla.org/network/file-input-stream;1']
						.createInstance(Components.interfaces.nsIFileInputStream);
		fis.init(file, 0x01, 0444, 0);
		fis.QueryInterface(Components.interfaces.nsILineInputStream);

		var is = Components.classes["@mozilla.org/intl/converter-input-stream;1"]
						.createInstance(Components.interfaces.nsIConverterInputStream);
		is.init(fis, "UTF-8", 8192, Components.interfaces.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);	//0xFFFD

		if(is instanceof Components.interfaces.nsIUnicharLineInputStream){
			var map = loadRec(is);
			all(map);
		}
		is.close();
	}

	return map;
}catch(ex){err('load', ex);}}

var loadRec=function(is){try{
	var map = new Object();

	var str = {};
	while(is.readLine(str)){
		var line   = trim(str.value);
		var length = line.length;
		var c='#';

				 if(length>=1 && (c=line.charAt(0))==']') return map;
		else if(length>=2 &&  c                =='[') map[trim(line.substring(1))] = loadRec(is);
		else if(length>=3 &&  c                !='#'){
			var index = line.indexOf('=', 1);
			if(index>=1){
				var key   = trim(line.substring(0, index));
				var value = trim(line.substring(index+1));
				if(value.length>0){
					key = key.toLowerCase();
							 if(key=='noproxy') key='noProxy';
					else if(key=='testurl') key='testUrl';
					map[key]= value;
				}
			}
		}
	}

	return map;
}catch(ex){err('loadRec', ex);}}

var all=function(map){
	for(var name in map){
		var proxy = map[name];
		if(typeof(proxy)!='string'){
			var http  = hp('http',  proxy);
			var ssl   = hp('ssl',   proxy);
			var ftp   = hp('ftp',   proxy);
			var gopher= hp('gopher',proxy);
			var socks = hp('socks', proxy);

			if(http!=null && http==ssl && http==ftp && http==gopher && http==socks){
				porxy = new Object();
				proxy['all'] = http;
				map[name]=proxy;
			}
		}
	}
}

var hp=function(protocol, proxy){
	var host = proxy[protocol];
	if(host!=null){
		var port=80;
		var index = host.indexOf(':');
		if(index!=-1){
			port = parseInt(host.substring(index + 1));
			if(isNaN(port)) port=80;
			host = host.substring(0, index);
		}
		host+=':'+port;
		proxy[protocol]=host;
	}

	return host;
}

var trim=function(str){
	str = str.replace(new RegExp('^[\\s\\n\\r]*', 'g'), '');
	str = str.replace(new RegExp('[\\s\\n\\r]*$', 'g'), '');

	return str;
}


this.format=function(map){try{//log('format');
	var proxy ='';
	var config='';

	for(var key in map){
		var obj = map[key];
		if(obj!=null){
			if(typeof(obj)=='string'){
				config+=key+'='+obj+'\n';
			}
			else{
				proxy+='['+key+'\n';
				for(var protocol in obj) proxy+='  '+protocol+'='+obj[protocol]+'\n';
				proxy+=']\n';
			}
		}
	}

	return proxy+config;
}catch(ex){err('format', ex);}}

//https://developer.mozilla.org/en/Writing_textual_data
this.save=function(text){try{//log('save');

	var file = Components.classes['@mozilla.org/file/directory_service;1']
						.getService(Components.interfaces.nsIProperties)
						.get('ProfD', Components.interfaces.nsIFile);
	file.append('MM3-ProxySwitch.txt');

	var fos = Components.classes['@mozilla.org/network/file-output-stream;1']
					 .createInstance(Components.interfaces.nsIFileOutputStream);
	fos.init(file, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate

	var os = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
					.createInstance(Components.interfaces.nsIConverterOutputStream);

	os.init(fos, "UTF-8", 0, 0x0000);
	os.writeString('#MM3-ProxySwitch 1\n\n'+text+'\n\n');
	os.close();
}catch(ex){err('save', ex);}}


//format import= [*] ip
var initIE=function(){try{//log('initIE');

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	if(list!=null && '@mozilla.org/windows-registry-key;1' in Components.classes){ // Firefox 1.5 or newer
		var item = document.createElement('menuitem');
		item.setAttribute('label',       getText('importIE'));
		item.setAttribute('tooltiptext', getText('importIETT'));
		item.setAttribute('oncommand',   'gMM3ProxySwitch.importIE(); event.stopPropagation();');
		list.insertBefore(item, list.firstChild.nextSibling);

		gMM3ProxySwitch.importIE();
	}
}catch(ex){err('initIE', ex);}}

this.importIE=function(){try{//log('importIE');

	var wrk = Components.classes['@mozilla.org/windows-registry-key;1'].createInstance(Components.interfaces.nsIWindowsRegKey);
	wrk.open(wrk.ROOT_KEY_CURRENT_USER,
					'SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\',
					wrk.ACCESS_READ);

	var IE = new Object();

	var url;
	if(wrk.hasValue('AutoConfigURL') && (url=wrk.readStringValue('AutoConfigURL'))!=null && url.length>0) IE['url'] = url;
	else{

		if(wrk.hasValue('ProxyEnable') && wrk.readIntValue('ProxyEnable')==1){
			var proxyServer;

			if(wrk.hasValue('ProxyServer') && (proxyServer=wrk.readStringValue('ProxyServer'))!=null && proxyServer.length>0){
				if(proxyServer.indexOf('=')==-1) IE['all']=proxyServer;
				else{
					var ps = proxyServer.split(";");
					for(var i = ps.length; i-->0;){
						var p = ps[i].split("=");
						IE[p[0]=='https' ? 'ssl' : p[0]] = p[1];
					}
				}
			}

			//http://www.mozilla.org/quality/networking/docs/aboutno_proxy_for.html
			var noProxies;
			if(wrk.hasValue('ProxyOverride') && (noProxies=wrk.readStringValue('ProxyOverride'))!=null && noProxies.length>0){
				var nps = noProxies.split(";");
				noProxies="";
				for(var i = nps.length; i-->0;){
					var noProxy = trim(nps[i]);
					if(noProxy.length>0){
						noProxies +=((noProxy == '<local>')  ? '127.0.0.1, localhost'
											: (noProxy.charAt(0)=='*') ? noProxy.substr(1) // *.a.a
											: 													 noProxy)
											+',';
					}
				}
				IE['noProxy'] = noProxies;
			}
		}
	}

	wrk.close();

	var proxys= this.load();
	proxys['IE']=IE;
	this.save(this.format(proxys));

	var list =document.getElementById('MM3ProxySwitch-popup-list');
	var items=list.getElementsByAttribute('type', 'checkbox');

	for(var i = items.length; i-->0;){
		if(items[i].getAttribute('label')=='IE'){
			 var info ='';
			 for(var protocol in IE) info+=protocol+'='+IE[protocol]+' ';
			 items[i].setAttribute('tooltiptext', info);
			 if(items[i].getAttribute('checked')=='true') selectProxy(items[i].getAttribute('label'), false);
			 return;
		}
	}
	this.updateUI();
}catch(ex){err('importIE',ex);}}

//format [name http=xxx export=ie]
var exportIE=function(proxy, useProxy){try{//log('exportIE '+proxy+' '+useProxy);

	var wrk = Components.classes['@mozilla.org/windows-registry-key;1'].createInstance(Components.interfaces.nsIWindowsRegKey);
	wrk.open(wrk.ROOT_KEY_CURRENT_USER,
					 'SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\',
					 wrk.ACCESS_WRITE);

	wrk.writeStringValue('AutoConfigURL', proxy['url']);

	var ps="";
	if(proxy['all']!=null)                  ps = proxy['all'];
	else{
		var p = proxy['http'  ]; if(p!=null)  ps+='http='  +p+';';
				p = proxy['ssl'   ]; if(p!=null)  ps+='https=' +p+';';
				p = proxy['ftp'   ]; if(p!=null)  ps+='ftp='   +p+';';
				p = proxy['gopher']; if(p!=null)  ps+='gother='+p+';';
				p = proxy['socks' ]; if(p!=null)  ps+='socks=' +p+';';
	}
	wrk.writeStringValue('ProxyServer', ps);
	
	ps="";
	if(proxy['noProxy']!=null){
		var nps = proxy['noProxy'].split(",");
		for(var i = nps.length; i-->0;){
			var noProxy = trim(nps[i]);
			if(noProxy.length>0){
				ps+= ((noProxy.charAt(0)=='.') ? "*"+noProxy	// .a.a
																			 :		 noProxy)
							+';';
			}
		}
	}
	wrk.writeStringValue('ProxyOverride', ps);

	wrk.writeIntValue('ProxyEnable', useProxy);

	wrk.close();
}catch(ex){err('exportIE',ex);}}

//format import= [*] ip [online]
var initIP=function(i){try{//log('initIP '+i);

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	if(list==null) return;

	var goOnline = i.indexOf('ONLINE')!=-1;
	
	//update only reStart
	var item = document.createElement('menuitem');
	item.setAttribute('label',       getText('importIP'));
	item.setAttribute('tooltiptext', getText('importIPTT'));
	item.setAttribute('oncommand',   'gMM3ProxySwitch.importIP('+goOnline+'); event.stopPropagation();');
	list.insertBefore(item, list.firstChild.nextSibling);

	
	if(i.indexOf('IP')==0) gMM3ProxySwitch.importIP(goOnline); //start with > autoconfig
}catch(ex){err('initIP',ex);}}

this.importIP=function(goOnline){try{//log('importIP '+goOnline);

	var dns = Components.classes['@mozilla.org/network/dns-service;1'].getService(Components.interfaces.nsIDNSService);

	var nsrecord=null;
	try{
		log('HostName: '+dns.myHostName);
		nsrecord = dns.resolve(dns.myHostName, 0);
	}
	catch(ex){
		if(goOnline){
			try{
				var ios = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
				if(ios.offline){
					ios.offline=false;
					try{nsrecord = dns.resolve(dns.myHostName, 0);}catch(ex1){}
					ios.offline=true;
				}
			}
			catch(ex2){err('goOnline', ex2);}
		}
		else err('importIP', ex);
	}

	var ips = new Array();
	try{
		while(nsrecord!=null && nsrecord.hasMore()){
			var ip = nsrecord.getNextAddrAsString();
			ips.push(ip);
			log('IP: '+ip);
		}
	}
	catch(ex){err('importIP', ex);}

	var list =document.getElementById('MM3ProxySwitch-popup-list');
	var items=list.getElementsByAttribute('type', 'checkbox');

	var hasDefault=false;
	for(var i = items.length; i-->0;){
		var name = items[i].getAttribute('label');
		if('default'==name) hasDefault=true;
		else{
			for(var j = ips.length; j-->0;){
				if(ips[j].indexOf(name)==0){
					log('found item: '+name+' IP: '+ips[j]);
					selectProxy(name, false);
					return;
				}
			}
			log('item: '+name);
		}
	}
	if(hasDefault){
		log('found default');
		selectProxy('default', false);
	}
}catch(ex){err('importIP',ex);}}

//foramt import= [*] DNS | DNSever
var initDNS=function(i){try{//log('initDNS '+i);

	var list=document.getElementById('MM3ProxySwitch-popup-list');
	if(list==null) return;

	//update only reStart
	var item = document.createElement('menuitem');
	item.setAttribute('label',     'Import DNS');
	item.setAttribute('oncommand', 'gMM3ProxySwitch.importDNS(); event.stopPropagation();');
	list.insertBefore(item, list.firstChild.nextSibling);

	if(i.indexOf('DNS')==0 && (i.indexOf('DNSEVER')==0 || isFirstWindow())) gMM3ProxySwitch.importDNS(); //start with > autoconfig
}catch(ex){err('initDNS',ex);}}

this.importDNS=function(){try{//log('importDNS');

	var dns = Components.classes['@mozilla.org/network/dns-service;1'].getService(Components.interfaces.nsIDNSService);

	var hasDefault=false;
	var isFirst=true;
	var proxys = this.load();
	for(var name in proxys){
		var proxy = proxys[name];
		if(typeof(proxy)!='string'){
			if(name=='default') hasDefault=true;
			else{
				log('resolve: '+name);
				try{
					var nsrecord = dns.resolve(name, 0);
					if(nsrecord.hasMore()){
						var ip = nsrecord.getNextAddrAsString();
						if(!isIP(name, ip)){
							log('found: '+ip);

							if(!isFirst){
								var tmp = new Object();
								tmp[name]=proxy;
								proxys[name]=null;
								log('save config');
								this.save(this.format(tmp)+this.format(proxys));
							}
							selectProxy(name, false);
							return;
						}
					}
				}
				catch(ex){err('found not', ex);}
				isFirst=false;
			}
		}
	}
	if(hasDefault){
		log('set default');
		selectProxy('default', false);
	}
}catch(ex){err('importDNS', ex);}}

var isIP=function(name, ip){try{
	var i=name.lastIndexOf('.');
	if(i==-1){ // 1 > 0.0.0.1
		if(ip=='0.0.0.'+name){
			log('found ip: only number '+ip);
			return true;
		}
	}
	else{ //1.2 > 1.0.0.2 | 1.2.3 > 1.2.0.3
		var nameStart=name.substring(0, i+1);
		var nameEnd  =name.substring(i);
		if (ip.indexOf    (nameStart)==0
		 && ip.lastIndexOf(nameEnd  )==ip.length-nameEnd.length){
			log('found ip: '+ip);
			return true;
		}
	}
	return false;
}catch(ex){err('isIP', ex);}}

var isFirstWindow=function(){try{
	var first=0;
	try{
		//http://www.xulplanet.com/references/xpcomref/ifaces/nsIWindowMediator.html
		var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
		var e = wm.getEnumerator(null);

		while(e.hasMoreElements() && first<2){
			first++;
			e.getNext();
		}
	}
	catch(ex){}

	return first<=1;
}catch(ex){err('isFirstWindow', ex);}}

//format [name http=... clear=cache]
//http://developer.mozilla.org/en/docs/nsICache
var clearCache=function(){try{log('MM3-ProxySwitch: ClearCache');

	var cacheService=Components.classes['@mozilla.org/network/cache-service;1']
								  .getService(Components.interfaces.nsICacheService);
	try{cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);  }catch(ex){err('ClearCache:Disk ',   ex);}
	try{cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);}catch(ex){err('ClearCache:Memory ', ex);}
}catch(ex){err('ClearCache', ex);}}

//Format: testUrl= url [direct|proxy|both] [name]
var testUrl=function(url){try{//log('testUrl '+url);

	var mode=3;
	var name=null;

	var i =url.indexOf(' ');
	if(i!=-1) {
		var str = trim(url.substring(i));
		url			=	     url.substring(0, i);

		i = str.indexOf(' ');
		if(i!=-1){
			name = trim(str.substring(i));
			str  =		  str.substring(0, i);
		}

		var strUp = str.toLowerCase();
				 if(strUp=='direct')	mode=1;
		else if(strUp=='proxy')		mode=2;
		else if(strUp=='both')		mode=3;
		else {
			if(name==null) name = str;
			else					 name = str+' '+name;
		}
		
	}

	if(name!=null){
		var list=document.getElementById('MM3ProxySwitch-popup-list');
		if(list==null) return;
		var found=false;
		var items = list.getElementsByAttribute('type', 'checkbox');
		for(var i = items.length; i-->0;){
			var item = items[i];
			if(item.getAttribute('label')==name){
				if(item.getAttribute('checked')=='false') return;
				found=true;
				break;
			}
		}
		if(!found) return;
	}

	var typ = oPrefs.getIntPref('network.proxy.type');
	if(typ==0){ if(mode==2) return; }
	else      { if(mode==1) return; }


	try{
		var req = new XMLHttpRequest();
		req.open('GET', url, false); 
		req.send(null);
		if(typ==0) gMM3ProxySwitch.onOffProxy();
	}
	catch(ex){
		if(typ!=0) gMM3ProxySwitch.onOffProxy();
	}
}catch(ex){err('testUrl', ex);}}

/*https://developer.mozilla.org/En/XUL_Tutorial:Property_Files
BIDI (bi-directional) html: dir = rtl or ltr
http://www.w3.org/International/tutorials/bidi-xhtml/
http://www.unicode.org/reports/tr9/*/
var getText=function(key){try{
	var strings=document.getElementById("MM3ProxySwitchText");
	return strings.getString(key);	
}catch(ex){err('getText1 '+key);} return key;}

var getText2=function(key,parms){try{
  var strings=document.getElementById("MM3ProxySwitchText");
	return strings.getFormattedString(key, parms);	
}catch(ex){err('getText2 '+key);} return key;}
/*Components.classes['@mozilla.org/intl/stringbundle;1']
.getService(Components.interfaces.nsIStringBundleService)
.createBundle('chrome://mm3-proxyswitch/locale/overlay.properties')
.GetStringFromName(key);*/

var err=function(message, ex){
	log('MM3-ProxySwitch '+message+': '+ex);
}
var log=function(message){
	var consoleService = Components.classes['@mozilla.org/consoleservice;1']
											.getService(Components.interfaces.nsIConsoleService);
	consoleService.logStringMessage(message);
}

	window.setTimeout(gMM3ProxySwitch.init, 1000);
}

function MM3ProxySwitchDragDrop(){
	window.removeEventListener('dragdrop', MM3ProxySwitchDragDrop, true);
	window.setTimeout(gMM3ProxySwitch.updateUIDragDrop, 2000);
}
