var PLUGGER_Main = {
	plugins : null,

	__construct : function() {
		this._icon = document.getElementById("pluggerIcon");
		this.plugins = Components.classes["@mozilla.org/plugin/host;1"]
							.getService(Components.interfaces.nsIPluginHost)
							.getPluginTags({});

		if (this.plugins.length==0) this._icon.setAttribute("disabled", true);
	},

	load : function(popup) {
		while (popup.hasChildNodes()) {
			popup.removeChild(popup.firstChild);
		}

		for (var i=0, n=this.plugins.length; i<n; i++) {
			var plugin = this.plugins[i];

			var menuitem = document.createElement("menuitem");
			menuitem.setAttribute("label", plugin.name);
			menuitem.setAttribute("value", plugin.description);
			menuitem.setAttribute("tooltiptext", this.removeHtmlTags(plugin.description));
			menuitem.setAttribute("type", "checkbox");
			menuitem.setAttribute("checked", !plugin.disabled);

			menuitem.onclick = function() {
				PLUGGER_Main.toggle(this);
			}

			popup.appendChild(menuitem);
		}
	},

	toggle : function(plugin) {
		var name = plugin.getAttribute("label");
		var description = plugin.getAttribute("value");

		for (var i=0, n=this.plugins.length; i<n; i++) {
			var plugin = this.plugins[i];
			if (plugin.name==name && plugin.description==description) {
				plugin.disabled = !plugin.disabled;
				break;
			}
		}
	},

	removeHtmlTags : function(str) {
		return str.replace(/<.+?>/g, " ");
	}
}

