var name								="MM3-ProxySwitch";
var version							="2009.60";
var author							="MM3Tools";
var regKey							="MM3-Tools/MM3-ProxySwitch";
var jar									="MM3-ProxySwitch.jar";
var error								=null;
var contentFlag					=CONTENT|PROFILE_CHROME;
var localeFlag					=LOCALE |PROFILE_CHROME;
var skinFlag						=SKIN   |PROFILE_CHROME;
var folder							=getFolder("Current User", "chrome");
var existsInApplication	=File.exists(getFolder(getFolder("chrome"), jar));
var existsInProfile			=File.exists(getFolder(folder,              jar));


if (existsInApplication
 || (!existsInProfile && !confirm("Do you want to install the "+name+" extension into your profile folder?\n(Cancel will install into the application folder)"))){

	contentFlag=CONTENT|DELAYED_CHROME;
	localeFlag =LOCALE |DELAYED_CHROME;
	skinFlag   =SKIN   |DELAYED_CHROME;
	folder     =getFolder("chrome");
}

//Uninstall Existing
if(existsInApplication || existsInProfile) uninstall(regKey);

initInstall(name, regKey, version);
setPackageFolder(folder);
error = addFile(author, version, "chrome/" + jar, folder, null);

// If adding the JAR file succeeded
if(error == SUCCESS){

	folder = getFolder(folder, jar);

	registerChrome(contentFlag,folder, "content/");
	registerChrome(localeFlag, folder, "locale/en-US/");
	registerChrome(localeFlag, folder, "locale/de-DE/");
	registerChrome(localeFlag, folder, "locale/it-IT/");
	registerChrome(localeFlag, folder, "locale/sk-SK/");
	registerChrome(localeFlag, folder, "locale/fa/");
	registerChrome(skinFlag,   folder, "skin/");

	error = performInstall();


	if(error == SUCCESS || error ==REBOOT_NEEDED){
		//alert("The installation of the " + name + " extension succeeded.");
	}
	else{
		switch(error){
			case -215: alert("The installation of the " +name+" extension failed.\nOne of the files being overwritten is read-only."); break;
			case -235: alert("The installation of the " +name+" extension failed.\nThere is insufficient disk space.");                break;
			default:   alert("The installation of the " +name+" extension failed.\nThe error code is: " + error);
		}
		cancelInstall(error);
	}
}
else{
	alert("The installation of the " +name+" extension failed.\nThe error code is: " + error);
	cancelInstall(error);
}