/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



var cookiesafeUpdate = {

	updateUrl: 'http://cookies.softwareblaze.com/blocklist_public/blocklist.php',

	getStr: function(name) {
		return document.getElementById("cookiesafe-bundle").getString(name);
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	getAppInfo: function() {
		return Components.classes['@mozilla.org/xre/app-info;1'].
		createInstance(Components.interfaces.nsIXULAppInfo);
	},

	getPermManager: function() {
		//check if browser is TB2
		var brows = this.getAppInfo();
		var num = parseInt(brows.version);
		if (brows.name=='Thunderbird' && num==2) {
			return Components.classes["@mozilla.org/CSPermManager;1"].
			getService(Components.interfaces.nsICSPermManager);
		} else {
			return Components.classes["@mozilla.org/permissionmanager;1"].
			getService(Components.interfaces.nsIPermissionManager);
		}
	},

	getURI: function(url) {
		return Components.classes["@mozilla.org/network/io-service;1"].
		getService(Components.interfaces.nsIIOService).
		newURI(url,null,null);
	},

	onDialogLoad: function() {
		var listitem;
		var prefs = this.getPrefs();
		var bU = prefs.getBoolPref('blockUntrusted');

		var blk = document.getElementById('block');
		for (var i=0; i<window.arguments[0].length; ++i) {
			listitem = document.createElement('listitem');
			listitem.setAttribute('type','checkbox');
			listitem.setAttribute('autocheck','true');
			listitem.setAttribute('checked','true');
			listitem.setAttribute('label',window.arguments[0][i]);
			listitem.setAttribute('value',window.arguments[0][i]);
			blk.appendChild(listitem);
		}

		var untr = document.getElementById('untrusted');
		for (var i=0; i<window.arguments[1].length; ++i) {
			listitem = document.createElement('listitem');
			listitem.setAttribute('type','checkbox');
			listitem.setAttribute('autocheck','true');
			listitem.setAttribute('checked',bU);
			listitem.setAttribute('label',window.arguments[1][i]);
			listitem.setAttribute('value',window.arguments[1][i]);
			untr.appendChild(listitem);
		}

		var bt = document.getElementById('blockTotal');
		bt.setAttribute('value',this.getStr('cookiesafe.lTotal')+' '+window.arguments[0].length);
		var ut = document.getElementById('untrustedTotal');
		ut.setAttribute('value',this.getStr('cookiesafe.lTotal')+' '+window.arguments[1].length);

		document.getElementById('blockUntrusted').checked = bU;

		//hide untrusted hosts listbox if it doesn't contain any listitems
		document.getElementById('untrustedBox').setAttribute('collapsed',(window.arguments[1].length<1) ? true : false);

		//make sure all content is visible
		setTimeout(sizeToContent,250);
	},

	onDialogAccept: function() {
		var item;
		var hosts = [];
		var prefs = this.getPrefs();
		var blBox = document.getElementById('block');
		var unBox = document.getElementById('untrusted');
		var blkUn = document.getElementById('blockUntrusted');
		prefs.setBoolPref('blockUntrusted',blkUn.checked);

		var rows = blBox.getRowCount();
		for (var i=0; i<rows; ++i) {
			item = blBox.getItemAtIndex(i);
			if (item.getAttribute('checked') == 'true') {
				hosts.push(item.getAttribute('value'));
			}
		}

		//only block untrusted hosts if the blockUntrusted box is checked
		if (blkUn.checked) {
			rows = unBox.getRowCount();
			for (var i=0; i<rows; ++i) {
				item = unBox.getItemAtIndex(i);
				if (item.getAttribute('checked') == 'true') {
					hosts.push(item.getAttribute('value'));
				}
			}
		}

		this.blockHosts(hosts);
	},

	toggleCheckboxes: function() {
		var item;
		var chk = document.getElementById('blockUntrusted');
		var box = document.getElementById('untrusted');
		var rows = box.getRowCount();

		for (var i=0; i<rows; ++i) {
			item = box.getItemAtIndex(i);
			item.checked = chk.checked;
		}
	},

	updateBlocklist: function() {
		var httpRequest = new XMLHttpRequest();
		httpRequest.overrideMimeType('text/xml');
		httpRequest.onreadystatechange = function() { cookiesafeUpdate.processBlocklist(httpRequest); };
		httpRequest.open('GET', this.updateUrl, true);
		httpRequest.send(null);

		//save time of update
		var dt = new Date();
		var prefs = this.getPrefs();
		prefs.setIntPref('lastUpdate',parseInt(dt.getTime()/1000));
	},

	processBlocklist: function(req) {
		if (req.readyState == 4) {
			/*for some reason if the user is not connected to the network the status
			property will throw an error when it's accessed. Although when you query
			it using ('status' in req) it returns true? At this point the only thing
			to do is enclose the req.status command in try-catch brackets.*/

			try { var status = req.status; } catch(e) { return false; }

			if (status == 200 || status == 0) {
				var action,untrusted = [],block = [];
				var doc = req.responseXML;
				var hosts = doc.getElementsByTagName('host');

				for (var i=0; i<hosts.length; ++i) {
					action = cookiesafe.testPermission(hosts[i].textContent);
					if (!action) {
						block.push(hosts[i].textContent);
					} else if (action==1 || action==8) {
						untrusted.push(hosts[i].textContent);
					}
				}

				var prefs = this.getPrefs();
				var upBhvr = prefs.getIntPref('updateBehavior');
				var blkUn = prefs.getBoolPref('blockUntrusted');

				if (block.length<1 && untrusted.length<1) {
					if (upBhvr == 0) alert(this.getStr('cookiesafe.ExtName')+
									this.getStr('cookiesafe.Colon')+' '+
									this.getStr('cookiesafe.NoUpdate'));
				} else {
					block.sort();
					untrusted.sort();
					if (upBhvr == 0) {
						this.viewUpdate(block,untrusted);
					} else {
						this.blockHosts((blkUn) ? block.concat(untrusted) : block);
					}
				}
			}
		}
		return false;
	},

	blockHosts: function(hosts) {
		var mngr = this.getPermManager();
		for (var i=0; i<hosts.length; ++i) {
			try {
				mngr.add(this.getURI('http://'+hosts[i]),'cookie',2);
			} catch(e) {
				continue;
			}
		}

		//notify csperm-changed observer in TB2 only
		var brows = this.getAppInfo();
		var num = parseInt(brows.version);
		if (brows.name=='Thunderbird' && num==2) {
			var os = this.getObserver();
			os.notifyObservers(null,'csperm-changed','multiple');
		}
	},

	viewUpdate: function(blk,untr) {
		window.openDialog("chrome://cookiesafe/content/cookiesafeUpdate.xul", "_blank", "chrome,centerscreen,resizable", blk, untr);
	}
};
