/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



var gPermissionManager = {
  _type       : "",
  _strAllow   : "",
  _strBlock   : "",
  _strSession : "",
  _strTemp    : "",
  _bundle     : null,
  _tree       : null,
  _children   : null,
  _txtbox     : null,
  _menu       : null,
  _block      : null,
  _temp       : null,
  _session    : null,
  _allow      : null,
  _remove     : null,
  _removeAll  : null,
  _update     : null,
  _reset      : null,
  _resetTree  : null,
  _os         : Components.classes["@mozilla.org/observer-service;1"].
                getService(Components.interfaces.nsIObserverService),
  _io         : Components.classes["@mozilla.org/network/io-service;1"].
                getService(Components.interfaces.nsIIOService),

  getStr: function(name) {
    return document.getElementById("cookiesafe-bundle").getString(name);
  },

  getAppInfo: function() {
    return Components.classes['@mozilla.org/xre/app-info;1'].
    createInstance(Components.interfaces.nsIXULAppInfo);
  },

  getCSTempExceptions: function() {
    return Components.classes['@mozilla.org/CSTempExceptions;1'].
    getService(Components.interfaces.nsICSTempExceptions);
  },

  getPrefs: function() {
    return Components.classes["@mozilla.org/preferences-service;1"].
    getService(Components.interfaces.nsIPrefService).
    getBranch("cookiesafe.");
  },

  getPermManager: function() {
    //check if browser is TB2, if so use the cs perm manager
    var brows = this.getAppInfo();
    var num = parseInt(brows.version);
    if (brows.name=='Thunderbird' && num==2) {
      return Components.classes["@mozilla.org/CSPermManager;1"].
      getService(Components.interfaces.nsICSPermManager);
    } else {
      return Components.classes["@mozilla.org/permissionmanager;1"].
      getService(Components.interfaces.nsIPermissionManager);
    }
  },

  init: function () {
    var params = window.arguments[0];

    var permissionsText = document.getElementById("permissionsText");
    while (permissionsText.hasChildNodes()) {
      permissionsText.removeChild(permissionsText.firstChild);
    }
    permissionsText.appendChild(document.createTextNode(params.introText));

    this._type = params.permissionType;
    document.title = params.windowTitle;

    this._strAllow = this.getStr('cookiesafe.lAllow');
    this._strBlock = this.getStr('cookiesafe.lBlock');
    this._strSession = this.getStr('cookiesafe.lSession');
    this._strTemp = this.getStr('cookiesafe.lTemporary');

    this._bundle = document.getElementById("bundlePreferences");
    this._tree = document.getElementById("permissionsTree");
    this._children = document.getElementById("permissionsTreeChildren");
    this._txtbox = document.getElementById("domain");
    this._menu = document.getElementById("menuStatus");
    this._block = document.getElementById("btnBlock");
    this._temp = document.getElementById("btnTemp");
    this._session = document.getElementById("btnSession");
    this._allow = document.getElementById("btnAllow");
    this._remove = document.getElementById("btnRemove");
    this._removeAll = document.getElementById("btnRemoveAll");
    this._update = document.getElementById("btnUpdate");
    this._reset = document.getElementById("btnReset");
    this._resetTree = document.getElementById("btnResetTree");

    // set the hidden attribute for the allow/block/session buttons and
    // menuitems since some permission windows do not support each option.
    // cookie = allow/block/session, image = allow/block, install = allow, popup = allow
    this._block.hidden    = !params.blockVisible;
    this._session.hidden  = !params.sessionVisible;
    this._allow.hidden    = !params.allowVisible;
    this._temp.hidden    = !params.sessionVisible; // used only in cs lite
    document.getElementById('miTemp').hidden = !params.sessionVisible; // used only in cs lite
    document.getElementById('miBlock').hidden = !params.blockVisible;
    document.getElementById('miSession').hidden = !params.sessionVisible;
    document.getElementById('miAllow').hidden = !params.allowVisible;

    // hide the menulist, update and reset tree buttons for install/popup windows
    if (this._type == 'install' || this._type == 'popup') {
      document.getElementById('updateSection').collapsed = true;
    }

    this._txtbox.value = params.prefilledHost;
    this.onHostInput(this._txtbox);
    
    this.initPermObserver();

    // determine which column to sort by
    var sortBy = this.getNameOfColToSort();

    // determine whether to sort atoz or ztoa
    var atoz = this.getColOrder(sortBy);

    this.loadPermissions(sortBy,atoz);
    this._txtbox.focus();
  },

  exit: function() {
    this.uninitPermObserver();
  },

  initPermObserver: function() {
    this._os.addObserver(this, "perm-changed", false);
    this._os.addObserver(this, "csperm-changed", false);
  },

  uninitPermObserver: function () {
    this._os.removeObserver(this, "perm-changed");
    this._os.removeObserver(this, "csperm-changed");
  },

  onHostInput: function (aSiteField) {
    this._block.disabled = !aSiteField.value;
    this._temp.disabled = !aSiteField.value;
    this._session.disabled = !aSiteField.value;
    this._allow.disabled = !aSiteField.value;
    this._reset.disabled = !aSiteField.value;
  },
  
  onHostKeyPress: function (aEvent) {
    if (aEvent.keyCode == 13) {
      gPermissionManager.addPermission(1);
    }
  },

  addPermission: function (aCapability) {
    if (!this._txtbox.value) return false;

      var url;
      var mngr = this.getPermManager();

      // remove all non-alphanumeric characters before and after host
      var host = this._txtbox.value.replace(/^\W*|\W*$/g,'');

      if (host == 'scheme:file' || host.substr(0,5) == 'file:') {
        // make sure this isn't a file url before stripping the scheme
        host = 'scheme:file';
        url = 'file:///cookiesafe';
      } else {
        // remove the scheme and all non-alphanumeric characters before the host
        host = host.replace(/^\w*:\W*/g,'');
        url = 'http://' + host;
      }

      // remove temp exception if it exists, we have to remove temp exceptions here
      // since this method can be used to change exceptions as well as add new ones
      var tempExc = this.getCSTempExceptions();
      tempExc.removeTempExceptions(host);

      if (aCapability == 'T') {
        tempExc.addTempExceptions(host);
        aCapability = 8;
      }

    try {
      var uri = this._io.newURI(url,null,null);
      mngr.add(uri,this._type,aCapability);
    } catch(e) {
      alert(this.getStr('cookiesafe.DomainError'));
    }

    //check if browser is TB2
    var brows = this.getAppInfo();
    var num = parseInt(brows.version);
    if (brows.name=='Thunderbird' && num==2) {
      this._os.notifyObservers(null,'csperm-changed','added');
    }
    return false;
  },

  resetTextBox: function() {
    this._txtbox.value = "";
    this.onHostInput(this._txtbox);
    this._txtbox.focus();
  },

  onPermissionKeyPress: function (aEvent) {
    if (aEvent.keyCode == 46) {
      this.onPermissionDeleted();
    }
  },

  onPermissionSelected: function () {
    if (!this._tree.view ||
        !this._tree.view.selection ||
        this._tree.view.selection.count < 1 ||
        this._tree.view.rowCount < 1) {
      this._menu.selectedIndex = 0;
      this._update.disabled = true;
      this._resetTree.disabled = true;
      this._remove.disabled = true;
      return false;
    }

    // enable tree related buttons
    this._update.disabled = false;
    this._resetTree.disabled = false;
    this._remove.disabled = false;

    if (this._tree.view.selection.count==1) {
        var row = this.getCellData();
        var index = this.getMenuListIndex(row[1]);
        this._menu.selectedIndex = index;
    } else {
        this._menu.selectedIndex = 0;
    }

    return false;
  },

  onPermissionSort: function (aColumn) {
    if (!this._tree.view ||
        !this._tree.contentView ||
        !this._tree.view.selection) return false;

    var sortBy,col,atoz,temp;

    // determine which column was last sorted
    sortBy = this._tree.getAttribute('sortBy');

    // determine whether to sort a to z
    col = document.getElementById((aColumn=='host') ? 'siteCol' : 'statusCol');
    atoz = col.getAttribute('atoz');

    // we only want to reverse sort order when clicking on currently sorted column
    // Example 1: statusCol -> statusCol = reverse the order
    // Example 2: statusCol -> siteCol = use the last known sort order
    if (sortBy == aColumn) {
      atoz = (atoz && atoz == 'true') ? false : true;
    } else {
      atoz = (!atoz || atoz == 'true') ? true : false;
    }

    sortBy = aColumn;
    col.setAttribute('atoz',atoz);
    this._tree.setAttribute('sortBy',sortBy);

    // create array of hosts and capabilities for sorting
    var hosts = this.getHostsFromTree(sortBy,atoz);

    // clear selection and remove all items from tree
    // DO NOT REMOVE TREE ITEMS UNTIL AFTER CREATING THE HOSTS ARRAY
    this.clearTreeChildren();

    // add the sorted items back to the tree
    for (var i=0; i<hosts.length; ++i) {
      temp = hosts[i].split('|');
      if (sortBy != 'host') temp.reverse();
      this._children.appendChild(this.createItem(temp));
    }

    return false;
  },

  onPermissionUpdated: function() {
    if (!this._tree.view ||
        !this._tree.view.selection ||
        this._tree.view.selection.count < 1 ||
        this._menu.selectedIndex == 0) {
      return false;
    }

    var row,uri,url;
    var start = {};
    var end = {};
    var mngr = this.getPermManager();
    var tempExc = this.getCSTempExceptions();
    var index = this._menu.selectedItem.value;
    index = (index == 'T') ? index : parseInt(index);
    var range = this._tree.view.selection.getRangeCount();

    for (var i=0; i<range; ++i) {
      this._tree.view.selection.getRangeAt(i,start,end);
      for (var j=start.value; j<=end.value; ++j) {
        row = this.getCellData(j);
        try {
          // remove temp exception if it exists
          tempExc.removeTempExceptions(row[0]);

          if (index == 'T') {
            tempExc.addTempExceptions(row[0]);
            index = 8;
          }

          url = (row[0] == 'scheme:file') ? 'file:///cookiesafe' : 'http://'+row[0];
          uri = this._io.newURI(url,null,null);
          mngr.add(uri,this._type,index);
        } catch(e) { }
      }
    }

    //check if browser is TB2
    var brows = this.getAppInfo();
    var num = parseInt(brows.version);
    if (brows.name=='Thunderbird' && num==2) {
      this._os.notifyObservers(null,'csperm-changed','changed');
    }
    return false;
  },

  resetTree: function() {
    if (this._tree.view && this._tree.view.selection) {
      this._tree.view.selection.clearSelection();
      this._tree.currentIndex = -1;
      this.onPermissionSelected();
      this._txtbox.focus();
    }
  },

  onPermissionDeleted: function () {
    if (!this._tree.view ||
        !this._tree.contentView ||
        !this._tree.view.selection ||
        this._tree.view.selection.count < 1) {
      return false;
    }

    var row,uri;
    var hosts = [];
    var items = [];
    var start = {};
    var end = {};
    var mngr = this.getPermManager();
    var tempExc = this.getCSTempExceptions();
    var range = this._tree.view.selection.getRangeCount();

    // save all selected hosts to array before continuing since
    // the observer will mess up selection if we remove them here
    for (var i=0; i<range; ++i) {
      this._tree.view.selection.getRangeAt(i,start,end);
      for (var j=start.value; j<=end.value; ++j) {
        row = this.getCellData(j);
        hosts.push(row[0]);
      }
    }

    // remove hosts here, selection no longer matters since we
    // already know which hosts to remove
    for (var i=0; i<hosts.length; ++i) {
      tempExc.removeTempExceptions(hosts[i]);
      try {
        mngr.remove(hosts[i],this._type);
      } catch(e) { }
    }

    //check if browser is TB2
    var brows = this.getAppInfo();
    var num = parseInt(brows.version);
    if (brows.name=='Thunderbird' && num==2) {
      this._os.notifyObservers(null,'csperm-changed','deleted');
    }
    return false;
  },
  
  onAllPermissionsDeleted: function () {
    var ask = confirm(this.getStr('cookiesafe.ConfirmClearEx'));
    if (!ask) return false;

    // we clear all the tree children first to avoid any possible errors
    // when the observer is notified of the deleted permissions
    this.clearTreeChildren();

    var mngr = this.getPermManager();
    var tempExc = this.getCSTempExceptions();
    tempExc.clearTempExceptions();

    if (mngr instanceof Components.interfaces.nsIPermissionManager) {
      var prm;
      var perms = mngr.enumerator;
      while (perms.hasMoreElements()) {
        prm = perms.getNext();
        prm.QueryInterface(Components.interfaces.nsIPermission);
        if (prm.type == this._type) {
          try {
            mngr.remove(prm.host,this._type);
          } catch(e) { }
        }
      }
    } else { //for TB2 only
      mngr.removeAll();
      this._os.notifyObservers(null,'csperm-changed','cleared');
    }
    return false;
  },

  clearTreeChildren: function() {
    this.resetTree();

    while (this._children.firstChild) {
      this._children.removeChild(this._children.firstChild);
    }
  },

  getCellData: function(index) {
    var cell = [];
    if (index == null) index = this._tree.currentIndex;

    try {
      for (var i=0; i<this._tree.columns.count; ++i) {
        cell.push(this._tree.view.getCellText(index,this._tree.columns.getColumnAt(i)));
      }
    } catch(e) { }

    return cell;
  },

  convertCapability: function (aCapability) {
    switch (aCapability) {
      case 1:
        return this._strAllow;
      case 2:
        return this._strBlock;
      case 8:
        return this._strSession;
      case 'T':
        return this._strTemp;
      case this._strAllow:
        return 1;
      case this._strBlock:
        return 2;
      case this._strSession:
        return 8;
      case this._strTemp:
        return 'T';
      default:
        return null;
    }
  },

  getMenuListIndex: function (aCapability) {
    switch (aCapability) {
      case 1:
        return 4;
      case this._strAllow:
        return 4;
      case 8:
        return 3;
      case this._strSession:
        return 3;
      case 'T':
        return 2;
      case this._strTemp:
        return 2;
      case 2:
        return 1;
      case this._strBlock:
        return 1;
      default:
        return 0;
    }
  },

  getNameOfColToSort: function() {
    var sortBy = this._tree.getAttribute('sortBy');
    if (!sortBy) {
      sortBy = 'host';
      this._tree.setAttribute('sortBy',sortBy);
    }
    return sortBy;
  },

  getColOrder: function(sortBy) {
    var col = document.getElementById((sortBy=='host') ? 'siteCol' : 'statusCol');
    var atoz = col.getAttribute('atoz');
    atoz = (!atoz || atoz=='true') ? true : false;
    col.setAttribute('atoz',atoz);
    return atoz;
  },

  observe: function (aSubject, aTopic, aData) {
    // only used in TB2
    if (aTopic == 'csperm-changed') {
      // determine which column to sort by
      var sortBy = this.getNameOfColToSort();

      // determine whether to sort atoz or ztoa
      var atoz = this.getColOrder(sortBy);

      this.loadPermissions(sortBy,atoz);
    }

    if (aTopic != 'perm-changed') return false;

    var permission = (aSubject) ? aSubject.QueryInterface(Components.interfaces.nsIPermission) : null;
    if (permission && permission.type != this._type) return false;
    var tempExc = this.getCSTempExceptions();

    if (aData == "added") {
      if (!this._tree.view ||
          !this._tree.columns ||
          !this._tree.contentView) return false;

      var capability = (tempExc.testTempExceptions(permission.host)) ? 'T' : permission.capability;
      var cap = this.convertCapability(capability);

      // determine which column to sort by
      var sortBy = this.getNameOfColToSort();

      // determine whether to sort atoz or ztoa
      var atoz = this.getColOrder(sortBy);

      // format new permission to be sorted
      var permcap = (sortBy == 'host') ? permission.host+'|'+cap : cap+'|'+permission.host;

      // create array of hosts and capabilities for sorting
      var hosts = this.getHostsFromTree(sortBy,atoz,permcap);

      // get the location of the new permission
      var rowNum = hosts.indexOf(permcap);

      // get the new tree item element
      var treeItem = this.createItem([permission.host,cap]);

      // if the new permission is last in tree use appendChild otherwise use insertBefore
      if (hosts.length-1 == rowNum) {
        this._children.appendChild(treeItem);
      } else {
        var itm = this._tree.contentView.getItemAtIndex(rowNum);
        this._children.insertBefore(treeItem,itm);
      }

      // make sure the new host is visible
      this._tree.treeBoxObject.ensureRowIsVisible(rowNum);
    } else if (aData == "changed") {
      if (!this._tree.view || !this._tree.columns) return false;

      var row;
      var capability = (tempExc.testTempExceptions(permission.host)) ? 'T' : permission.capability;
      var cap = this.convertCapability(capability);

      // change the capability text displayed in the tree
      for (var i=0; i<this._tree.view.rowCount; ++i) {
        row = this.getCellData(i);
        if (row[0] == permission.host) {
          this._tree.view.setCellText(i,this._tree.columns.getColumnAt(1),cap);
          break;
        }
      }
    } else if (aData == "deleted") {
      if (!this._tree.view ||
          !this._tree.contentView ||
          !this._tree.view.selection) return false;

      // remove item from the tree
      var row,item;
      for (var i=0; i<this._tree.view.rowCount; ++i) {
        row = this.getCellData(i);
        if (row[0] == permission.host) {
          this._tree.view.selection.clearRange(i,i);
          item = this._tree.contentView.getItemAtIndex(i);
          this._children.removeChild(item);
          break;
        }
      }
    } else if (aData == "cleared") {
      this.clearTreeChildren();
    }

    // make sure remove all button is enabled if the tree contains children
    if (this._tree.view) {
      this._removeAll.disabled = (this._tree.view.rowCount > 0) ? false : true;
    }
    return false;
  },

  loadPermissions: function (sortBy,atoz) {
    // clear selection and remove all items from tree
    this.clearTreeChildren();

    var hosts = [];
    var temp,perms,perm,cap,capability;
    var mngr = this.getPermManager();
    var tempExc = this.getCSTempExceptions();

    if (mngr instanceof Components.interfaces.nsIPermissionManager) {
      perms = mngr.enumerator;
      while (perms.hasMoreElements()) {
        perm = perms.getNext();
        perm.QueryInterface(Components.interfaces.nsIPermission);
        if (perm.type == this._type) {
          capability = (tempExc.testTempExceptions(perm.host)) ? 'T' : perm.capability;
          cap = this.convertCapability(capability);
          if (sortBy == 'host') {
            hosts.push(perm.host+'|'+cap);
          } else {
            hosts.push(cap+'|'+perm.host);
          }
        }
      }
    } else { //for TB2 only
      perms = mngr.getAllPermissions().split(' ');
      for (var i=0; i<perms.length; ++i) {
        if (!perms[i]) continue;
        temp = perms[i].split('|');
        capability = (tempExc.testTempExceptions(temp[0])) ? 'T' : parseInt(temp[1]);
        cap = this.convertCapability(capability);
        if (sortBy == 'host') {
          hosts.push(temp[0]+'|'+cap);
        } else {
          hosts.push(cap+'|'+temp[0]);
        }
      }
    }

    // sort the items
    hosts.sort();
    if (!atoz) hosts.reverse();

    // add the sorted items back to the tree
    for (var i=0; i<hosts.length; ++i) {
      temp = hosts[i].split('|');
      if (sortBy != 'host') temp.reverse();
      this._children.appendChild(this.createItem(temp));
    }

    // make sure remove all button is enabled if the tree contains children
    if (this._tree.view) {
      this._removeAll.disabled = (this._tree.view.rowCount > 0) ? false : true;
    }
  },

  createItem: function(cells) {
    var cell;
    var item = document.createElement('treeitem');
    var row = document.createElement('treerow');

    for (var i=0; i<cells.length; ++i) {
      cell = document.createElement('treecell');
      cell.setAttribute('label',cells[i]);
      row.appendChild(cell);
    }

    item.appendChild(row);
    return item;
  },

  getHostsFromTree: function(sortBy,atoz,newPerm) {
    if (!this._tree.view || !this._tree.columns) return false;

    var row;
    var hosts = [];
    for (var i=0; i<this._tree.view.rowCount; ++i) {
      row = this.getCellData(i);
      if (sortBy == 'host') {
        hosts.push(row[0]+'|'+row[1]);
      } else {
        hosts.push(row[1]+'|'+row[0]);
      }
    }

    // if this method is being used to determine where to place a new
    // permission in the tree the newPerm string will need to be added
    // prior to sorting the hosts. otherwise the newPerm argument is null
    if (newPerm) hosts.push(newPerm);

    hosts.sort();
    if (!atoz) hosts.reverse();
    return hosts;
  }
};
