/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



window.addEventListener('load', cookiesafeInit, false);

function cookiesafeInit() {
	//make sure the windowtype attribute is set in TB
	var brows = cookiesafe.getAppInfo();
	if (brows.name=='Thunderbird') {
		var win = document.getElementById('messengerWindow');
		var type = win.getAttribute('windowtype');
		if (!type) win.setAttribute('windowtype','mail:3pane');
	}
	cookiesafe.init();
}

window.addEventListener('unload', cookiesafeExit, false);

function cookiesafeExit() {
	cookiesafe.exit();
}

/*changeTabsSM() is used to display the exceptions tab in SeaMonkey
 and Mozilla browsers. SM and Moz do not use separate windows to
 display cookies and exceptions. therefore it is necessary to switch
 tabs in order to display the exceptions since both features appear in
 the same window.*/

function changeTabSM() {
	var win = cookiesafe.getWin('mozilla:cookieviewer');
	var tab = win.document.getElementById('permissionsTab');
	win.document.getElementById('tabbox').selectedTab=tab;
}

/*cookiesafeResetIcon() is used to ensure that the cookiesafe icon is
 always reset to the correct image after a cookie notification has
 occurred. instead of resetting the icon after a page load or location
 change, a timeout is used to call the load method.*/

function cookiesafeResetIcon() {
	cookiesafe.load();
}

/*cookiesafeInitPermObserver() is used to prevent an overflow of perm-changed
 notifications from being sent to the perm observer in rapid succession. that
 can occur by clearing all of the exceptions, by deleting multiple cookie
 exceptions, or by updating the blocklist which may add hundreds of exceptions.*/

function cookiesafeInitPermObserver() {
	csPermObserver.init();

	/*the following code is needed since by disabling the perm observer some
	exceptions may not be caught that appear in the last 10 hosts list or the
	current webpage's domain*/

	if (!cookiesafe.isFlashing()) cookiesafe.load();
	var os = Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	os.notifyObservers(null,'cookiesafe-hosts-changed',null);
}

var cookiesafeProgress = {
	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener)   ||
		    aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
		    aIID.equals(Components.interfaces.nsISupports))
      			return this;
		throw Components.results.NS_NOINTERFACE;
	},
	onLinkIconAvailable: function(a) { },
	onLocationChange: function(a,b,c) {
		if (!cookiesafe.isFlashing()) cookiesafe.load();
	},
	onProgressChange: function(a,b,c,d,e,f) { },
	onSecurityChange: function(a,b,c) { },
	onStateChange: function(a,b,c,d) { },
	onStatusChange: function(a,b,c,d) { }
};

var cookiesafe = {

	TB2: false,

	_block   : "",
	_remove  : "",
	_allow   : "",
	_session : "",
	_temp    : "",
	_order   : 0,

	getURI: function(url) {
		return Components.classes["@mozilla.org/network/io-service;1"].
		getService(Components.interfaces.nsIIOService).
		newURI(url,null,null);
	},

	isFlashing: function() {
		var dom = this.getDOM();
		var flashing = dom.sts.getAttribute('cookiesafe');
		return (flashing.substr(0,5)=='flash') ? true : false;
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getCS: function() {
		return Components.classes['@mozilla.org/CookieSafe;1'].
		createInstance(Components.interfaces.nsICookieSafe);
	},

	getCSHiddenMenuItems: function() {
		return Components.classes['@mozilla.org/CSHiddenMenuItems;1'].
		createInstance(Components.interfaces.nsICSHiddenMenuItems);
	},

	getCSLast10Hosts: function() {
		return Components.classes['@mozilla.org/CSLast10Hosts;1'].
		getService(Components.interfaces.nsICSLast10Hosts);
	},

	getCSTempExceptions: function() {
		return Components.classes['@mozilla.org/CSTempExceptions;1'].
		getService(Components.interfaces.nsICSTempExceptions);
	},

	getBaseDomain: function(host) {
		var cs = this.getCS();
		return cs.removeSub(host);
	},

	getDomain: function() {
		var site = null;
		try {
			site = window.content.document.domain;
			if (!site) {
				var url = window.content.location.href;
				if (url.substr(0,5)=='file:') site = 'scheme:file';
			}
		} catch(e) {
			try {
				var url = window.content.location.href;
				if (url.substr(0,5)=='file:') site = 'scheme:file';
			} catch(e) { }
		}
		return site;
	},

	testPermission: function(host) {
		var url = (host=='scheme:file') ? 'file:///cookiesafe' : 'http://'+host;
		var uri = this.getURI(url);
		var mngr = this.getPermManager();
		var action = mngr.testPermission(uri,'cookie');
		return action;
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	getGlobalPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("network.cookie.");
	},

	getWin: function(name) {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow(name);
	},

	getAppInfo: function() {
		return Components.classes['@mozilla.org/xre/app-info;1'].
		createInstance(Components.interfaces.nsIXULAppInfo);
	},

	getStr: function(name) {
		return document.getElementById("cookiesafe-bundle").getString(name);
	},

	getProfile: function() {
		return Components.classes["@mozilla.org/file/directory_service;1"].
		getService(Components.interfaces.nsIProperties).
		get("ProfD", Components.interfaces.nsIFile);
	},

	getPermManager: function() {
		//check if browser is TB2
		if (this.TB2) {
			return Components.classes["@mozilla.org/CSPermManager;1"].
			getService(Components.interfaces.nsICSPermManager);
		} else {
			return Components.classes["@mozilla.org/permissionmanager;1"].
			getService(Components.interfaces.nsIPermissionManager);
		}
	},

	getCookieManager: function() {
		return Components.classes["@mozilla.org/cookiemanager;1"].
		getService(Components.interfaces.nsICookieManager);
	},

	getExtManager: function() {
		var mngr = Components.classes['@mozilla.org/extensions/manager;1'];
		return (mngr) ? mngr.getService(Components.interfaces.nsIExtensionManager) : false;
	},

	restartBrowser: function() {
		var nsIAppStartup = Components.interfaces.nsIAppStartup;
		Components.classes["@mozilla.org/toolkit/app-startup;1"].
		getService(nsIAppStartup).
		quit(nsIAppStartup.eForceQuit | nsIAppStartup.eRestart);
	},

	showDBWarning: function(type,path) {
		var dom = this.getDOM();
		var img = 'chrome://cookiesafe/skin/warning.gif';
		var msg = (type=='notfound') ? this.getStr('cookiesafe.DBNotFound') : this.getStr('cookiesafe.DBReadOnly');

		if (dom.sts) dom.sts.setAttribute('src',img);
		if (dom.btn) dom.btn.setAttribute('image',img);
		if (dom.ctx) dom.ctx.setAttribute('image',img);

		alert(msg+'\n\n'+path);
	},

	getDOM: function() {
		var sts = document.getElementById('cookiesafe-status');
		var ctx = document.getElementById('cookiesafe-context');
		var ctx2 = document.getElementById('cookiesafe-context2');
		var btn = document.getElementById('cookiesafe-button');
		var CACM = document.getElementById('contentAreaContextMenu');

		return {sts:sts,ctx:ctx,ctx2:ctx2,btn:btn,CACM:CACM};
	},

	getWindowTypeForApp: function(name) {
		switch (name) {
			case 'Thunderbird':
				return 'mail:3pane';

			case 'Songbird':
				return 'Songbird:Main';

			case 'eMusic Remote':
				return 'emusic:window';

			default:
				return 'navigator:browser';
		}
	},

	countOpenWindows: function() {
		var brows = this.getAppInfo();
		var wins = Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getEnumerator(this.getWindowTypeForApp(brows.name));

		var win,count=0;
		while (('hasMoreElements' in wins && wins.hasMoreElements()) ||
			 ('hasMore' in wins && wins.hasMore())) {
			win = wins.getNext();
			++count;
		}
		return count;
	},

	hideStatus: function() {
		var dom = this.getDOM();
		var prefs = this.getPrefs();
		dom.sts.setAttribute('hidden',prefs.getBoolPref('hideStatus'));
	},

	hideContext: function() {
		var dom = this.getDOM();
		if (!dom.ctx || !dom.CACM) return false;

		var prefs = this.getPrefs();
		var hc = prefs.getBoolPref('hideContext');
		if (dom.ctx) dom.ctx.setAttribute('hidden',hc);

		if (hc) {
			dom.CACM.removeEventListener('popupshowing', cookiesafe.showContextPopup, false);
		} else {
			dom.CACM.addEventListener('popupshowing', cookiesafe.showContextPopup, false);
		}
		return false;
	},

	init: function() {
		/*we have to place the startup code in this overlay since some of the required
		interfaces and components are not available when the app-startup and xpcom-startup
		notifications are sent to the observer. so we count how many browser windows are
		open and call cookiesafeStartup if this is the first window opened*/

		var num = this.countOpenWindows();
		if (num <= 1) cookiesafeStartup.init();

		//register cookiesafe observers
		csPermObserver.init();
		csCookieObserver.init();
		csPrefObserver.init();

		//add progress listener for all location changes
		getBrowser().addProgressListener(cookiesafeProgress);

		//show-hide statusbar icon
		this.hideStatus();

		//show-hide context menu item
		this.hideContext();

		//save strings and string order for left click popup menu
		this._block = this.getStr('cookiesafe.lBlock');
		this._remove = this.getStr('cookiesafe.lRemove');
		this._allow = this.getStr('cookiesafe.lAllow');
		this._session = this.getStr('cookiesafe.lForSession');
		this._temp = this.getStr('cookiesafe.lTemporarilyAllow');
		this._order = parseInt(this.getStr('cookiesafe.MenuitemStringOrder'));

		this.load();
	},

	exit: function() {
		//unregister observers
		csPermObserver.uninit();
		csCookieObserver.uninit();
		csPrefObserver.uninit();

		//remove progress listener
		getBrowser().removeProgressListener(cookiesafeProgress);
	},

	getHostActionImg: function() {
		var actionBase,actionFull,img;
		var base = null;
		var host = this.getDomain();

		//change toolbar and statusbar icons
		if (host) {
			base = this.getBaseDomain(host);
			actionBase = this.testPermission(base);
			actionFull = this.testPermission(host);

			/*if the base domain has the same permission as the full domain then you
			know the base domain is saved in the exceptions. there's an outside chance
			that both domains could appear in the exceptions with the same permission
			but it's a redundant operation so we don't test for it. if the base domain
			permission is different from the full domain then either the full domain
			appears in the exceptions or both the full and base domains have different
			permissions assigned to them. in either case we will display the full domain
			to guarantee that the correct icon and menu item labels are displayed.*/

			if (actionFull==8) {
				var tempExc = this.getCSTempExceptions();
				if (tempExc.testTempExceptions((actionFull == actionBase) ? base : host)) {
					img = 'temp';
					actionFull = actionBase = 'T';
				} else {
					img = 'session';
				}
			} else if (actionFull==1) {
				img = 'allowed';
			} else if (actionFull==2) {
				img = 'blocked';
			}
		}

		//if no exception is saved change icons based on global prefs
		if (!actionFull) {
			var gPrefs = this.getGlobalPrefs();
			var behavior = gPrefs.getIntPref('cookieBehavior');
			var policy = gPrefs.getIntPref('lifetimePolicy');
			if (behavior==2) {
				img = 'blocked';
			} else {
				img = (policy==2) ? 'session' : 'allowed';
			}
		}

		//determine whether to display full or base domain on menu items (see note above)
		var site = (actionFull == actionBase) ? base : host;

		return {action:actionFull,host:site,image:img};
	},

	load: function() {
		var info = this.getHostActionImg();

		//set cookiesafe icons
		var dom = this.getDOM();
		if (dom.sts) dom.sts.setAttribute('cookiesafe',info.image);
		if (dom.btn) dom.btn.setAttribute('cookiesafe',info.image);
		if (dom.ctx) dom.ctx.setAttribute('cookiesafe',info.image);
	},

	populateMenu: function(item) {
		var elem,info;
		var mitems = [];
		var elmnts = [];
		var dom = this.getDOM();
		var hmi = this.getCSHiddenMenuItems();
		var hosts = hmi.getHiddenMenuItems();

		if (item.id.substr(0,20) != 'cookiesafe-menupopup') {
			info = this.getHostActionImg();
		}

		while(item.firstChild &&
			item.firstChild.id != 'cookiesafe-context2') {
			item.removeChild(item.firstChild);
		}

		if (item.id=='cookiesafe-status-menupopup') {
			mitems = mitems.concat(cookiesafeMenuItems.leftclick);
		} else if (item.id=='cookiesafe-button-menupopup') {
			mitems = mitems.concat(cookiesafeMenuItems.leftclick);
			mitems.reverse();
		} else if (item.id=='cookiesafe-context-menupopup') {
			mitems = mitems.concat(
					cookiesafeMenuItems.leftclick.concat(
					cookiesafeMenuItems.contextOnly));
			dom.ctx2.setAttribute('hidden',(hosts.indexOf('cookiesafe-context2')==-1) ? false : true);
		} else {
			mitems = mitems.concat(cookiesafeMenuItems.rightclick);
			//var pos = (document.popupNode.id=='cookiesafe-status') ? 'before_start' : 'after_start';
			//item.setAttribute('position',pos);
		}

		for (var i=0; i<mitems.length; ++i) {
			if (hosts.indexOf(mitems[i][1][1])==-1) {
				elem = this.createMenuItem(mitems[i]);
				//only change attributes for left click menu
				if (item.id.substr(0,20) != 'cookiesafe-menupopup') {
					elem = this.changeAttributes(elem,info);
				}
				elmnts.push(elem);
			}
		}

		for (var i=0; i<elmnts.length; ++i) {
			if (item.id == 'cookiesafe-context-menupopup') {
				item.insertBefore(elmnts[i],dom.ctx2);
			} else {
				item.appendChild(elmnts[i]);
			}
		}
	},

	createMenuItem: function(item) {
		var mnuitm = document.createElement(item[0]);
		for (var i=1; i<item.length; ++i) {
			if (item[i][0]=='label') {
				mnuitm.setAttribute(item[i][0],this.getStr(item[i][1]));
			} else {
				mnuitm.setAttribute(item[i][0],item[i][1]);
			}
		}
		return mnuitm;
	},

	changeAttributes: function(item,info) {
		//the order of the strings and hosts on the menu item labels need
		//to be reversed for some locales, the order is saved as the
		//cookiesafe.MenuitemStringOrder string in each locale, 0 = string
		//then host, 1 = host then string, 2 = host then string and reverse
		//the strings, we use the _order variable for these purposes

		var label;
		var gPrefs = this.getGlobalPrefs();
		var behavior = gPrefs.getIntPref('cookieBehavior');

		//set attribute to either hidden or disabled based on user pref
		var prefs = cookiesafe.getPrefs();
		var hide = prefs.getBoolPref('hideMenuItem');
		var attr = (hide) ? 'hidden' : 'disabled';

		//change display name for file urls
		var name = (info.host=='scheme:file') ? 'file://' : info.host;

		switch (item.id) {

			case 'cookiesafe-global-allow':
				item.setAttribute('hidden',(behavior!=2) ? true : false);
				break;

			case 'cookiesafe-global-deny':
				item.setAttribute('hidden',(behavior==2) ? true : false);
				break;

			case 'cookiesafe-sep1':
				item.setAttribute('hidden',(!info.host) ? true : false);
				break;

			case 'cookiesafe-block':
				item.setAttribute((!info.host) ? 'hidden' : attr,(!info.host || info.action==2) ? true : false);
				item.setAttribute('label',(this._order < 1) ? this._block+" "+name : name+" "+this._block);
				item.setAttribute('oncommand','cookiesafe.addException("'+info.host+'","block");');
				break;

			case 'cookiesafe-remove':
				item.setAttribute('hidden',(!info.host || !info.action) ? true : false);
				item.setAttribute('label',(this._order < 1) ? this._remove+" "+name : name+" "+this._remove);
				item.setAttribute('oncommand','cookiesafe.addException("'+info.host+'","remove");');
				break;

			case 'cookiesafe-sep2':
				item.setAttribute('hidden',(!info.host) ? true : false);
				break;

			case 'cookiesafe-allow':
				item.setAttribute((!info.host) ? 'hidden' : attr,(!info.host || info.action==1) ? true : false);
				item.setAttribute('label',(this._order < 1) ? this._allow+" "+name : name+" "+this._allow);
				item.setAttribute('oncommand','cookiesafe.addException("'+info.host+'","allow");');
				break;

			case 'cookiesafe-session':
				if (this._order == 0) {
					label = this._allow+" "+name+" "+this._session;
				} else if (this._order == 1) {
					label = name+" "+this._allow+" "+this._session;
				} else {
					label = name+" "+this._session+" "+this._allow;
				}
				item.setAttribute('label',label);
				item.setAttribute((!info.host) ? 'hidden' : attr,(!info.host || info.action==8) ? true : false);
				item.setAttribute('oncommand','cookiesafe.addException("'+info.host+'","session");');
				break;

			case 'cookiesafe-temporary':
				item.setAttribute((!info.host) ? 'hidden' : attr,(!info.host || info.action=='T') ? true : false);
				item.setAttribute('label',(this._order < 1) ? this._temp+" "+name : name+" "+this._temp);
				item.setAttribute('oncommand','cookiesafe.addException("'+info.host+'","temp");');
				break;
		}

		return item;
	},

	allowAll: function(allow) {
		var prefs = this.getPrefs();
		var gPrefs = this.getGlobalPrefs();

		/*when autoRefresh is called while the cookieBehavior observer is active
		it causes a bug which prevents the user from typing in the location bar.
		it appears that focus gets stuck on the popup menu. pressing A will allow
		cookies globally while pressing D will deny cookies globally. until this
		bug can be resolved the autoRefresh method must be called from a timeout to
		allow the pref observer enough time to call the load() method.*/

		if (allow) {
			gPrefs.setIntPref('cookieBehavior',prefs.getIntPref('globalBehavior'));
			window.setTimeout(cookiesafe.autoRefresh,500);
		} else {
			gPrefs.setIntPref('cookieBehavior',2);
		}
	},

	isValidDomain: function(host) {
		var test = host.search(/[~!@#$%^&*()_+|`=\\\[\];',\/{}"<>? ]/);
		return (test==-1) ? true : false;
	},

	addException: function(site,exc) {
		if (!site || !exc) return false;

		var prefs = this.getPrefs();
		var prDom = prefs.getBoolPref('promptDomain');

		if (prDom) {
			site = prompt(this.getStr('cookiesafe.EnterDomain'),site);
			if (!site) return false;
			while (!this.isValidDomain(site)) {
				site = prompt(this.getStr('cookiesafe.DomainError'),site);
				if (!site) return false;
			}
		}

		this.addException2(site,exc);
		return false;
	},

	addException2: function(site,exc) {
		if (!site || !exc) return false;

		//remove temp exception if it exists
		var tempExc = this.getCSTempExceptions();
		tempExc.removeTempExceptions(site);

		var mngr = this.getPermManager();
		var url = (site=='scheme:file') ? 'file:///cookiesafe' : 'http://'+site;
		var uri = this.getURI(url);
		var type = (exc=='remove') ? 'deleted' : 'added';

		if (exc=='remove') {
			mngr.remove(site,'cookie');
		} else if (exc=='allow') {
			mngr.add(uri,'cookie',1);
		} else if (exc=='block') {
			mngr.add(uri,'cookie',2);
		} else if (exc=='session') {
			mngr.add(uri,'cookie',8);
		} else if (exc=='temp') {
			tempExc.addTempExceptions(site);
			mngr.add(uri,'cookie',8);
		}

		//notify csperm-changed observer in TB2 only
		if (this.TB2) {
			var os = this.getObserver();
			os.notifyObservers(null,'csperm-changed',type);
		}

		window.setTimeout(cookiesafe.autoRefresh,500);
		return false;
	},

	autoRefresh: function() {
		var prefs = cookiesafe.getPrefs();
		var auto = prefs.getBoolPref('autoRefresh');
		try {
			if (auto) window.content.location.reload();
		} catch(e) { }
	},

	showContextPopup: function() {
		if ('gContextMenu' in window && gContextMenu) {
			var dom = cookiesafe.getDOM();
			var show = gContextMenu.inDirList ||
					gContextMenu.onImage ||
					gContextMenu.isContentSelected ||
					gContextMenu.onLink ||
					gContextMenu.onTextInput;
			if (dom.ctx) dom.ctx.setAttribute('hidden',(show) ? true : false);
		}
	},

	hideMenuItem: function(item) {
		if (!item) return false;

		//remove oncommand attribute before proceeding, in gecko 1.9 the
		//ondraggesture event does not automatically cancel other events
		//on the same element when it's triggered which can cause both
		//ondraggesture and oncommand to be triggered at the same time
		item.removeAttribute('oncommand');

		var prefs = this.getPrefs();
		var ask = prefs.getBoolPref('promptMenuItem');
		var rem = (ask) ? confirm(this.getStr('cookiesafe.ConfirmHideItem')) : true;
		if (rem) this.hideMenuItem2(item);
		return false;
	},

	hideMenuItem2: function(item) {
		if (!item) return false;

		var hmi = this.getCSHiddenMenuItems();
		hmi.addHiddenMenuItems(item.id);

		//make sure options window is updated if open
		var os = this.getObserver();
		os.notifyObservers(item,'cookiesafe-menuitems-changed','deleted');
		return false;
	},

	removeTempExceptions: function() {
		var prefs = this.getPrefs();
		var perms = prefs.getCharPref('tempExceptions');
		if (!perms) return false;

		//remove temp exceptions
		perms = perms.split(' ');
		var mngr = this.getPermManager();
		for (var i=0; i<perms.length; ++i) {
			if (!perms[i]) continue;
			try {
				mngr.remove(perms[i],'cookie');
			} catch(e) {
				continue;
			}
		}

		prefs.setCharPref('tempExceptions','');
		return false;
	},

	clearCookies: function() {
		var prefs = this.getPrefs();
		var ask = prefs.getBoolPref('promptClear');
		var clr = (ask) ? confirm(this.getStr('cookiesafe.ConfirmClearCk')) : true;
		if (clr) this.clearCookies2();
	},

	clearCookies2: function() {
		var mngr = this.getCookieManager();
		mngr.removeAll();
	},

	clearExceptions: function() {
		var prefs = this.getPrefs();
		var ask = prefs.getBoolPref('promptClear');
		var clr = (ask) ? confirm(this.getStr('cookiesafe.ConfirmClearEx')) : true;
		if (clr) this.clearExceptions2();
	},

	clearExceptions2: function() {
		var tempExc = this.getCSTempExceptions();
		tempExc.clearTempExceptions();

		var exc,perms,temp;
		var mngr = this.getPermManager();
		if (mngr instanceof Components.interfaces.nsIPermissionManager) {
			perms = mngr.enumerator;
			while (('hasMoreElements' in perms && perms.hasMoreElements()) ||
				 ('hasMore' in perms && perms.hasMore())) {
				exc = perms.getNext();
				exc.QueryInterface(Components.interfaces.nsIPermission);
				if (exc.type=='cookie') {
					mngr.remove(exc.host,'cookie');
				}
			}
		} else { //for TB2 only
			mngr.removeAll();
			var os = this.getObserver();
			os.notifyObservers(null,'csperm-changed','cleared');
		}
	},

	viewCookies: function() {
		var prefs = this.getPrefs();
		var brows = this.getAppInfo();
		if (brows.name=='Thunderbird' || !prefs.getBoolPref('useBrowserDialogs')) {
			window.openDialog("chrome://cookiesafe/content/cookiesafeCookies.xul","_blank","chrome,resizable=yes", null);
			return false;
		}

		if (brows.name=='SeaMonkey' || brows.name=='Mozilla') {
			window.openDialog("chrome://communicator/content/permissions/cookieViewer.xul","_blank", "chrome,resizable=yes", null);
		} else if (brows.name=='Netscape') {
			window.openDialog("chrome://browser/content/cookieviewer/CookieViewer.xul","_blank", "chrome,resizable=yes", "cookieManager");
		} else {
			window.openDialog("chrome://browser/content/preferences/cookies.xul","_blank","chrome,resizable=yes", null);
		}
		return false;
	},

	viewExceptions: function() {
		var introtext,title,params;
		var prefs = this.getPrefs();
		var brows = this.getAppInfo();
		if (brows.name=='Thunderbird' || !prefs.getBoolPref('useBrowserDialogs')) {
			introtext = this.getStr('cookiesafe.ExcWinIntro');
			title = this.getStr('cookiesafe.ExcWinTitle');

			params = {  blockVisible   : true, 
					sessionVisible : true, 
					allowVisible   : true, 
					prefilledHost  : "", 
					permissionType : "cookie",
					windowTitle    : title,
					introText      : introtext };

			window.openDialog("chrome://cookiesafe/content/cookiesafePermissions.xul","_blank","chrome,resizable=yes", params);
			return false;
		}

		if (brows.name=='SeaMonkey' || brows.name=='Mozilla') {
			window.openDialog("chrome://communicator/content/permissions/cookieViewer.xul","_blank", "chrome,resizable=yes", null);
			window.setTimeout(changeTabSM,200);
		} else if (brows.name=='Netscape') {
			params = {  blockVisible   : true,
                   		sessionVisible : true,
                   		allowVisible   : true,
                   		prefilledHost  : "",
                   		permissionType : "cookie" };

    			window.openDialog("chrome://browser/content/cookieviewer/CookieExceptions.xul","_blank", "chrome,resizable=yes", params);
		} else {
			introtext = this.getStr('cookiesafe.ExcWinIntro');
			title = this.getStr('cookiesafe.ExcWinTitle');

			params = {  blockVisible   : true, 
					sessionVisible : true, 
					allowVisible   : true, 
					prefilledHost  : "", 
					permissionType : "cookie",
					windowTitle    : title,
					introText      : introtext };

			window.openDialog("chrome://browser/content/preferences/permissions.xul","_blank","chrome,resizable=yes", params);
		}
		return false;
	},

	viewAbout: function() {
		window.openDialog("chrome://cookiesafe/content/cookiesafeAbout.xul","_blank", "chrome,centerscreen,resizable=yes", null);
	},

	viewOptions: function() {
		window.openDialog("chrome://cookiesafe/content/cookiesafeOptions.xul","_blank", "chrome,centerscreen,resizable=yes", null);
	},

	viewHelp: function() {
		var brwsr = getBrowser();
		if ('addTab' in brwsr) {
			var tab = brwsr.addTab('http://forum.softwareblaze.com');
			brwsr.selectedTab = tab;
		} else {
			window.content.location = 'http://forum.softwareblaze.com';
		}
	},

	showSupportThread: function(ev,menu,thread) {
		if (ev.which <= 1) return false;

		ev.preventDefault();
		menu.hidePopup();
		var brwsr = getBrowser();
		if ('addTab' in brwsr) {
			var tab = brwsr.addTab('http://forum.softwareblaze.com/viewtopic.php?t='+thread);
			brwsr.selectedTab = tab;
		} else {
			window.content.location = 'http://forum.softwareblaze.com/viewtopic.php?t='+thread;
		}

		return false;
	},

	viewLast10Hosts: function() {
		window.openDialog("chrome://cookiesafe/content/cookiesafeLast10Hosts.xul","_blank", "chrome,centerscreen,resizable=yes", null);
	},

	viewEditCookies: function() {
		window.openDialog("chrome://cookiesafe/content/cookiesafeEditCookies.xul","_blank", "chrome,centerscreen,resizable=yes", null);
	},

	globalPrompt: function() {
		var prefs = this.getPrefs();
		if (prefs.getBoolPref('promptGlobal')) {
			window.openDialog("chrome://cookiesafe/content/cookiesafeGlobalPrompt.xul","_blank", "chrome,centerscreen,resizable=yes", null);
		} else {
			this.allowAll(true);
		}
	}
};


var cookiesafeStartup = {

	init: function() {
		//check if browser is TB2
		var brows = cookiesafe.getAppInfo();
		var num = parseInt(brows.version);
		if (brows.name=='Thunderbird' && num==2) {
			cookiesafe.TB2 = true;
		}

		//uninstall cookiesafe if found
		var mngr = cookiesafe.getExtManager();
		if (mngr) {
			var ext = mngr.getItemForID('{9D23D0AA-D8F5-11DA-B3FC-0928ABF316DD}');
			if (ext && ext.name) {
				mngr.uninstallItem('{9D23D0AA-D8F5-11DA-B3FC-0928ABF316DD}');
				cookiesafe.restartBrowser();
			}
		}

		//check if cshostperm.sqlite db exists and is writable for TB2
		if (cookiesafe.TB2) {
			var permdb = cookiesafe.getProfile();
			permdb.append('cshostperm.sqlite');
			if (!permdb.exists()) {
				var permMngr = cookiesafe.getPermManager();
				permMngr.copyCSDBToProfile();
				if (!permdb.exists()) {
					cookiesafe.showDBWarning('notfound',permdb.path);
					return false;
				}
			}
			if (!permdb.isWritable()) {
				cookiesafe.showDBWarning('readonly',permdb.path);
				return false;
			}
		}

		//clear temp exceptions here in case browser crashed before
		//the task was completed on shutdown
		cookiesafe.removeTempExceptions();

		//clear last 10 hosts array
		var lt = cookiesafe.getCSLast10Hosts();
		lt.clearLastTenHosts();

		//disable cookies globally based on user pref
		var prefs = cookiesafe.getPrefs();
		var dglobal = prefs.getBoolPref('disableOnStartup');
		if (dglobal) {
			var gPrefs = cookiesafe.getGlobalPrefs();
			gPrefs.setIntPref('cookieBehavior',2);
		}

		//check for updates
		/*var auto = prefs.getIntPref('autoUpdate');
		if (auto) {
			var dt = new Date();
			var time = parseInt(dt.getTime()/1000);
			var last = parseInt(prefs.getIntPref('lastUpdate'));
			if ((auto==1 && time>(last+604800)) ||
			    (auto==2 && time>(last+2629744))) {
				cookiesafeUpdate.updateBlocklist();
			}
		}*/
		return false;
	}
};
