/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



window.addEventListener('load', cookiesafeOptionsInit, false);

function cookiesafeOptionsInit() {
	//register the observer
	csMenuItemsObserver.init();

	cookiesafeOptions.load();
}

window.addEventListener('unload', cookiesafeOptionsExit, false);

function cookiesafeOptionsExit() {
	//unregister the observer
	csMenuItemsObserver.uninit();
}

var csMenuItemsObserver = {
	init: function() {
		var os = this.getObserver();
		os.addObserver(this, 'cookiesafe-menuitems-changed', false);
	},

	uninit: function() {
		var os = this.getObserver();
		os.removeObserver(this, 'cookiesafe-menuitems-changed');
	},

	QueryInterface : function(aIID) {
		if (aIID.equals(Components.interfaces.nsISupports) ||
		    aIID.equals(Components.interfaces.nsIObserver))
			return this;
		throw Components.results.NS_NOINTERFACE;
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getCS: function() {
		return Components.classes['@mozilla.org/CookieSafe;1'].
		createInstance(Components.interfaces.nsICookieSafe);
	},

	getCSHiddenMenuItems: function() {
		return Components.classes['@mozilla.org/CSHiddenMenuItems;1'].
		createInstance(Components.interfaces.nsICSHiddenMenuItems);
	},

	getCSLast10Hosts: function() {
		return Components.classes['@mozilla.org/CSLast10Hosts;1'].
		getService(Components.interfaces.nsICSLast10Hosts);
	},

	getCSTempExceptions: function() {
		return Components.classes['@mozilla.org/CSTempExceptions;1'].
		getService(Components.interfaces.nsICSTempExceptions);
	},

	observe: function(aSubject, aTopic, aData) {
		if (aTopic!='cookiesafe-menuitems-changed') return false;

		/*the notification topics are somewhat confusing as to their true
		definition. an added notification will cause the menuitem to be
		removed from the options window listbox. the added notification is
		meant to be interpreted as 'a menuitem has been added to the popup
		menus' and NOT 'a menuitem has been added to the listbox'. the
		deleted notification is similar in that it is meant to be interpreted
		as 'a menuitem has been removed from the popup menus'.*/

		var box = document.getElementById('hiddenMenuItems');
		if (aData == 'added') {
			//remove listitem here
			var rows = box.getRowCount();
			for (var i=0; i<rows; ++i) {
				item = box.getItemAtIndex(i);
				if (item.value == (aSubject.value || aSubject.id)) {
					box.removeItemAt(i);
					break;
				}
			}
		} else if (aData == 'deleted') {
			//add listitem here
			var id = (aSubject.value || aSubject.id);
			var listitem = document.createElement('listitem');
			listitem.setAttribute('value',id);
			var listcell = document.createElement('listcell');
			listcell.className = 'listcell-iconic cs' + id.substr(id.indexOf('-'));
			listcell.setAttribute('label',cookiesafeOptions.getMenuItemString(id));
			listitem.appendChild(listcell);
			box.appendChild(listitem);
		}
		return false;
	}
};

var cookiesafeOptions = {

	getURI: function(url) {
		return Components.classes["@mozilla.org/network/io-service;1"].
		getService(Components.interfaces.nsIIOService).
		newURI(url,null,null);
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getCS: function() {
		return Components.classes['@mozilla.org/CookieSafe;1'].
		createInstance(Components.interfaces.nsICookieSafe);
	},

	getCSHiddenMenuItems: function() {
		return Components.classes['@mozilla.org/CSHiddenMenuItems;1'].
		createInstance(Components.interfaces.nsICSHiddenMenuItems);
	},

	getCSLast10Hosts: function() {
		return Components.classes['@mozilla.org/CSLast10Hosts;1'].
		getService(Components.interfaces.nsICSLast10Hosts);
	},

	getCSTempExceptions: function() {
		return Components.classes['@mozilla.org/CSTempExceptions;1'].
		getService(Components.interfaces.nsICSTempExceptions);
	},

	getStr: function(name) {
		return document.getElementById("cookiesafe-bundle").getString(name);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("");
	},

	getWin: function(name) {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow(name);
	},

	load: function() {
		var prefs = this.getPrefs();

		var chkbxs = document.getElementsByTagName('checkbox');
		for (var i=0; i<chkbxs.length; ++i) {
			chkbxs[i].checked = prefs.getBoolPref(chkbxs[i].id);
		}

		var txtbxs = document.getElementsByTagName('textbox');
		for (var i=0; i<txtbxs.length; ++i) {
			if (txtbxs[i].id == 'network.cookie.lifetime.days') {
				txtbxs[i].value = prefs.getIntPref(txtbxs[i].id);
			} else {
				txtbxs[i].value = prefs.getCharPref(txtbxs[i].id);
			}
		}

		var mnulst = document.getElementsByTagName('menulist');
		for (var i=0; i<mnulst.length; ++i) {
			if (mnulst[i].id == 'cookiesafe.defaultSkin') {
				mnulst[i].selectedIndex = this.convertSkinUrl(prefs.getCharPref(mnulst[i].id));
			} else {
				mnulst[i].selectedIndex = prefs.getIntPref(mnulst[i].id);
			}
		}

		//show policy.days textbox only if lifetimePolicy is set to 3
		var lp = document.getElementById('network.cookie.lifetimePolicy');
		if (parseInt(lp.selectedIndex) == 3) this.lifetimeDays(false);

		//create cookiesafe listbox items
		this.createListItems();
	},

	createListItems: function() {
		var listitem,listcell;
		var hmi = this.getCSHiddenMenuItems();
		var hidden = hmi.getHiddenMenuItems();
		var box = document.getElementById('hiddenMenuItems');

		while(box.firstChild) {
			box.removeChild(box.firstChild);
		}

		if (!hidden) return false;

		hidden = hidden.split(' ');
		for (var i=0; i<hidden.length; ++i) {
			if (!hidden[i]) continue;
			listitem = document.createElement('listitem');
			listitem.setAttribute('value',hidden[i]);
			listcell = document.createElement('listcell');
			listcell.className = 'listcell-iconic cs' + hidden[i].substr(hidden[i].indexOf('-'));
			listcell.setAttribute('label',this.getMenuItemString(hidden[i]));
			listitem.appendChild(listcell);
			box.appendChild(listitem);
		}
		return false;
	},

	onDialogAccept: function() {
		var prefs = this.getPrefs();

		var chkbxs = document.getElementsByTagName('checkbox');
		for (var i=0; i<chkbxs.length; ++i) {
			prefs.setBoolPref(chkbxs[i].id,chkbxs[i].checked);
		}

		var txtbxs = document.getElementsByTagName('textbox');
		for (var i=0; i<txtbxs.length; ++i) {
			if (txtbxs[i].id == 'network.cookie.lifetime.days') {
				prefs.setIntPref(txtbxs[i].id,parseInt(txtbxs[i].value));
			} else {
				prefs.setCharPref(txtbxs[i].id,txtbxs[i].value);
			}
		}

		var mnulst = document.getElementsByTagName('menulist');
		for (var i=0; i<mnulst.length; ++i) {
			if (mnulst[i].id == 'cookiesafe.defaultSkin') {
				prefs.setCharPref(mnulst[i].id,mnulst[i].value);
			} else {
				prefs.setIntPref(mnulst[i].id,parseInt(mnulst[i].selectedIndex));
			}
		}
	},

	convertSkinUrl: function(url) {
		switch (url) {
			case 'chrome://cookiesafe/skin/': return 0;

			case 'chrome://cookiesafe/content/iconsets/hand/': return 1;

			case 'chrome://cookiesafe/content/iconsets/sweets/': return 2;

			case 'chrome://cookiesafe/content/iconsets/simple/': return 3;

			case 'chrome://cookiesafe/content/iconsets/simple3d/': return 4;

			default: return 0;
		}
	},

	showMenuItem: function() {
		var uri;
		var mitems = [];
		var os = this.getObserver();
		var hmi = this.getCSHiddenMenuItems();
		var box = document.getElementById('hiddenMenuItems');

		while (box.selectedItems.length>0) {
			hmi.removeHiddenMenuItems(box.selectedItems[0].value);
			os.notifyObservers(box.selectedItems[0],'cookiesafe-menuitems-changed','added');
		}
	},

	resetPrefs: function() {
		var prefs = this.getPrefs();
		var chkbxs = document.getElementsByTagName('checkbox');
		for (var i=0; i<chkbxs.length; ++i) {
			if (prefs.prefHasUserValue(chkbxs[i].id)) {
				prefs.clearUserPref(chkbxs[i].id);
			}
		}

		var txtbxs = document.getElementsByTagName('textbox');
		for (var i=0; i<txtbxs.length; ++i) {
			if (prefs.prefHasUserValue(txtbxs[i].id)) {
				prefs.clearUserPref(txtbxs[i].id);
			}
		}

		var mnulst = document.getElementsByTagName('menulist');
		for (var i=0; i<mnulst.length; ++i) {
			if (prefs.prefHasUserValue(mnulst[i].id)) {
				prefs.clearUserPref(mnulst[i].id);
			}
		}
		this.load();
	},

	isValid: function(box) {
		box.value = box.value.replace(/[a-zA-Z~`!@#$%^&*()_+|\-=\\{}\[\]:\";\'<>?,.\/ ]/g,'');
		if (box.value.length>1 && parseInt(box.value.charAt(0))==0) box.value = '';
	},

	lifetimeDays: function(tf) {
		document.getElementById('lifetimeDays').setAttribute('collapsed',tf);
	},

	getMenuItemString: function(id) {
		switch (id) {
			case 'cookiesafe-global-allow':
				return this.getStr('cookiesafe.AllowGlobal');

			case 'cookiesafe-global-deny':
				return this.getStr('cookiesafe.DenyGlobal');

			case 'cookiesafe-block':
				return this.getStr('cookiesafe.lBlock');

			case 'cookiesafe-remove':
				return this.getStr('cookiesafe.lRemove');

			case 'cookiesafe-allow':
				return this.getStr('cookiesafe.lAllow');

			case 'cookiesafe-session':
				return this.getStr('cookiesafe.lSession');

			case 'cookiesafe-temporary':
				return this.getStr('cookiesafe.lTemporarilyAllow');

			case 'cookiesafe-support':
				return this.getStr('cookiesafe.Support');

			case 'cookiesafe-about':
				return this.getStr('cookiesafe.lAboutCookiesafe');

			case 'cookiesafe-options':
				return this.getStr('cookiesafe.lCookiesafeOptions');

			case 'cookiesafe-view-cookies':
				return this.getStr('cookiesafe.lViewCookies');

			case 'cookiesafe-edit-cookies':
				return this.getStr('cookiesafe.lEditCookies');

			case 'cookiesafe-clear-cookies':
				return this.getStr('cookiesafe.lClearCookies');

			case 'cookiesafe-view-exceptions':
				return this.getStr('cookiesafe.lViewExceptions');

			case 'cookiesafe-clear-exceptions':
				return this.getStr('cookiesafe.lClearExceptions');

			case 'cookiesafe-update':
				return this.getStr('cookiesafe.lUpdateBlocklist');

			case 'cookiesafe-last10hosts':
				return this.getStr('cookiesafe.lLast10Hosts');

			case 'cookiesafe-context2':
				return this.getStr('cookiesafe.lCsLiteMenu');

			default:
				return this.getStr('cookiesafe.lSeparator');
		}
	}
};
