/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/


var csPermObserver = {

	lastCalled: 0,

	init: function() {
		var os = this.getObserver();
		os.addObserver(this, 'perm-changed', false);
		os.addObserver(this, 'csperm-changed', false);
	},

	uninit: function() {
		var os = this.getObserver();
		os.removeObserver(this, 'perm-changed');
		os.removeObserver(this, 'csperm-changed');
	},

	QueryInterface : function(aIID) {
		if (aIID.equals(Components.interfaces.nsISupports) ||
		    aIID.equals(Components.interfaces.nsIObserver))
			return this;
		throw Components.results.NS_NOINTERFACE;
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getCS: function() {
		return Components.classes['@mozilla.org/CookieSafe;1'].
		createInstance(Components.interfaces.nsICookieSafe);
	},

	observe: function(aSubject, aTopic, aData) {

		if (aData=='cleared' || aTopic=='csperm-changed') {
			if (!cookiesafe.isFlashing()) cookiesafe.load();
			return false;
		}

		var perm = aSubject.QueryInterface(Components.interfaces.nsIPermission);
		if (perm.type!='cookie') return false;

		//get base domain of permission sent to this observer
		var cs = this.getCS();
		var base = cs.removeSub(perm.host);

		//make sure host relates to current webpage before resetting icons
		var site = this.getDomain();
		if (site && site.indexOf(base)!=-1 && !cookiesafe.isFlashing()) {
			cookiesafe.load();
		}

		/*check the number of milliseconds between notifications and uninit
		if necessary to prevent overflow and speed up process of adding or
		deleting multiple exceptions at once*/

		var dt = new Date();
		var time = dt.getTime();
		if ((time - this.lastCalled) < 1000) {
			this.uninit();
			window.setTimeout(cookiesafeInitPermObserver,1050);
		}
		this.lastCalled = time;

		return false;
	},

	getDomain: function() {
		var site = null;
		try {
			site = window.content.document.domain;
			if (!site) {
				var url = window.content.location.href;
				if (url.substr(0,5)=='file:') site = 'scheme:file';
			}
		} catch(e) {
			try {
				var url = window.content.location.href;
				if (url.substr(0,5)=='file:') site = 'scheme:file';
			} catch(e) { }
		}
		return site;
	}
};

var csCookieObserver = {

	init: function() {
		var os = this.getObserver();
		os.addObserver(this, 'cookie-changed', false);
		os.addObserver(this, 'cookie-rejected', false);
	},

	uninit: function() {
		var os = this.getObserver();
		os.removeObserver(this, 'cookie-changed');
		os.removeObserver(this, 'cookie-rejected');
	},

	QueryInterface : function(aIID) {
		if (aIID.equals(Components.interfaces.nsISupports) ||
		    aIID.equals(Components.interfaces.nsIObserver))
			return this;
		throw Components.results.NS_NOINTERFACE;
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	getDOM: function() {
		var sts = document.getElementById('cookiesafe-status');
		var btn = document.getElementById('cookiesafe-button');
		return {sts:sts,btn:btn};
	},

	observe: function(aSubject, aTopic, aData) {
		var dom = this.getDOM();
		var prefs = this.getPrefs();
		var flashBlk = prefs.getBoolPref('hideBlocked');
		var flashAdd = prefs.getBoolPref('hideChanged');
		var img = (aTopic=='cookie-rejected') ? 'flashRejected' : 'flashAdded';

		if ((aTopic=='cookie-rejected' && !flashBlk) ||
		    (aTopic=='cookie-changed' && !flashAdd)) {
			if (!cookiesafe.isFlashing()) window.setTimeout(cookiesafeResetIcon,3000);
			if (dom.sts) dom.sts.setAttribute('cookiesafe',img);
			if (dom.btn) dom.btn.setAttribute('cookiesafe',img);
		}
	}
};

var csPrefObserver = {

	prefs: null,
	gPrefs: null,

	init: function() {
		this.prefs = this.getPrefs();
		this.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.prefs.addObserver("", this, false);

		this.gPrefs = this.getGlobalPrefs();
		this.gPrefs.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.gPrefs.addObserver("", this, false);
	},

	uninit: function() {
		this.prefs.removeObserver("", this);
		this.gPrefs.removeObserver("", this);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	getGlobalPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("network.cookie.");
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	observe: function(subject, topic, data) {
		if (topic != "nsPref:changed") return false;

		switch(data) {
			case "hideContext":
			   cookiesafe.hideContext();
			   break;

			case "hideStatus":
			   cookiesafe.hideStatus();
			   break;

			case "cookieBehavior":
			   if (!cookiesafe.isFlashing()) cookiesafe.load();
			   break;

			case "lifetimePolicy":
			   if (!cookiesafe.isFlashing()) cookiesafe.load();
			   break;
		}
		return false;
	}
};
