/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/


window.addEventListener('load',cookiesafeSkinLoad,false);

function cookiesafeSkinLoad() {
	cookiesafeChangeSkin.init();
}

window.addEventListener('unload',cookiesafeSkinUnload,false);

function cookiesafeSkinUnload() {
	cookiesafeChangeSkin.exit();
}

var csStyleSheetObserver = {

	prefs: null,

	init: function() {
		this.prefs = this.getPrefs();
		this.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.prefs.addObserver("", this, false);
	},

	uninit: function() {
		this.prefs.removeObserver("", this);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	getObserver: function() {
		return Components.classes["@mozilla.org/observer-service;1"].
		getService(Components.interfaces.nsIObserverService);
	},

	observe: function(subject, topic, data) {
		if (topic != "nsPref:changed") return false;

		switch(data) {
			case "defaultSkin":
			   cookiesafeChangeSkin.load();
			   break;
		}
		return false;
	}
};

var cookiesafeChangeSkin = {

	init: function() {
		csStyleSheetObserver.init();
		this.load();
	},

	exit: function() {
		csStyleSheetObserver.uninit();
	},

	css: null,

	skinurl: null,

	getStyleSheet: function() {
		var css = document.styleSheets;
		for (var i=0; i<css.length; ++i) {
			if (css[i].href.indexOf('cookiesafeStyle')!=-1) {
				this.css = css[i];
				break;
			}
		}
	},

	changeCSS: function() {
		if (this.css.cssRules[0]) this.css.deleteRule(0);
		this.css.insertRule("@import url('"+this.skinurl+"cookiesafeSkin.css');",0);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	},

	load: function() {
		var prefs = this.getPrefs();
		this.skinurl = prefs.getCharPref('defaultSkin');
		this.getStyleSheet();
		this.changeCSS();
	}
};
