/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



var csGlobalPrompt = {

	onDialogLoad: function() {
		var prefs = this.getPrefs();

		//set checkbox prefs
		var chkbxs = document.getElementsByTagName('checkbox');
		for (var i=0; i<chkbxs.length; ++i) {
			chkbxs[i].checked = !prefs.getBoolPref(chkbxs[i].id);
		}

		//set menulist prefs
		var mnulst = document.getElementsByTagName('menulist');
		for (var i=0; i<mnulst.length; ++i) {
			mnulst[i].selectedIndex = prefs.getIntPref(mnulst[i].id);
		}
	},

	getAppInfo: function() {
		return Components.classes['@mozilla.org/xre/app-info;1'].
		createInstance(Components.interfaces.nsIXULAppInfo);
	},

	getWindowTypeForApp: function(name) {
		switch (name) {
			case 'Thunderbird':
				return 'mail:3pane';

			case 'Songbird':
				return 'Songbird:Main';

			case 'eMusic Remote':
				return 'emusic:window';

			default:
				return 'navigator:browser';
		}
	},

	onDialogAccept: function() {
		var prefs = this.getPrefs();
		var brows = this.getAppInfo();
		var win = this.getWin(this.getWindowTypeForApp(brows.name));

		//set checkbox prefs
		var chkbxs = document.getElementsByTagName('checkbox');
		for (var i=0; i<chkbxs.length; ++i) {
			prefs.setBoolPref(chkbxs[i].id,!chkbxs[i].checked);
		}

		//set menulist prefs
		var mnulst = document.getElementsByTagName('menulist');
		for (var i=0; i<mnulst.length; ++i) {
			prefs.setIntPref(mnulst[i].id,mnulst[i].selectedIndex);
		}

		//change global behavior
		win.cookiesafe.allowAll(true);
	},

	getWin: function(name) {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow(name);
	},

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("cookiesafe.");
	}
};
