/***************************************************************************
Name: CS Lite
Description: Control cookie permissions.
Author: Ron Beckman
Homepage: http://addons.mozilla.org

Copyright (C) 2007  Ron Beckman

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

Free Software Foundation, Inc.
51 Franklin Street
Fifth Floor
Boston, MA  02110-1301
USA
***************************************************************************/



var csAbout = {

	bundle: {},

	init: function() {
		var sigs = this.searchJarFile();
		this.populateListBox(sigs);
	},

	populateListBox: function(sigs) {
		var listitem,listcell1,listcell2,sig;
		var listbox = document.getElementById('translatorsNames');
		sigs.sort();

		for (var i=0; i<sigs.length; ++i) {
			if (sigs[i].length<2) continue;
			listitem = document.createElement('listitem');
			listcell1 = document.createElement('listcell');
			listcell2 = document.createElement('listcell');
			listcell1.setAttribute('label',sigs[i][1]);
			listcell2.setAttribute('label',sigs[i][0]);
			listitem.appendChild(listcell1);
			listitem.appendChild(listcell2);
			listbox.appendChild(listitem);
		}
	},

	getURI: function(url) {
		return Components.classes["@mozilla.org/network/io-service;1"].
		getService(Components.interfaces.nsIIOService).
		newURI(url,null,null);
	},

	getJarURI: function(uri) {
		return Components.classes['@mozilla.org/chrome/chrome-registry;1'].
		getService(Components.interfaces.nsIChromeRegistry).
		convertChromeURL(uri);
	},

	urlToFile: function(url) {
		return Components.classes['@mozilla.org/network/protocol;1?name=file'].
		createInstance(Components.interfaces.nsIFileProtocolHandler).
		getFileFromURLSpec(url);
	},

	getZipReaderForFile: function(zipFile) {
		try {
			var zipReader = Components.classes["@mozilla.org/libjar/zip-reader;1"].
			createInstance(Components.interfaces.nsIZipReader);

			if ('init' in zipReader) {
				zipReader.init(zipFile);
				zipReader.open();
			} else {
				zipReader.open(zipFile);
			}
		} catch (e) {
			zipReader.close();
			throw e;
		}
		return zipReader;
	},

	searchJarFile: function() {
		var sigs = [];
		var entry,folders;

		//get location of jar file
		var chromeuri = this.getURI('chrome://cookiesafe/locale/signature.properties');
		var jaruri = this.getJarURI(chromeuri);

		//create the start and end jar urls to insert locale into
		var starturl = jaruri.spec.substr(0,jaruri.spec.lastIndexOf('.jar!')+13);
		var endurl = '/cookiesafe/signature.properties';

		//the uri of the base jar file is needed here so query nsIJARURI
		jaruri.QueryInterface(Components.interfaces.nsIJARURI);
		var jarfile = this.urlToFile(jaruri.JARFile.spec);

		var zipReader = this.getZipReaderForFile(jarfile);

		try {
			var entries = zipReader.findEntries('\*signature.properties\$');
			if ('init' in zipReader) {
				while (entries.hasMoreElements()) {
					entry = entries.getNext();
					entry.QueryInterface(Components.interfaces.nsIZipEntry);
					folders = entry.name.split('/');
					sigs.push(this.setSigsBundles(folders,starturl,endurl));
				}
			} else {
				while (entries.hasMore()) {
					entry = entries.getNext();
					folders = entry.split('/');
					sigs.push(this.setSigsBundles(folders,starturl,endurl));
				}
			}
		} catch (e) {
			zipReader.close();
			throw e;
		}

		zipReader.close();

		return sigs;
	},

	getBundleService: function() {
		return Components.classes['@mozilla.org/intl/stringbundle;1'].
		getService(Components.interfaces.nsIStringBundleService);
	},

	setSigsBundles: function(folders,starturl,endurl) {
		var srv = this.getBundleService();

		//get locale name
		var locale = folders[1];

		//create jar url for each locale
		var url = starturl +locale+ endurl;

		//create string bundle for each locale and retrieve translator name
		this.bundle[locale] = srv.createBundle(url);
		var name = this.bundle[locale].GetStringFromName('translator.Name');

		return [locale,name];
	},

	getWin: function(name) {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow(name);
	},

	getAppInfo: function() {
		return Components.classes['@mozilla.org/xre/app-info;1'].
		createInstance(Components.interfaces.nsIXULAppInfo);
	},

	getWindowTypeForApp: function(name) {
		switch (name) {
			case 'Thunderbird':
				return 'mail:3pane';

			case 'Songbird':
				return 'Songbird:Main';

			case 'eMusic Remote':
				return 'emusic:window';

			default:
				return 'navigator:browser';
		}
	},

	openUrl: function(url) {
		var brows = this.getAppInfo();
		var win = this.getWin(this.getWindowTypeForApp(brows.name));

		var brwsr = win.getBrowser();
		if ('addTab' in brwsr) {
			var tab = brwsr.addTab(url);
			brwsr.selectedTab = tab;
		} else {
			win.content.location = url;
		}
	}
};
