/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.router.Router;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsFetcher;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

public class SummaryHelper
extends HelperBase {
    public String getIdent() {
        if (this._context == null) {
            return "[no router]";
        }
        if (this._context.routerHash() != null) {
            return this._context.routerHash().toBase64().substring(0, 4);
        }
        return "[unknown]";
    }

    public String getVersion() {
        return "0.7.7-0";
    }

    public String getUptime() {
        if (this._context == null) {
            return "[no router]";
        }
        Router router = this._context.router();
        if (router == null) {
            return "[not up]";
        }
        return DataHelper.formatDuration(router.getUptime());
    }

    private String timeSkew() {
        if (this._context == null) {
            return "";
        }
        long ms = this._context.clock().getOffset();
        long diff = Math.abs(ms);
        if (diff < 3000L) {
            return "";
        }
        return " (" + DataHelper.formatDuration(diff) + " skew)";
    }

    public boolean allowReseed() {
        return this._context.netDb().isInitialized() && (this._context.netDb().getKnownRouters() < 30 || Boolean.valueOf(this._context.getProperty("i2p.alwaysAllowReseed")) != false);
    }

    public int getAllPeers() {
        return Math.max(this._context.netDb().getKnownRouters() - 1, 0);
    }

    public String getReachability() {
        return this.reachability() + this.timeSkew();
    }

    private String reachability() {
        if (this._context.router().getUptime() > 60000L && !this._context.router().gracefulShutdownInProgress() && !this._context.clientManager().isAlive()) {
            return "ERR-Client Manager I2CP Error - check logs";
        }
        if (!this._context.clock().getUpdatedSuccessfully()) {
            return "ERR-ClockSkew";
        }
        if (this._context.router().isHidden()) {
            return "Hidden";
        }
        short status = this._context.commSystem().getReachabilityStatus();
        switch (status) {
            case 0: {
                RouterAddress ra = this._context.router().getRouterInfo().getTargetAddress("NTCP");
                if (ra == null || new NTCPAddress(ra).isPubliclyRoutable()) {
                    return "OK";
                }
                return "ERR-Private TCP Address";
            }
            case 1: {
                return "ERR-SymmetricNAT";
            }
            case 2: {
                if (this._context.router().getRouterInfo().getTargetAddress("NTCP") != null) {
                    return "WARN-Firewalled with Inbound TCP Enabled";
                }
                if (((FloodfillNetworkDatabaseFacade)this._context.netDb()).floodfillEnabled()) {
                    return "WARN-Firewalled and Floodfill";
                }
                if (this._context.router().getRouterInfo().getCapabilities().indexOf(79) >= 0) {
                    return "WARN-Firewalled and Fast";
                }
                return "Firewalled";
            }
            case 3: {
                return "ERR-UDP Port In Use - Set i2np.udp.internalPort=xxxx in advanced config and restart";
            }
        }
        RouterAddress ra = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (ra == null && this._context.router().getUptime() > 300000L) {
            if (this._context.getProperty("i2np.ntcp.hostname") == null || this._context.getProperty("i2np.ntcp.port") == null) {
                return "ERR-UDP Disabled and Inbound TCP host/port not set";
            }
            return "WARN-Firewalled with UDP Disabled";
        }
        return "Testing";
    }

    public int getActivePeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.commSystem().countActivePeers();
    }

    public boolean showFirewallWarning() {
        return this._context != null && this._context.netDb().isInitialized() && this._context.router().getUptime() > 120000L && this._context.commSystem().countActivePeers() <= 0 && this._context.netDb().getKnownRouters() > 5;
    }

    public int getActiveProfiles() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countActivePeers();
    }

    public int getFastPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFastPeers();
    }

    public int getHighCapacityPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countHighCapacityPeers();
    }

    public int getWellIntegratedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countWellIntegratedPeers();
    }

    public String getInboundSecondKBps() {
        if (this._context == null) {
            return "0";
        }
        double kbps = (double)this._context.bandwidthLimiter().getReceiveBps() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundSecondKBps() {
        if (this._context == null) {
            return "0";
        }
        double kbps = (double)this._context.bandwidthLimiter().getSendBps() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundFiveMinuteKBps() {
        if (this._context == null) {
            return "0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        if (receiveRate == null) {
            return "0";
        }
        Rate rate = receiveRate.getRate(300000L);
        double kbps = rate.getAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundFiveMinuteKBps() {
        if (this._context == null) {
            return "0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.sendRate");
        if (receiveRate == null) {
            return "0";
        }
        Rate rate = receiveRate.getRate(300000L);
        double kbps = rate.getAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundLifetimeKBps() {
        if (this._context == null) {
            return "0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        if (receiveRate == null) {
            return "0";
        }
        double kbps = receiveRate.getLifetimeAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundLifetimeKBps() {
        if (this._context == null) {
            return "0";
        }
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        if (sendRate == null) {
            return "0";
        }
        double kbps = sendRate.getLifetimeAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long received = this._context.bandwidthLimiter().getTotalAllocatedInboundBytes();
        return DataHelper.formatSize(received) + 'B';
    }

    public String getOutboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long sent = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        return DataHelper.formatSize(sent) + 'B';
    }

    public String getDestinations() {
        ArrayList<Destination> clients = new ArrayList<Destination>(this._context.clientManager().listClients());
        Collections.sort(clients, new AlphaComparator());
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"i2ptunnel/index.jsp\" target=\"_blank\" title=\"Add/remove/edit &amp; control your client and server tunnels (local destinations).\"  title=\"View existing tunnels and tunnel build status.\">Local destinations</a></h3><hr><table>");
        for (Destination client : clients) {
            String name = this.getName(client);
            Hash h = client.calculateHash();
            buf.append("<tr><td align=\"right\"><img src=\"/themes/console/images/");
            if (this._context.clientManager().shouldPublishLeaseSet(h)) {
                buf.append("server.png\" alt=\"Server\" title=\"Server\">");
            } else {
                buf.append("client.png\" alt=\"Client\" title=\"Client\">");
            }
            buf.append("</td><td align=\"left\"><b><a href=\"tunnels.jsp#").append(h.toBase64().substring(0, 4));
            buf.append("\" target=\"_top\" title=\"Show tunnels\">");
            if (name.length() < 16) {
                buf.append(name);
            } else {
                buf.append(name.substring(0, 15)).append("&hellip;");
            }
            buf.append("</a></b></td>\n");
            LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(h);
            if (ls != null) {
                long timeToExpire = ls.getEarliestLeaseDate() - this._context.clock().now();
                if (timeToExpire < 0L) {
                    buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"Rebuilding&hellip;\" title=\"Leases expired ").append(DataHelper.formatDuration(0L - timeToExpire));
                    buf.append(" ago. Rebuilding&hellip;\"></td></tr>\n");
                    continue;
                }
                buf.append("<td><img src=\"/themes/console/images/local_up.png\" alt=\"Ready\" title=\"Ready\"></td></tr>\n");
                continue;
            }
            buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"Building&hellip;\" title=\"Tunnel building in progress&hellip;\"></td></tr>\n");
        }
        buf.append("</table><hr>\n");
        return buf.toString();
    }

    private String getName(Destination d) {
        String name;
        TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(d.calculateHash());
        String string = name = in != null ? in.getDestinationNickname() : null;
        if (name == null) {
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(d.calculateHash());
            String string2 = name = out != null ? out.getDestinationNickname() : null;
            if (name == null) {
                name = d.calculateHash().toBase64().substring(0, 6);
            }
        }
        return name;
    }

    public int getInboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getFreeTunnelCount();
    }

    public int getOutboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundTunnelCount();
    }

    public int getInboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getInboundClientTunnelCount();
    }

    public int getOutboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundClientTunnelCount();
    }

    public int getParticipatingTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getParticipatingCount();
    }

    public String getJobLag() {
        if (this._context == null) {
            return "0ms";
        }
        Rate lagRate = this._context.statManager().getRate("jobQueue.jobLag").getRate(60000L);
        return (int)lagRate.getAverageValue() + "ms";
    }

    public String getMessageDelay() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getMessageDelay() + "ms";
    }

    public String getTunnelLag() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getTunnelLag() + "ms";
    }

    public String getTunnelStatus() {
        if (this._context == null) {
            return "";
        }
        return this._context.throttle().getTunnelStatus();
    }

    public String getInboundBacklog() {
        if (this._context == null) {
            return "0";
        }
        return String.valueOf(this._context.tunnelManager().getInboundBuildQueueSize());
    }

    public boolean updateAvailable() {
        return NewsFetcher.getInstance(this._context).updateAvailable();
    }

    public boolean unsignedUpdateAvailable() {
        return NewsFetcher.getInstance(this._context).unsignedUpdateAvailable();
    }

    public String getUpdateVersion() {
        return NewsFetcher.getInstance(this._context).updateVersion();
    }

    public String getUnsignedUpdateVersion() {
        return NewsFetcher.getInstance(this._context).unsignedUpdateVersion();
    }

    private class AlphaComparator
    implements Comparator {
        private AlphaComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            String lname = SummaryHelper.this.getName((Destination)lhs);
            String rname = SummaryHelper.this.getName((Destination)rhs);
            if (lname.equals("shared clients")) {
                return -1;
            }
            if (rname.equals("shared clients")) {
                return 1;
            }
            return Collator.getInstance().compare(lname, rname);
        }
    }
}

