/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.apps.systray.SysTray;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.NewsFetcher;
import net.i2p.router.web.StatSummarizer;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import org.mortbay.http.Authenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class RouterConsoleRunner {
    private Server _server;
    private String _listenPort = "7657";
    private String _listenHost = "127.0.0.1";
    private String _webAppsDir = "./webapps/";
    private static final String PROP_WEBAPP_CONFIG_FILENAME = "router.webappsConfigFile";
    private static final String DEFAULT_WEBAPP_CONFIG_FILENAME = "webapps.config";
    public static final String ROUTERCONSOLE = "routerconsole";
    public static final String PREFIX = "webapps.";
    public static final String ENABLED = ".startOnLoad";

    public RouterConsoleRunner(String[] args) {
        if (args.length == 3) {
            this._listenPort = args[0].trim();
            this._listenHost = args[1].trim();
            this._webAppsDir = args[2].trim();
        }
    }

    public static void main(String[] args) {
        RouterConsoleRunner runner = new RouterConsoleRunner(args);
        runner.startConsole();
    }

    public void startConsole() {
        File app;
        boolean workDirCreated;
        File workDir = new File(I2PAppContext.getGlobalContext().getTempDir(), "jetty-work");
        boolean workDirRemoved = FileUtil.rmdir(workDir, false);
        if (!workDirRemoved) {
            System.err.println("ERROR: Unable to remove Jetty temporary work directory");
        }
        if (!(workDirCreated = workDir.mkdirs())) {
            System.err.println("ERROR: Unable to create Jetty temporary work directory");
        }
        this._server = new Server();
        boolean rewrite = false;
        Properties props = RouterConsoleRunner.webAppProperties();
        if (props.size() <= 0) {
            props.setProperty("webapps.routerconsole.startOnLoad", "true");
            rewrite = true;
        }
        if (!(app = new File(this._webAppsDir)).isAbsolute()) {
            app = new File(I2PAppContext.getGlobalContext().getBaseDir(), this._webAppsDir);
            try {
                this._webAppsDir = app.getCanonicalPath();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (!this._webAppsDir.endsWith("/")) {
            this._webAppsDir = this._webAppsDir + '/';
        }
        try {
            StringTokenizer tok = new StringTokenizer(this._listenHost, " ,");
            int boundAddresses = 0;
            while (tok.hasMoreTokens()) {
                String host = tok.nextToken().trim();
                try {
                    if (host.indexOf(":") >= 0) {
                        this._server.addListener('[' + host + "]:" + this._listenPort);
                    } else {
                        this._server.addListener(host + ':' + this._listenPort);
                    }
                    ++boundAddresses;
                }
                catch (IOException ioe) {
                    System.err.println("Unable to bind routerconsole to " + host + " port " + this._listenPort + ' ' + ioe);
                }
            }
            if (boundAddresses <= 0) {
                System.err.println("Unable to bind routerconsole to any address on port " + this._listenPort);
                return;
            }
            this._server.setRootWebApp(ROUTERCONSOLE);
            WebApplicationContext wac = this._server.addWebApplication("/", this._webAppsDir + ROUTERCONSOLE + ".war");
            File tmpdir = new File(workDir, "routerconsole-" + this._listenPort);
            tmpdir.mkdir();
            wac.setTempDirectory(tmpdir);
            this.initialize(wac);
            File dir = new File(this._webAppsDir);
            String[] fileNames = dir.list(WarFilenameFilter.instance());
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    try {
                        String appName = fileNames[i].substring(0, fileNames[i].lastIndexOf(".war"));
                        String enabled = props.getProperty(PREFIX + appName + ENABLED);
                        if ("false".equals(enabled)) continue;
                        String path = new File(dir, fileNames[i]).getCanonicalPath();
                        wac = this._server.addWebApplication("/" + appName, path);
                        tmpdir = new File(workDir, appName + "-" + this._listenPort);
                        tmpdir.mkdir();
                        wac.setTempDirectory(tmpdir);
                        this.initialize(wac);
                        if (enabled != null) continue;
                        props.setProperty(PREFIX + appName + ENABLED, "true");
                        rewrite = true;
                        continue;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error resolving '" + fileNames[i] + "' in '" + dir);
                    }
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rewrite) {
            RouterConsoleRunner.storeWebAppProperties(props);
        }
        try {
            this._server.start();
        }
        catch (Throwable me) {
            System.err.println("WARNING: Error starting one or more listeners of the Router Console server.\nIf your console is still accessible at http://127.0.0.1:7657/,\nthis may be a problem only with binding to the IPV6 address ::1.\nIf so, you may ignore this error, or remove the\n\"::1,\" in the \"clientApp.0.args\" line of the clients.config file.\nException: " + me);
        }
        try {
            SysTray tray = SysTray.getInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        NewsFetcher fetcher = NewsFetcher.getInstance(I2PAppContext.getGlobalContext());
        I2PAppThread t = new I2PAppThread(fetcher, "NewsFetcher");
        t.setDaemon(true);
        t.start();
        I2PAppThread st = new I2PAppThread(new StatSummarizer(), "StatSummarizer");
        st.setDaemon(true);
        st.start();
    }

    private void initialize(WebApplicationContext context) {
        String password = this.getPassword();
        if (password != null) {
            HashUserRealm realm = new HashUserRealm("i2prouter");
            realm.put((Object)"admin", (Object)password);
            realm.addUserToRole("admin", "routerAdmin");
            context.setRealm((UserRealm)realm);
            context.setAuthenticator((Authenticator)new DigestAuthenticator());
            context.addHandler(0, (HttpHandler)new SecurityHandler());
            SecurityConstraint constraint = new SecurityConstraint("admin", "routerAdmin");
            constraint.setAuthenticate(true);
            context.addSecurityConstraint("/", constraint);
        }
    }

    private String getPassword() {
        List contexts = RouterContext.listContexts();
        if (contexts != null) {
            for (int i = 0; i < contexts.size(); ++i) {
                RouterContext ctx = (RouterContext)contexts.get(i);
                String password = ctx.getProperty("consolePassword");
                if (password == null || (password = password.trim()).length() <= 0) continue;
                return password;
            }
            return null;
        }
        return null;
    }

    public static Properties webAppProperties() {
        Properties rv = new Properties();
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), webappConfigFile);
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rv;
    }

    public static void storeWebAppProperties(Properties props) {
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), webappConfigFile);
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        System.setProperty("org.mortbay.http.Version.paranoid", "true");
        System.setProperty("java.awt.headless", "true");
    }

    private static class WarFilenameFilter
    implements FilenameFilter {
        private static final WarFilenameFilter _filter = new WarFilenameFilter();

        private WarFilenameFilter() {
        }

        public static WarFilenameFilter instance() {
            return _filter;
        }

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".war") && !name.equals("routerconsole.war");
        }
    }
}

