/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.router.web.UnsignedUpdateHandler;
import net.i2p.router.web.UpdateHandler;
import net.i2p.util.EepGet;
import net.i2p.util.EepHead;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;

public class NewsFetcher
implements Runnable,
EepGet.StatusListener {
    private I2PAppContext _context;
    private Log _log;
    private boolean _updateAvailable;
    private boolean _unsignedUpdateAvailable;
    private long _lastFetch;
    private long _lastUpdated;
    private String _updateVersion;
    private String _unsignedUpdateVersion;
    private String _lastModified;
    private File _newsFile;
    private File _tempFile;
    private static NewsFetcher _instance;
    private static final String NEWS_FILE = "docs/news.xml";
    private static final String TEMP_NEWS_FILE = "news.xml.temp";
    private static final SimpleDateFormat[] rfc822DateFormats;
    private static final String VERSION_STRING = "version=\"0.7.7\"";
    private static final String VERSION_PREFIX = "version=\"";

    public static final synchronized NewsFetcher getInstance(I2PAppContext ctx) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new NewsFetcher(ctx);
        return _instance;
    }

    private NewsFetcher(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(NewsFetcher.class);
        _instance = this;
        this._lastFetch = 0L;
        this._newsFile = new File(this._context.getRouterDir(), NEWS_FILE);
        this._tempFile = new File(this._context.getTempDir(), TEMP_NEWS_FILE);
        this.updateLastFetched();
        this._lastUpdated = this._lastFetch;
        this._updateVersion = "";
    }

    private void updateLastFetched() {
        if (this._newsFile.exists()) {
            if (this._lastFetch == 0L) {
                this._lastFetch = this._newsFile.lastModified();
            }
        } else {
            this._lastFetch = 0L;
        }
    }

    public boolean updateAvailable() {
        return this._updateAvailable;
    }

    public String updateVersion() {
        return this._updateVersion;
    }

    public boolean unsignedUpdateAvailable() {
        return this._unsignedUpdateAvailable;
    }

    public String unsignedUpdateVersion() {
        return this._unsignedUpdateVersion;
    }

    public String status() {
        long now = this._context.clock().now();
        return (this._lastUpdated > 0L ? "News last updated " + DataHelper.formatDuration(now - this._lastUpdated) + " ago" : "") + (this._lastFetch > this._lastUpdated ? ", last checked " + DataHelper.formatDuration(now - this._lastFetch) + " ago" : "");
    }

    public void run() {
        try {
            Thread.sleep(this._context.random().nextLong(300000L));
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        while (true) {
            if (!this._updateAvailable) {
                this.checkForUpdates();
            }
            if (this.shouldFetchNews()) {
                this.fetchNews();
                if (this.shouldFetchUnsigned()) {
                    this.fetchUnsignedHead();
                }
            }
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean shouldInstall() {
        String policy = this._context.getProperty("router.updatePolicy");
        if ("notify".equals(policy)) {
            return false;
        }
        File zip = new File(this._context.getRouterDir(), "i2pupdate.zip");
        return !zip.exists();
    }

    private boolean shouldFetchNews() {
        this.updateLastFetched();
        String freq = this._context.getProperty("router.newsRefreshFrequency", "86400000");
        try {
            long ms = Long.parseLong(freq);
            if (ms <= 0L) {
                return false;
            }
            if (this._lastFetch + ms < this._context.clock().now()) {
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Last fetched " + DataHelper.formatDuration(this._context.clock().now() - this._lastFetch) + " ago");
            }
            return false;
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid refresh frequency: " + freq);
            }
            return false;
        }
    }

    public void fetchNews() {
        String newsURL = ConfigUpdateHelper.getNewsURL(this._context);
        boolean shouldProxy = Boolean.valueOf(this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = this._context.getProperty("router.updateProxyPort", 4444);
        if (this._tempFile.exists()) {
            this._tempFile.delete();
        }
        try {
            EepGet get = null;
            get = shouldProxy ? new EepGet(this._context, true, proxyHost, proxyPort, 2, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified) : new EepGet(this._context, false, null, 0, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified);
            get.addStatusListener(this);
            if (get.fetch()) {
                this._lastModified = get.getLastModified();
            }
        }
        catch (Throwable t) {
            this._log.error("Error fetching the news", t);
        }
    }

    public boolean shouldFetchUnsigned() {
        String url = this._context.getProperty("router.updateUnsignedURL");
        return url != null && url.length() > 0 && Boolean.valueOf(this._context.getProperty("router.updateUnsigned")) != false;
    }

    public void fetchUnsignedHead() {
        block11: {
            String url = this._context.getProperty("router.updateUnsignedURL");
            if (url == null || url.length() <= 0) {
                return;
            }
            String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = this._context.getProperty("router.updateProxyPort", 4444);
            try {
                String lastmod;
                EepHead get = new EepHead(this._context, proxyHost, proxyPort, 0, url);
                if (!get.fetch() || (lastmod = get.getLastModified()) == null) break block11;
                if (!(this._context instanceof RouterContext)) {
                    return;
                }
                long modtime = NewsFetcher.parse822Date(lastmod);
                if (modtime <= 0L) {
                    return;
                }
                String lastUpdate = this._context.getProperty("router.updateLastDownloaded");
                if (lastUpdate == null) {
                    ((RouterContext)this._context).router().setConfigSetting("router.updateLastDownloaded", "" + this._context.clock().now());
                    ((RouterContext)this._context).router().saveConfig();
                    return;
                }
                long ms = 0L;
                try {
                    ms = Long.parseLong(lastUpdate);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ms <= 0L) {
                    return;
                }
                if (modtime > ms) {
                    this._unsignedUpdateAvailable = true;
                    this._unsignedUpdateVersion = new SimpleDateFormat("dd-MMM HH:mm").format(new Date(modtime)) + " UTC";
                    if (this.shouldInstall()) {
                        this.fetchUnsigned();
                    }
                }
            }
            catch (Throwable t) {
                this._log.error("Error fetching the unsigned update", t);
            }
        }
    }

    public void fetchUnsigned() {
        String url = this._context.getProperty("router.updateUnsignedURL");
        if (url == null || url.length() <= 0) {
            return;
        }
        UnsignedUpdateHandler handler = new UnsignedUpdateHandler((RouterContext)this._context, url, this._unsignedUpdateVersion);
        ((UpdateHandler)handler).update();
    }

    public static long parse822Date(String s) {
        for (int i = 0; i < rfc822DateFormats.length; ++i) {
            try {
                Date date = rfc822DateFormats[i].parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdates() {
        this._updateAvailable = false;
        if (!this._newsFile.exists() || this._newsFile.length() <= 0L) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._newsFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, buf)) {
                int end;
                int index = buf.indexOf(VERSION_PREFIX);
                if (index != -1 && (end = buf.indexOf("\"", index + VERSION_PREFIX.length())) > index) {
                    String ver = buf.substring(index + VERSION_PREFIX.length(), end);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Found version: [" + ver + "]");
                    }
                    if (TrustedUpdate.needsUpdate("0.7.7", ver)) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Our version is out of date, update!");
                        }
                        this._updateVersion = ver;
                        break;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Our version is current");
                    }
                    return;
                }
                if (buf.indexOf(VERSION_STRING) != -1) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Our version found, no need to update: " + buf.toString());
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("No match in " + buf.toString());
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error checking the news for an update", ioe);
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Our version was NOT found (0.7.7), update needed");
        }
        this._updateAvailable = true;
        if (this.shouldInstall()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Policy requests update, so we update");
            }
            UpdateHandler handler = null;
            if (this._context instanceof RouterContext) {
                handler = new UpdateHandler((RouterContext)this._context);
            } else {
                List contexts = RouterContext.listContexts();
                if (contexts.size() > 0) {
                    handler = new UpdateHandler((RouterContext)contexts.get(0));
                } else {
                    this._log.log(50, "No router context to update with?");
                }
            }
            if (handler != null) {
                handler.update();
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Policy requests manual update, so we do nothing");
        }
    }

    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
    }

    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._log.shouldLog(20)) {
            this._log.info("News fetched from " + url + " with " + (alreadyTransferred + bytesTransferred));
        }
        long now = this._context.clock().now();
        if (this._tempFile.exists()) {
            boolean copied = FileUtil.copy(this._tempFile.getAbsolutePath(), this._newsFile.getAbsolutePath(), true);
            if (copied) {
                this._lastUpdated = now;
                this._tempFile.delete();
                this.checkForUpdates();
            } else if (this._log.shouldLog(40)) {
                this._log.error("Failed to copy the news file!");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Transfer complete, but no file? - probably 304 Not Modified");
        }
        this._lastFetch = now;
    }

    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Failed to fetch the news from " + url);
        }
        this._tempFile.delete();
    }

    public void headerReceived(String url, int attemptNum, String key, String val) {
    }

    public void attempting(String url) {
    }

    static {
        rfc822DateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US)};
    }
}

