/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.router.web.AlphaComparator;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.stat.Rate;

public class GraphHelper
extends HelperBase {
    private int _periodCount = 60;
    private boolean _showEvents = false;
    private int _width = 250;
    private int _height = 100;
    private int _refreshDelaySeconds = 60;

    public void setPeriodCount(String str) {
        try {
            this._periodCount = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShowEvents(boolean b) {
        this._showEvents = b;
    }

    public void setHeight(String str) {
        try {
            this._height = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setWidth(String str) {
        try {
            this._width = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRefreshDelay(String str) {
        try {
            this._refreshDelaySeconds = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getImages() {
        try {
            List listeners = StatSummarizer.instance().getListeners();
            TreeSet ordered = new TreeSet(new AlphaComparator());
            ordered.addAll(listeners);
            boolean hasTx = false;
            boolean hasRx = false;
            for (SummaryListener lsnr : ordered) {
                String title = lsnr.getRate().getRateStat().getName();
                if (title.equals("bw.sendRate")) {
                    hasTx = true;
                    continue;
                }
                if (!title.equals("bw.recvRate")) continue;
                hasRx = true;
            }
            if (hasTx && hasRx && !this._showEvents) {
                this._out.write("<a href=\"viewstat.jsp?stat=bw.combined&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" / target=\"_blank\">");
                this._out.write("<img class=\"statimage\" width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=bw.combined" + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + (this._height - 14) + "\" alt=\"Combined bandwidth graph\" title=\"Combined bandwidth graph\"></a>\n");
            }
            for (SummaryListener lsnr : ordered) {
                Rate r = lsnr.getRate();
                String title = r.getRateStat().getName() + " for " + DataHelper.formatDuration((long)this._periodCount * r.getPeriod());
                this._out.write("<a href=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" target=\"_blank\">");
                this._out.write("<img class=\"statimage\" border=\"0\" width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + this._height + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
            if (this._refreshDelaySeconds > 0) {
                this._out.write("<meta http-equiv=\"refresh\" content=\"" + (this._refreshDelaySeconds - 3) + "\">\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getForm() {
        try {
            this._out.write("<br><h3>Configure Graph Display [<a href=\"configstats.jsp\">Select Stats</a>]</h3>");
            this._out.write("<form action=\"graphs.jsp\" method=\"GET\">");
            this._out.write("Periods: <input size=\"3\" type=\"text\" name=\"periodCount\" value=\"" + this._periodCount + "\"><br>\n");
            this._out.write("Plot averages: <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"false\" " + (this._showEvents ? "" : "checked=\"true\" ") + "> ");
            this._out.write("or plot events: <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"true\" " + (this._showEvents ? "checked=\"true\" " : "") + "><br>\n");
            this._out.write("Image sizes: width: <input size=\"4\" type=\"text\" name=\"width\" value=\"" + this._width + "\"> pixels, height: <input size=\"4\" type=\"text\" name=\"height\" value=\"" + this._height + "\"><br>\n");
            this._out.write("Refresh delay: <select name=\"refreshDelay\"><option value=\"60\">1 minute</option><option value=\"120\">2 minutes</option><option value=\"300\">5 minutes</option><option value=\"600\">10 minutes</option><option value=\"1800\">30 minutes</option><option value=\"3600\">1 hour</option><option value=\"-1\">Never</option></select><br>\n");
            this._out.write("<hr><div class=\"formaction\"><input type=\"submit\" value=\"Redraw\"></div></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getPeerSummary() {
        try {
            this._context.commSystem().renderStatusHTML(this._out);
            this._context.bandwidthLimiter().renderStatusHTML(this._out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }
}

