/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsFetcher;

public class ConfigUpdateHelper
extends HelperBase {
    private static final long[] PERIODS = new long[]{43200000L, 86400000L, 172800000L, -1L};

    public boolean updateAvailable() {
        return true;
    }

    public String getNewsURL() {
        return ConfigUpdateHelper.getNewsURL(this._context);
    }

    public static String getNewsURL(I2PAppContext ctx) {
        String url = ctx.getProperty("router.newsURL");
        if (url != null && !url.equals("http://complication.i2p/news.xml")) {
            return url;
        }
        return "http://echelon.i2p/i2p/news.xml";
    }

    public String getUpdateURL() {
        String url = this._context.getProperty("router.updateURL");
        if (url != null) {
            return url.replaceAll(",", "\n");
        }
        return "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://www.i2p2.i2p/_static/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    }

    public String getProxyHost() {
        return this._context.getProperty("router.updateProxyHost", "127.0.0.1");
    }

    public String getProxyPort() {
        return this._context.getProperty("router.updateProxyPort", "4444");
    }

    public String getUpdateThroughProxy() {
        String proxy = this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY);
        if (Boolean.valueOf(proxy).booleanValue()) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" checked=\"true\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" >";
    }

    public String getUpdateUnsigned() {
        String foo = this._context.getProperty("router.updateUnsigned");
        if (Boolean.valueOf(foo).booleanValue()) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateUnsigned\" checked=\"true\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateUnsigned\" >";
    }

    public String getRefreshFrequencySelectBox() {
        String freq = this._context.getProperty("router.newsRefreshFrequency");
        if (freq == null) {
            freq = "86400000";
        }
        long ms = -1L;
        try {
            ms = Long.parseLong(freq);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"refreshFrequency\">");
        for (int i = 0; i < PERIODS.length; ++i) {
            buf.append("<option value=\"").append(PERIODS[i]);
            if (PERIODS[i] == ms) {
                buf.append("\" selected=\"true\"");
            }
            if (PERIODS[i] == -1L) {
                buf.append("\">Never</option>\n");
                continue;
            }
            buf.append("\">Every ").append(DataHelper.formatDuration(PERIODS[i])).append("</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getUpdatePolicySelectBox() {
        String policy = this._context.getProperty("router.updatePolicy", "download");
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"updatePolicy\">");
        if ("notify".equals(policy)) {
            buf.append("<option value=\"notify\" selected=\"true\">Notify only</option>");
        } else {
            buf.append("<option value=\"notify\">Notify only</option>");
        }
        if ("download".equals(policy)) {
            buf.append("<option value=\"download\" selected=\"true\">Download and verify only</option>");
        } else {
            buf.append("<option value=\"download\">Download and verify only</option>");
        }
        if (System.getProperty("wrapper.version") != null) {
            if ("install".equals(policy)) {
                buf.append("<option value=\"install\" selected=\"true\">Download, verify, and restart</option>");
            } else {
                buf.append("<option value=\"install\">Download, verify, and restart</option>");
            }
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getTrustedKeys() {
        return new TrustedUpdate(this._context).getTrustedKeysString();
    }

    public String getZipURL() {
        return this._context.getProperty("router.updateUnsignedURL", "");
    }

    public String getNewsStatus() {
        return NewsFetcher.getInstance(this._context).status();
    }
}

