/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.NewsFetcher;

public class ConfigUpdateHandler
extends FormHandler {
    private String _newsURL;
    private long _refreshFrequency;
    private String _updateURL;
    private String _updatePolicy;
    private String _proxyHost;
    private String _proxyPort;
    private boolean _updateThroughProxy;
    private String _trustedKeys;
    private boolean _updateUnsigned;
    private String _zipURL;
    public static final String PROP_NEWS_URL = "router.newsURL";
    public static final String OLD_DEFAULT_NEWS_URL = "http://complication.i2p/news.xml";
    public static final String DEFAULT_NEWS_URL = "http://echelon.i2p/i2p/news.xml";
    public static final String PROP_REFRESH_FREQUENCY = "router.newsRefreshFrequency";
    public static final String DEFAULT_REFRESH_FREQUENCY = "86400000";
    public static final String PROP_UPDATE_POLICY = "router.updatePolicy";
    public static final String DEFAULT_UPDATE_POLICY = "download";
    public static final String PROP_SHOULD_PROXY = "router.updateThroughProxy";
    public static final String DEFAULT_SHOULD_PROXY = Boolean.TRUE.toString();
    public static final String PROP_PROXY_HOST = "router.updateProxyHost";
    public static final String DEFAULT_PROXY_HOST = "127.0.0.1";
    public static final String PROP_PROXY_PORT = "router.updateProxyPort";
    public static final int DEFAULT_PROXY_PORT_INT = 4444;
    public static final String DEFAULT_PROXY_PORT = "4444";
    public static final String PROP_UPDATE_UNSIGNED = "router.updateUnsigned";
    public static final String PROP_ZIP_URL = "router.updateUnsignedURL";
    public static final String PROP_UPDATE_URL = "router.updateURL";
    public static final String DEFAULT_UPDATE_URL = "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://www.i2p2.i2p/_static/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    public static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";

    protected void processForm() {
        String oldKeys;
        String oldURL;
        String oldPolicy;
        String oldPort;
        String oldHost;
        String oldURL2;
        if (this._action != null && this._action.startsWith("Check")) {
            NewsFetcher fetcher = NewsFetcher.getInstance(I2PAppContext.getGlobalContext());
            fetcher.fetchNews();
            if (fetcher.shouldFetchUnsigned()) {
                fetcher.fetchUnsignedHead();
            }
            if (fetcher.updateAvailable() || fetcher.unsignedUpdateAvailable()) {
                if (this._updatePolicy == null || !this._updatePolicy.equals("notify")) {
                    this.addFormNotice("Update available, attempting to download now");
                } else {
                    this.addFormNotice("Update available, click button on left to download");
                }
            } else {
                this.addFormNotice("No update available");
            }
        }
        if (!(this._newsURL == null || this._newsURL.length() <= 0 || (oldURL2 = ConfigUpdateHelper.getNewsURL(this._context)) != null && this._newsURL.equals(oldURL2))) {
            this._context.router().setConfigSetting(PROP_NEWS_URL, this._newsURL);
            this.addFormNotice("Updating news URL to " + this._newsURL);
        }
        if (!(this._proxyHost == null || this._proxyHost.length() <= 0 || (oldHost = this._context.router().getConfigSetting(PROP_PROXY_HOST)) != null && this._proxyHost.equals(oldHost))) {
            this._context.router().setConfigSetting(PROP_PROXY_HOST, this._proxyHost);
            this.addFormNotice("Updating proxy host to " + this._proxyHost);
        }
        if (!(this._proxyPort == null || this._proxyPort.length() <= 0 || (oldPort = this._context.router().getConfigSetting(PROP_PROXY_PORT)) != null && this._proxyPort.equals(oldPort))) {
            this._context.router().setConfigSetting(PROP_PROXY_PORT, this._proxyPort);
            this.addFormNotice("Updating proxy port to " + this._proxyPort);
        }
        this._context.router().setConfigSetting(PROP_SHOULD_PROXY, "" + this._updateThroughProxy);
        this._context.router().setConfigSetting(PROP_UPDATE_UNSIGNED, "" + this._updateUnsigned);
        String oldFreqStr = this._context.router().getConfigSetting(PROP_REFRESH_FREQUENCY);
        long oldFreq = -1L;
        if (oldFreqStr != null) {
            try {
                oldFreq = Long.parseLong(oldFreqStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this._refreshFrequency != oldFreq) {
            this._context.router().setConfigSetting(PROP_REFRESH_FREQUENCY, "" + this._refreshFrequency);
            this.addFormNotice("Updating refresh frequency to " + DataHelper.formatDuration(this._refreshFrequency));
        }
        if (!(this._updatePolicy == null || this._updatePolicy.length() <= 0 || (oldPolicy = this._context.router().getConfigSetting(PROP_UPDATE_POLICY)) != null && this._updatePolicy.equals(oldPolicy))) {
            this._context.router().setConfigSetting(PROP_UPDATE_POLICY, this._updatePolicy);
            this.addFormNotice("Updating update policy to " + this._updatePolicy);
        }
        if (this._updateURL != null && this._updateURL.length() > 0) {
            this._updateURL = this._updateURL.replaceAll("\r\n", ",").replaceAll("\n", ",");
            oldURL = this._context.router().getConfigSetting(PROP_UPDATE_URL);
            if (oldURL == null || !this._updateURL.equals(oldURL)) {
                this._context.router().setConfigSetting(PROP_UPDATE_URL, this._updateURL);
                this.addFormNotice("Updating update URLs.");
            }
        }
        if (!(this._trustedKeys == null || this._trustedKeys.length() <= 0 || (oldKeys = new TrustedUpdate(this._context).getTrustedKeysString()) != null && this._trustedKeys.equals(oldKeys))) {
            this._context.router().setConfigSetting(PROP_TRUSTED_KEYS, this._trustedKeys);
            this.addFormNotice("Updating trusted keys.");
        }
        if (!(this._zipURL == null || this._zipURL.length() <= 0 || (oldURL = this._context.router().getConfigSetting(PROP_ZIP_URL)) != null && this._zipURL.equals(oldURL))) {
            this._context.router().setConfigSetting(PROP_ZIP_URL, this._zipURL);
            this.addFormNotice("Updating unsigned update URL to " + this._zipURL);
        }
        this._context.router().saveConfig();
    }

    public void setNewsURL(String url) {
        this._newsURL = url;
    }

    public void setRefreshFrequency(String freq) {
        try {
            this._refreshFrequency = Long.parseLong(freq);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setUpdateURL(String url) {
        this._updateURL = url;
    }

    public void setUpdatePolicy(String policy) {
        this._updatePolicy = policy;
    }

    public void setTrustedKeys(String keys) {
        this._trustedKeys = keys;
    }

    public void setUpdateThroughProxy(String foo) {
        this._updateThroughProxy = true;
    }

    public void setProxyHost(String host) {
        this._proxyHost = host;
    }

    public void setProxyPort(String port) {
        this._proxyPort = port;
    }

    public void setUpdateUnsigned(String foo) {
        this._updateUnsigned = true;
    }

    public void setZipURL(String url) {
        this._zipURL = url;
    }
}

