/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.router.web.HelperBase;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class ConfigStatsHelper
extends HelperBase {
    private Log _log;
    private String _filter;
    private Set _filters;
    private List _stats;
    private String _currentStatName;
    private String _currentGraphName;
    private String _currentStatDescription;
    private String _currentGroup;
    private boolean _currentIsFirstInGroup;
    private boolean _currentIsLogged;
    private boolean _currentIsGraphed;
    private boolean _currentCanBeGraphed;

    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._log = this._context.logManager().getLog(ConfigStatsHelper.class);
        this._stats = new ArrayList();
        Map groups = this._context.statManager().getStatsByGroup();
        for (Set stats : groups.values()) {
            Iterator statIter = stats.iterator();
            while (statIter.hasNext()) {
                this._stats.add(statIter.next());
            }
        }
        this._filter = this._context.statManager().getStatFilter();
        if (this._filter == null) {
            this._filter = "";
        }
        this._filters = new HashSet();
        StringTokenizer tok = new StringTokenizer(this._filter, ",");
        while (tok.hasMoreTokens()) {
            this._filters.add(tok.nextToken().trim());
        }
    }

    public String getFilename() {
        return this._context.statManager().getStatFile();
    }

    public boolean hasMoreStats() {
        if (this._stats.size() <= 0) {
            return false;
        }
        this._currentIsGraphed = false;
        this._currentStatName = (String)this._stats.remove(0);
        RateStat rs = this._context.statManager().getRate(this._currentStatName);
        if (rs != null) {
            this._currentStatDescription = rs.getDescription();
            this._currentIsFirstInGroup = this._currentGroup == null ? true : !rs.getGroupName().equals(this._currentGroup);
            this._currentGroup = rs.getGroupName();
            long period = rs.getPeriods()[0];
            if (period <= 600000L) {
                Rate r = rs.getRate(period);
                boolean bl = this._currentCanBeGraphed = r != null;
                if (this._currentCanBeGraphed) {
                    this._currentIsGraphed = r.getSummaryListener() != null;
                }
                this._currentGraphName = this._currentStatName + "." + period;
            } else {
                this._currentCanBeGraphed = false;
            }
        } else {
            FrequencyStat fs = this._context.statManager().getFrequency(this._currentStatName);
            if (fs != null) {
                this._currentStatDescription = fs.getDescription();
                this._currentIsFirstInGroup = this._currentGroup == null ? true : !fs.getGroupName().equals(this._currentGroup);
                this._currentGroup = fs.getGroupName();
                this._currentCanBeGraphed = false;
            } else {
                if (this._log.shouldLog(40)) {
                    this._log.error("Stat does not exist?!  [" + this._currentStatName + "]");
                }
                return false;
            }
        }
        this._currentIsLogged = this._filters.contains("*") || this._filters.contains(this._currentStatName);
        return true;
    }

    public boolean groupRequired() {
        if (this._currentIsFirstInGroup) {
            this._currentIsFirstInGroup = false;
            return true;
        }
        return false;
    }

    public String getCurrentGroupName() {
        return this._currentGroup;
    }

    public String getCurrentStatName() {
        return this._currentStatName;
    }

    public String getCurrentGraphName() {
        return this._currentGraphName;
    }

    public String getCurrentStatDescription() {
        return this._currentStatDescription;
    }

    public boolean getCurrentIsLogged() {
        return this._currentIsLogged;
    }

    public boolean getCurrentIsGraphed() {
        return this._currentIsGraphed;
    }

    public boolean getCurrentCanBeGraphed() {
        return this._currentCanBeGraphed;
    }

    public String getExplicitFilter() {
        return this._filter;
    }

    public boolean getIsFull() {
        String f = this._context.getProperty("stat.full");
        return f != null && f.equals("true");
    }
}

