/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.List;
import net.i2p.apps.systray.SysTray;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.FormHandler;
import org.tanukisoftware.wrapper.WrapperManager;

public class ConfigServiceHandler
extends FormHandler {
    protected void processForm() {
        block36: {
            if (this._action == null) {
                return;
            }
            if ("Shutdown gracefully".equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(2));
                this._context.router().shutdownGracefully();
                this.addFormNotice("Graceful shutdown initiated");
            } else if ("Shutdown immediately".equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(3));
                this._context.router().shutdown(3);
                this.addFormNotice("Shutdown immediately!  boom bye bye bad bwoy");
            } else if ("Cancel graceful shutdown".equals(this._action)) {
                this._context.router().cancelGracefulShutdown();
                this.addFormNotice("Graceful shutdown cancelled");
            } else if ("Graceful restart".equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(5));
                this._context.router().shutdownGracefully(5);
                this.addFormNotice("Graceful restart requested");
            } else if ("Hard restart".equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(4));
                this._context.router().shutdown(4);
                this.addFormNotice("Hard restart requested");
            } else if ("Rekey and Restart".equals(this._action)) {
                this.addFormNotice("Rekeying after graceful restart");
                this._context.addShutdownTask(new UpdateWrapperManagerAndRekeyTask(5));
                this._context.router().shutdownGracefully(5);
            } else if ("Rekey and Shutdown".equals(this._action)) {
                this.addFormNotice("Rekeying after graceful shutdown");
                this._context.addShutdownTask(new UpdateWrapperManagerAndRekeyTask(2));
                this._context.router().shutdownGracefully(2);
            } else if ("Run I2P on startup".equals(this._action)) {
                this.installService();
            } else if ("Don't run I2P on startup".equals(this._action)) {
                this.uninstallService();
            } else if ("Dump threads".equals(this._action)) {
                try {
                    WrapperManager.requestThreadDump();
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the service manager - " + t.getMessage());
                }
                this.addFormNotice("Threads dumped to wrapper.log");
            } else if ("Show systray icon".equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.show();
                        this.addFormNotice("System tray icon enabled.");
                        break block36;
                    }
                    this.addFormNotice("System tray icon feature not supported on this platform. Sorry!");
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the systray manager - " + t.getMessage());
                }
            } else if ("Hide systray icon".equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.hide();
                        this.addFormNotice("System tray icon disabled.");
                        break block36;
                    }
                    this.addFormNotice("System tray icon feature not supported on this platform. Sorry!");
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the systray manager - " + t.getMessage());
                }
            } else if ("View console on startup".equals(this._action)) {
                this.browseOnStartup(true);
                this.addFormNotice("Console is to be shown on startup");
            } else if ("Do not view console on startup".equals(this._action)) {
                this.browseOnStartup(false);
                this.addFormNotice("Console is not to be shown on startup");
            }
        }
    }

    private void installService() {
        try {
            Runtime.getRuntime().exec("install_i2p_service_winnt.bat");
            this.addFormNotice("Service installed");
        }
        catch (IOException ioe) {
            this.addFormError("Warning: unable to install the service - " + ioe.getMessage());
        }
    }

    private void uninstallService() {
        try {
            Runtime.getRuntime().exec("uninstall_i2p_service_winnt.bat");
            this.addFormNotice("Service removed");
        }
        catch (IOException ioe) {
            this.addFormError("Warning: unable to remove the service - " + ioe.getMessage());
        }
    }

    private void browseOnStartup(boolean shouldLaunchBrowser) {
        List clients = ClientAppConfig.getClientApps(this._context);
        boolean found = false;
        for (int cur = 0; cur < clients.size(); ++cur) {
            ClientAppConfig ca = (ClientAppConfig)clients.get(cur);
            if (!UrlLauncher.class.getName().equals(ca.className)) continue;
            ca.disabled = !shouldLaunchBrowser;
            found = true;
            break;
        }
        if (shouldLaunchBrowser && !found) {
            ClientAppConfig ca = new ClientAppConfig(UrlLauncher.class.getName(), "consoleBrowser", "http://127.0.0.1:7657", 5L, false);
            clients.add(ca);
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
    }

    public static class UpdateWrapperManagerAndRekeyTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerAndRekeyTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                ContextHelper.getContext(null).router().killKeys();
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class UpdateWrapperManagerTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

