/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.StringTokenizer;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ContextHelper;

public class ConfigRestartBean {
    public static String getNonce() {
        RouterContext ctx = ContextHelper.getContext(null);
        String nonce = System.getProperty("console.nonce");
        if (nonce == null) {
            nonce = "" + ctx.random().nextLong();
            System.setProperty("console.nonce", nonce);
        }
        return nonce;
    }

    public static String renderStatus(String urlBase, String action, String nonce) {
        RouterContext ctx = ContextHelper.getContext(null);
        String systemNonce = ConfigRestartBean.getNonce();
        if (nonce != null && systemNonce.equals(nonce) && action != null) {
            if ("shutdownImmediate".equals(action) || "Shutdown immediately".equals(action)) {
                ctx.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(3));
                ctx.router().shutdownGracefully(3);
            } else if ("cancelShutdown".equals(action) || "Cancel shutdown".equals(action)) {
                ctx.router().cancelGracefulShutdown();
            } else if ("restartImmediate".equals(action) || "Restart immediately".equals(action)) {
                ctx.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(4));
                ctx.router().shutdownGracefully(4);
            } else if ("restart".equalsIgnoreCase(action)) {
                ctx.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(5));
                ctx.router().shutdownGracefully(5);
            } else if ("shutdown".equalsIgnoreCase(action)) {
                ctx.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerTask(2));
                ctx.router().shutdownGracefully();
            }
        }
        boolean shuttingDown = ConfigRestartBean.isShuttingDown(ctx);
        boolean restarting = ConfigRestartBean.isRestarting(ctx);
        long timeRemaining = ctx.router().getShutdownTimeRemaining();
        if (shuttingDown) {
            if (timeRemaining <= 0L) {
                return "<center><b>Shutdown imminent</b></center>";
            }
            return "<center><b>Shutdown in " + DataHelper.formatDuration(timeRemaining) + "</b></center><br>" + ConfigRestartBean.buttons(urlBase, systemNonce, "shutdownImmediate,Shutdown immediately,cancelShutdown,Cancel shutdown");
        }
        if (restarting) {
            if (timeRemaining <= 0L) {
                return "<center><b>Restart imminent</b></center>";
            }
            return "<center><b>Restart in " + DataHelper.formatDuration(timeRemaining) + "</b></center><br>" + ConfigRestartBean.buttons(urlBase, systemNonce, "restartImmediate,Restart immediately,cancelShutdown,Cancel restart");
        }
        if (System.getProperty("wrapper.version") != null) {
            return ConfigRestartBean.buttons(urlBase, systemNonce, "restart,Restart,shutdown,Shutdown");
        }
        return ConfigRestartBean.buttons(urlBase, systemNonce, "shutdown,Shutdown");
    }

    private static String buttons(String url, String nonce, String s) {
        StringBuilder buf = new StringBuilder(128);
        StringTokenizer tok = new StringTokenizer(s, ",");
        buf.append("<form action=\"").append(url).append("\" method=\"GET\">\n");
        buf.append("<input type=\"hidden\" name=\"consoleNonce\" value=\"").append(nonce).append("\" >\n");
        while (tok.hasMoreTokens()) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"").append(tok.nextToken()).append("\" >").append(tok.nextToken()).append("</button>\n");
        }
        buf.append("</form>\n");
        return buf.toString();
    }

    private static boolean isShuttingDown(RouterContext ctx) {
        return 2 == ctx.router().scheduledGracefulExitCode() || 3 == ctx.router().scheduledGracefulExitCode();
    }

    private static boolean isRestarting(RouterContext ctx) {
        return 5 == ctx.router().scheduledGracefulExitCode() || 4 == ctx.router().scheduledGracefulExitCode();
    }

    public static long getRestartTimeRemaining() {
        RouterContext ctx = ContextHelper.getContext(null);
        if (ctx.router().gracefulShutdownInProgress()) {
            return ctx.router().getShutdownTimeRemaining();
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }
}

