/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.FormHandler;

public class ConfigNetHandler
extends FormHandler {
    private String _hostname;
    private boolean _reseedRequested;
    private boolean _saveRequested;
    private boolean _recheckReachabilityRequested;
    private boolean _timeSyncEnabled;
    private boolean _requireIntroductions;
    private boolean _hiddenMode;
    private boolean _dynamicKeys;
    private String _ntcpHostname;
    private String _ntcpPort;
    private String _tcpPort;
    private String _udpHost1;
    private String _udpHost2;
    private String _udpPort;
    private String _udpAutoIP;
    private String _ntcpAutoIP;
    private boolean _ntcpAutoPort;
    private boolean _upnp;
    private String _inboundRate;
    private String _inboundBurstRate;
    private String _inboundBurst;
    private String _outboundRate;
    private String _outboundBurstRate;
    private String _outboundBurst;
    private String _reseedFrom;
    private boolean _enableLoadTesting;
    private String _sharePct;
    private static final boolean _ratesOnly = false;
    private static final String PROP_HIDDEN = "router.isHidden";

    protected void processForm() {
        if (this._saveRequested || this._action != null && "Save changes".equals(this._action)) {
            this.saveChanges();
        } else if (this._recheckReachabilityRequested) {
            this.recheckReachability();
        }
    }

    public void setSave(String moo) {
        this._saveRequested = true;
    }

    public void setEnabletimesync(String moo) {
        this._timeSyncEnabled = true;
    }

    public void setRecheckReachability(String moo) {
        this._recheckReachabilityRequested = true;
    }

    public void setRequireIntroductions(String moo) {
        this._requireIntroductions = true;
    }

    public void setDynamicKeys(String moo) {
        this._dynamicKeys = true;
    }

    public void setEnableloadtesting(String moo) {
        this._enableLoadTesting = true;
    }

    public void setUdpAutoIP(String mode) {
        this._udpAutoIP = mode;
        this._hiddenMode = "hidden".equals(mode);
    }

    public void setNtcpAutoIP(String mode) {
        this._ntcpAutoIP = mode;
    }

    public void setNtcpAutoPort(String mode) {
        this._ntcpAutoPort = mode.equals("2");
    }

    public void setUpnp(String moo) {
        this._upnp = true;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname != null ? hostname.trim() : null;
    }

    public void setTcpPort(String port) {
        this._tcpPort = port != null ? port.trim() : null;
    }

    public void setNtcphost(String host) {
        this._ntcpHostname = host != null ? host.trim() : null;
    }

    public void setNtcpport(String port) {
        this._ntcpPort = port != null ? port.trim() : null;
    }

    public void setUdpHost1(String host) {
        this._udpHost1 = host != null ? host.trim() : null;
    }

    public void setUdpHost2(String host) {
        this._udpHost2 = host != null ? host.trim() : null;
    }

    public void setUdpPort(String port) {
        this._udpPort = port != null ? port.trim() : null;
    }

    public void setInboundrate(String rate) {
        this._inboundRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstrate(String rate) {
        this._inboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstfactor(String factor) {
        this._inboundBurst = factor != null ? factor.trim() : null;
    }

    public void setOutboundrate(String rate) {
        this._outboundRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstrate(String rate) {
        this._outboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstfactor(String factor) {
        this._outboundBurst = factor != null ? factor.trim() : null;
    }

    public void setSharePercentage(String pct) {
        this._sharePct = pct != null ? pct.trim() : null;
    }

    private void recheckReachability() {
        this._context.commSystem().recheckReachability();
        this.addFormNotice("Rechecking router reachability...");
    }

    private void saveChanges() {
        String oldPort;
        boolean restartRequired = false;
        String oldUdp = this._context.getProperty("i2np.udp.addressSources", "local,upnp,ssu");
        String oldUHost = this._context.getProperty("i2np.udp.host", "");
        if (this._udpAutoIP != null) {
            String uhost = "";
            if (this._udpAutoIP.equals("fixed")) {
                if (this._udpHost1 != null && this._udpHost1.length() > 0) {
                    uhost = this._udpHost1;
                } else if (this._udpHost2 != null && this._udpHost2.length() > 0) {
                    uhost = this._udpHost2;
                } else {
                    this._udpAutoIP = "local,upnp,ssu";
                }
            }
            this._context.router().setConfigSetting("i2np.udp.addressSources", this._udpAutoIP);
            this._context.router().setConfigSetting("i2np.udp.host", uhost);
            if (!oldUdp.equals(this._udpAutoIP) || !oldUHost.equals(uhost)) {
                this.addFormNotice("Updating IP address");
                restartRequired = true;
            }
        }
        String oldNHost = this._context.getProperty("i2np.ntcp.hostname", "");
        String oldNPort = this._context.getProperty("i2np.ntcp.port", "");
        String oldAutoHost = this._context.getProperty("i2np.ntcp.autoip", "true");
        String sAutoPort = this._context.getProperty("i2np.ntcp.autoport", "true");
        boolean oldAutoPort = "true".equalsIgnoreCase(sAutoPort);
        if (this._ntcpHostname == null) {
            this._ntcpHostname = "";
        }
        if (this._ntcpPort == null) {
            this._ntcpPort = "";
        }
        if (this._ntcpAutoIP == null) {
            this._ntcpAutoIP = "true";
        }
        if (!oldAutoHost.equals(this._ntcpAutoIP) || !oldNHost.equalsIgnoreCase(this._ntcpHostname)) {
            if ("disabled".equals(this._ntcpAutoIP)) {
                this.addFormNotice("Disabling TCP completely");
            } else if ("false".equals(this._ntcpAutoIP) && this._ntcpHostname.length() > 0) {
                this._context.router().setConfigSetting("i2np.ntcp.hostname", this._ntcpHostname);
                this.addFormNotice("Updating inbound TCP address to " + this._ntcpHostname);
            } else {
                this._context.router().removeConfigSetting("i2np.ntcp.hostname");
                if ("false".equals(this._ntcpAutoIP)) {
                    this.addFormNotice("Disabling inbound TCP");
                } else {
                    this.addFormNotice("Updating inbound TCP address to auto");
                }
            }
            this._context.router().setConfigSetting("i2np.ntcp.autoip", this._ntcpAutoIP);
            this._context.router().setConfigSetting("i2np.ntcp.enable", "" + !"disabled".equals(this._ntcpAutoIP));
            restartRequired = true;
        }
        if (oldAutoPort != this._ntcpAutoPort || !oldNPort.equals(this._ntcpPort)) {
            if (this._ntcpPort.length() > 0 && !this._ntcpAutoPort) {
                this._context.router().setConfigSetting("i2np.ntcp.port", this._ntcpPort);
                this.addFormNotice("Updating inbound TCP port to " + this._ntcpPort);
            } else {
                this._context.router().removeConfigSetting("i2np.ntcp.port");
                this.addFormNotice("Updating inbound TCP port to auto");
            }
            this._context.router().setConfigSetting("i2np.ntcp.autoport", "" + this._ntcpAutoPort);
            restartRequired = true;
        }
        if (this._udpPort != null && this._udpPort.length() > 0 && !(oldPort = "" + this._context.getProperty("i2np.udp.internalPort", 8887)).equals(this._udpPort)) {
            this._context.router().setConfigSetting("i2np.udp.internalPort", this._udpPort);
            this._context.router().setConfigSetting("i2np.udp.port", this._udpPort);
            this.addFormNotice("Updating UDP port from " + oldPort + " to " + this._udpPort);
            restartRequired = true;
        }
        this.updateRates();
        boolean switchRequired = false;
        boolean bl = switchRequired = this._hiddenMode != this._context.router().isHidden();
        if (switchRequired) {
            this._context.router().setConfigSetting(PROP_HIDDEN, "" + this._hiddenMode);
            if (this._hiddenMode) {
                this.addFormError("Gracefully restarting into Hidden Router Mode");
            } else {
                this.addFormError("Gracefully restarting to exit Hidden Router Mode");
            }
        }
        this._context.router().setConfigSetting("router.dynamicKeys", "" + this._dynamicKeys);
        if (Boolean.valueOf(this._context.getProperty("i2np.upnp.enable")) != this._upnp) {
            if (this._upnp) {
                this.addFormNotice("Enabling UPnP, restart required to take effect");
            } else {
                this.addFormNotice("Disabling UPnP, restart required to take effect");
            }
        }
        this._context.router().setConfigSetting("i2np.upnp.enable", "" + this._upnp);
        if (this._requireIntroductions) {
            this._context.router().setConfigSetting("i2np.udp.forceIntroducers", "true");
            this.addFormNotice("Requiring SSU introduers");
        } else {
            this._context.router().removeConfigSetting("i2np.udp.forceIntroducers");
        }
        boolean saved = this._context.router().saveConfig();
        if (this._action != null && "Save changes".equals(this._action)) {
            if (saved) {
                this.addFormNotice("Configuration saved successfully");
            } else {
                this.addFormNotice("Error saving the configuration (applied but not saved) - please see the error logs");
            }
        }
        if (switchRequired) {
            this.hiddenSwitch();
        } else if (restartRequired) {
            this.addFormError("Gracefully restarting I2P to change published router address");
            this._context.router().shutdownGracefully(5);
        }
    }

    private void hiddenSwitch() {
        this._context.addShutdownTask(new ConfigServiceHandler.UpdateWrapperManagerAndRekeyTask(5));
        this._context.router().shutdownGracefully(5);
    }

    private void updateRates() {
        String old;
        boolean updated = false;
        if (!(this._sharePct == null || (old = this._context.router().getConfigSetting("router.sharePercentage")) != null && old.equalsIgnoreCase(this._sharePct))) {
            this._context.router().setConfigSetting("router.sharePercentage", this._sharePct);
            this.addFormNotice("Updating bandwidth share percentage");
            updated = true;
        }
        if (this._inboundRate != null && this._inboundRate.length() > 0 && !this._inboundRate.equals(this._context.getProperty("i2np.bandwidth.inboundKBytesPerSecond", "96"))) {
            this._context.router().setConfigSetting("i2np.bandwidth.inboundKBytesPerSecond", this._inboundRate);
            updated = true;
        }
        if (this._outboundRate != null && this._outboundRate.length() > 0 && !this._outboundRate.equals(this._context.getProperty("i2np.bandwidth.outboundKBytesPerSecond", "40"))) {
            this._context.router().setConfigSetting("i2np.bandwidth.outboundKBytesPerSecond", this._outboundRate);
            updated = true;
        }
        if (updated) {
            this._context.bandwidthLimiter().reinitialize();
            this.addFormNotice("Updated bandwidth limits");
        }
    }
}

