/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import net.i2p.router.web.FormHandler;

public class ConfigLoggingHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _levels;
    private String _defaultLevel;
    private String _filename;
    private String _recordFormat;
    private String _dateFormat;
    private String _fileSize;

    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setLevels(String levels) {
        this._levels = levels != null ? levels.trim() : null;
    }

    public void setDefaultloglevel(String level) {
        this._defaultLevel = level != null ? level.trim() : null;
    }

    public void setLogfilename(String filename) {
        this._filename = filename != null ? filename.trim() : null;
    }

    public void setLogformat(String format) {
        this._recordFormat = format != null ? format.trim() : null;
    }

    public void setLogdateformat(String format) {
        this._dateFormat = format != null ? format.trim() : null;
    }

    public void setLogfilesize(String size) {
        this._fileSize = size != null ? size.trim() : null;
    }

    private void saveChanges() {
        String oldDefault;
        boolean shouldSave = false;
        if (this._levels != null) {
            try {
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(this._levels.getBytes()));
                this._context.logManager().setLimits(props);
                shouldSave = true;
                this.addFormNotice("Log limits updated");
            }
            catch (IOException ioe) {
                this._context.logManager().getLog(ConfigLoggingHandler.class).error("Error reading from the props?", ioe);
                this.addFormError("Error updating the log limits - levels not valid");
            }
        } else {
            this._context.logManager().setLimits(null);
            this.addFormNotice("Log limits cleared");
        }
        if (this._defaultLevel != null && !this._defaultLevel.equals(oldDefault = this._context.logManager().getDefaultLimit())) {
            shouldSave = true;
            this._context.logManager().setDefaultLimit(this._defaultLevel);
            this.addFormNotice("Default log level updated from " + oldDefault + " to " + this._defaultLevel);
        }
        if (this._dateFormat != null) {
            boolean valid = this._context.logManager().setDateFormat(this._dateFormat);
            if (valid) {
                shouldSave = true;
                this.addFormNotice("Date format updated");
            } else {
                this.addFormError("Specified date format is not valid (" + this._dateFormat + ") - not updated");
            }
        }
        if (this._fileSize != null) {
            int newBytes = this._context.logManager().getFileSize(this._fileSize);
            int oldBytes = this._context.logManager().getFileSize();
            if (newBytes > 0) {
                if (oldBytes != newBytes) {
                    this._context.logManager().setFileSize(newBytes);
                    shouldSave = true;
                    this.addFormNotice("File size updated");
                }
            } else {
                this.addFormError("Specified file size limit is not valid (" + this._fileSize + ") - not updated");
            }
        }
        if (this._filename != null && this._filename.trim().length() > 0) {
            this._filename = this._filename.trim();
            String old = this._context.logManager().getBaseLogfilename();
            if (old == null || !this._filename.equals(old)) {
                shouldSave = true;
                this._context.logManager().setBaseLogfilename(this._filename);
                this.addFormNotice("Log file name pattern updated to " + this._filename + " (note: will not take effect until next rotation)");
            }
        }
        if (this._recordFormat != null && this._recordFormat.trim().length() > 0) {
            this._recordFormat = this._recordFormat.trim();
            String old = new String(this._context.logManager().getFormat());
            if (!this._recordFormat.equalsIgnoreCase(old)) {
                char[] fmt = new char[this._recordFormat.length()];
                for (int i = 0; i < fmt.length; ++i) {
                    fmt[i] = this._recordFormat.charAt(i);
                }
                this._context.logManager().setFormat(fmt);
                shouldSave = true;
                this.addFormNotice("Log record format updated");
            }
        }
        if (shouldSave) {
            boolean saved = this._context.logManager().saveConfig();
            if (saved) {
                this.addFormNotice("Log configuration saved and applied successfully");
            } else {
                this.addFormNotice("Error saving the configuration (applied but not saved) - please see the error logs");
            }
        }
    }
}

