/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class I2PSocketEepGet
extends EepGet {
    private I2PSocketManager _socketManager;
    private I2PSocket _socket;

    public I2PSocketEepGet(I2PAppContext ctx, I2PSocketManager mgr, int numRetries, String outputFile, String url) {
        this(ctx, mgr, numRetries, -1L, -1L, outputFile, null, url);
    }

    public I2PSocketEepGet(I2PAppContext ctx, I2PSocketManager mgr, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url) {
        super(ctx, false, null, -1, numRetries, minSize, maxSize, outputFile, outputStream, url, true, null, null);
        this._socketManager = mgr;
        this._log = ctx.logManager().getLog(I2PSocketEepGet.class);
    }

    public boolean fetch(long fetchHeaderTimeout, long totalTimeout, long inactivityTimeout) {
        boolean rv = super.fetch(fetchHeaderTimeout, totalTimeout, inactivityTimeout);
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return rv;
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile;
        if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile.length();
        }
        if (this._proxyIn != null) {
            try {
                this._proxyIn.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._proxyOut != null) {
            try {
                this._proxyOut.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            Destination dest;
            URL url = new URL(this._actualURL);
            if ("http".equals(url.getProtocol())) {
                String host = url.getHost();
                int port = url.getPort();
                if (port != -1) {
                    throw new IOException("Ports not supported in i2p: " + this._actualURL);
                }
                if ("i2p".equals(host)) {
                    String file = url.getFile();
                    try {
                        int slash = 1 + file.substring(1).indexOf("/");
                        host = file.substring(1, slash);
                        this._actualURL = "http://" + host + file.substring(slash);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        throw new IOException("Bad /i2p/ format: " + this._actualURL);
                    }
                }
                if ((dest = this._context.namingService().lookup(host)) == null) {
                    throw new UnknownHostException("Unknown or non-i2p host");
                }
            } else {
                throw new IOException("Unsupported protocol: " + this._actualURL);
            }
            Properties props = new Properties();
            props.setProperty("i2p.streaming.connectTimeout", "45000");
            props.setProperty("i2p.streaming.readTimeout", "60000");
            I2PSocketOptions opts = this._socketManager.buildOptions(props);
            this._socket = this._socketManager.connect(dest, opts);
        }
        catch (MalformedURLException mue) {
            throw new IOException("Request URL is invalid: " + this._actualURL);
        }
        catch (I2PException ie) {
            throw new IOException(ie.toString());
        }
        this._proxyIn = this._socket.getInputStream();
        this._proxyOut = this._socket.getOutputStream();
        String req = this.getRequest();
        this._proxyOut.write(DataHelper.getUTF8((String)req));
        this._proxyOut.flush();
    }

    protected String getRequest() throws IOException {
        StringBuilder buf = new StringBuilder(2048);
        URL url = new URL(this._actualURL);
        String host = url.getHost();
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            path = path + '?' + query;
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        buf.append("GET ").append(path).append(" HTTP/1.1\r\nHost: ").append(url.getHost()).append("\r\n");
        if (this._alreadyTransferred > 0L) {
            buf.append("Range: bytes=");
            buf.append(this._alreadyTransferred);
            buf.append("-\r\n");
        }
        buf.append("Accept-Encoding: \r\nCache-control: no-cache\r\nPragma: no-cache\r\nUser-Agent: Wget/1.11.4\r\nConnection: close\r\n\r\n");
        return buf.toString();
    }

    public static void main(String[] args) {
        I2PSocketEepGet get;
        int numRetries = 0;
        long inactivityTimeout = 60000L;
        String url = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-n")) {
                    numRetries = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    inactivityTimeout = 1000 * Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    I2PSocketEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            I2PSocketEepGet.usage();
            return;
        }
        if (url == null) {
            I2PSocketEepGet.usage();
            return;
        }
        Properties opts = new Properties();
        opts.setProperty("i2cp.dontPublishLeaseSet", "true");
        opts.setProperty("inbound.quantity", "1");
        opts.setProperty("outbound.quantity", "1");
        opts.setProperty("inbound.length", "1");
        opts.setProperty("outbound.length", "1");
        opts.setProperty("inbound.nickname", "I2PSocketEepGet");
        I2PSocketManager mgr = I2PSocketManagerFactory.createManager(opts);
        if (mgr == null) {
            System.err.println("Error creating the socket manager");
            return;
        }
        I2PSocketEepGet i2PSocketEepGet = get = new I2PSocketEepGet(I2PAppContext.getGlobalContext(), mgr, numRetries, I2PSocketEepGet.suggestName((String)url), url);
        ((Object)((Object)i2PSocketEepGet)).getClass();
        get.addStatusListener((EepGet.StatusListener)new EepGet.CLIStatusListener((EepGet)i2PSocketEepGet, 1024, 40));
        get.fetch(inactivityTimeout, -1L, inactivityTimeout);
        mgr.destroySocketManager();
    }

    private static void usage() {
        System.err.println("I2PSocketEepGet [-n #retries] [-t timeout] url");
    }
}

