/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class ConnectInactivityTest {
    private Log _log;
    private I2PSession _client;
    private I2PSession _server;
    static /* synthetic */ Class class$net$i2p$client$streaming$ConnectTest;
    static /* synthetic */ Class class$net$i2p$client$streaming$ConnectInactivityTest$ServerRunner;
    static /* synthetic */ Class class$net$i2p$client$streaming$ConnectInactivityTest$ClientRunner;

    public void test() {
        try {
            I2PAppContext context = I2PAppContext.getGlobalContext();
            this._log = context.logManager().getLog(class$net$i2p$client$streaming$ConnectTest == null ? (class$net$i2p$client$streaming$ConnectTest = ConnectInactivityTest.class$("net.i2p.client.streaming.ConnectTest")) : class$net$i2p$client$streaming$ConnectTest);
            this._log.debug("creating server session");
            this._server = this.createSession();
            this._log.debug("running server");
            this.runServer(context, this._server);
            this._log.debug("creating client session");
            this._client = this.createSession();
            this._log.debug("running client");
            this.runClient(context, this._client);
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
        }
    }

    private void runClient(I2PAppContext ctx, I2PSession session) {
        Thread t = new Thread(new ClientRunner(ctx, session));
        t.setName("client");
        t.setDaemon(false);
        t.start();
    }

    private void runServer(I2PAppContext ctx, I2PSession session) {
        Thread t = new Thread(new ServerRunner(ctx, session));
        t.setName("server");
        t.setDaemon(false);
        t.start();
    }

    private I2PSession createSession() {
        try {
            I2PClient client = I2PClientFactory.createClient();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            Destination dest = client.createDestination((OutputStream)baos);
            Properties p = new Properties();
            p.setProperty("i2cp.tcp.host", "localhost");
            p.setProperty("i2cp.tcp.port", "10001");
            I2PSession sess = client.createSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), p);
            sess.connect();
            return sess;
        }
        catch (Exception e) {
            this._log.error("error running", (Throwable)e);
            throw new RuntimeException("b0rk b0rk b0rk");
        }
    }

    public static void main(String[] args) {
        ConnectInactivityTest ct = new ConnectInactivityTest();
        ct.test();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClientRunner
    implements Runnable {
        private I2PAppContext _context;
        private I2PSession _session;
        private Log _log;

        public ClientRunner(I2PAppContext ctx, I2PSession session) {
            this._context = ctx;
            this._session = session;
            this._log = ctx.logManager().getLog(class$net$i2p$client$streaming$ConnectInactivityTest$ClientRunner == null ? (class$net$i2p$client$streaming$ConnectInactivityTest$ClientRunner = ConnectInactivityTest.class$("net.i2p.client.streaming.ConnectInactivityTest$ClientRunner")) : class$net$i2p$client$streaming$ConnectInactivityTest$ClientRunner);
        }

        public void run() {
            try {
                Properties opts = new Properties();
                I2PSocketManagerFull mgr = new I2PSocketManagerFull(this._context, this._session, opts, "client");
                this._log.debug("manager created");
                I2PSocket socket = mgr.connect(ConnectInactivityTest.this._server.getMyDestination());
                this._log.debug("socket created");
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                socket.close();
                this._log.debug("socket closed");
            }
            catch (Exception e) {
                this._log.error("error running", (Throwable)e);
            }
        }
    }

    private class ServerRunner
    implements Runnable {
        private I2PAppContext _context;
        private I2PSession _session;
        private Log _log;

        public ServerRunner(I2PAppContext ctx, I2PSession session) {
            this._context = ctx;
            this._session = session;
            this._log = ctx.logManager().getLog(class$net$i2p$client$streaming$ConnectInactivityTest$ServerRunner == null ? (class$net$i2p$client$streaming$ConnectInactivityTest$ServerRunner = ConnectInactivityTest.class$("net.i2p.client.streaming.ConnectInactivityTest$ServerRunner")) : class$net$i2p$client$streaming$ConnectInactivityTest$ServerRunner);
        }

        public void run() {
            try {
                Properties opts = new Properties();
                I2PSocketManagerFull mgr = new I2PSocketManagerFull(this._context, this._session, opts, "client");
                this._log.debug("manager created");
                I2PServerSocket ssocket = mgr.getServerSocket();
                this._log.debug("server socket created");
                I2PSocket socket = ssocket.accept();
                this._log.debug("socket accepted: " + socket);
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                socket.close();
                ssocket.close();
                this._session.destroySession();
            }
            catch (Exception e) {
                this._log.error("error running", (Throwable)e);
            }
        }
    }
}

