/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.sam.client.SAMEventHandler;
import net.i2p.sam.client.SAMReader;
import net.i2p.util.Log;

public class SAMStreamSink {
    private I2PAppContext _context;
    private Log _log;
    private String _samHost;
    private String _samPort;
    private String _destFile;
    private String _sinkDir;
    private String _conOptions;
    private Socket _samSocket;
    private OutputStream _samOut;
    private InputStream _samIn;
    private SAMReader _reader;
    private SAMEventHandler _eventHandler;
    private Map<Integer, Sink> _remotePeers;

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: SAMStreamSink samHost samPort myDestFile sinkDir");
            return;
        }
        I2PAppContext ctx = new I2PAppContext();
        SAMStreamSink sink = new SAMStreamSink(ctx, args[0], args[1], args[2], args[3]);
        sink.startup();
    }

    public SAMStreamSink(I2PAppContext ctx, String samHost, String samPort, String destFile, String sinkDir) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(SAMStreamSink.class);
        this._samHost = samHost;
        this._samPort = samPort;
        this._destFile = destFile;
        this._sinkDir = sinkDir;
        this._conOptions = "";
        this._eventHandler = new SinkEventHandler(this._context);
        this._remotePeers = new HashMap<Integer, Sink>();
    }

    public void startup() {
        this._log.debug("Starting up");
        boolean ok = this.connect();
        this._log.debug("Connected: " + ok);
        if (ok) {
            this._reader = new SAMReader(this._context, this._samIn, this._eventHandler);
            this._reader.startReading();
            this._log.debug("Reader created");
            String ourDest = this.handshake();
            this._log.debug("Handshake complete.  we are " + ourDest);
            if (ourDest != null) {
                this.writeDest(ourDest);
                this._log.debug("Dest written");
            }
        }
    }

    private boolean connect() {
        try {
            this._samSocket = new Socket(this._samHost, Integer.parseInt(this._samPort));
            this._samOut = this._samSocket.getOutputStream();
            this._samIn = this._samSocket.getInputStream();
            return true;
        }
        catch (Exception e) {
            this._log.error("Unable to connect to SAM at " + this._samHost + ":" + this._samPort, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handshake() {
        OutputStream outputStream = this._samOut;
        synchronized (outputStream) {
            try {
                this._samOut.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
                this._samOut.flush();
                this._log.debug("Hello sent");
                boolean ok = this._eventHandler.waitForHelloReply();
                this._log.debug("Hello reply found: " + ok);
                if (!ok) {
                    throw new IOException("wtf, hello failed?");
                }
                String req = "SESSION CREATE STYLE=STREAM DESTINATION=" + this._destFile + " " + this._conOptions + "\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Session create sent");
                ok = this._eventHandler.waitForSessionCreateReply();
                this._log.debug("Session create reply found: " + ok);
                req = "NAMING LOOKUP NAME=ME\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Naming lookup sent");
                String destination = this._eventHandler.waitForNamingReply("ME");
                this._log.debug("Naming lookup reply found: " + destination);
                if (destination == null) {
                    this._log.error("No naming lookup reply found!");
                    return null;
                }
                this._log.info(this._destFile + " is located at " + destination);
                return destination;
            }
            catch (Exception e) {
                this._log.error("Error handshaking", e);
                return null;
            }
        }
    }

    private boolean writeDest(String dest) {
        try {
            FileOutputStream fos = new FileOutputStream(this._destFile);
            fos.write(dest.getBytes());
            fos.close();
            return true;
        }
        catch (Exception e) {
            this._log.error("Error writing to " + this._destFile, e);
            return false;
        }
    }

    private class Sink {
        private int _connectionId;
        private String _remoteDestination;
        private boolean _closed;
        private long _started;
        private long _totalReceived;
        private long _lastReceivedOn;
        private OutputStream _out;

        public Sink(int conId, String remDest) throws IOException {
            this._connectionId = conId;
            this._remoteDestination = remDest;
            this._closed = false;
            this._lastReceivedOn = SAMStreamSink.this._context.clock().now();
            SAMStreamSink.this._context.statManager().createRateStat("sink." + conId + ".totalReceived", "Data size received", "swarm", new long[]{30000L, 60000L, 300000L});
            SAMStreamSink.this._context.statManager().createRateStat("sink." + conId + ".started", "When we start", "swarm", new long[]{300000L});
            SAMStreamSink.this._context.statManager().createRateStat("sink." + conId + ".lifetime", "How long we talk to a peer", "swarm", new long[]{300000L});
            File sinkDir = new File(SAMStreamSink.this._sinkDir);
            if (!sinkDir.exists()) {
                sinkDir.mkdirs();
            }
            File out = File.createTempFile("sink", ".dat", sinkDir);
            this._out = new FileOutputStream(out);
        }

        public int getConnectionId() {
            return this._connectionId;
        }

        public String getDestination() {
            return this._remoteDestination;
        }

        public void closed() {
            if (this._closed) {
                return;
            }
            this._closed = true;
            long lifetime = SAMStreamSink.this._context.clock().now() - this._started;
            SAMStreamSink.this._context.statManager().addRateData("sink." + this._connectionId + ".lifetime", lifetime, lifetime);
            try {
                this._out.close();
            }
            catch (IOException ioe) {
                SAMStreamSink.this._log.error("Error closing", ioe);
            }
        }

        public void received(byte[] data, int offset, int len) {
            if (this._closed) {
                return;
            }
            this._totalReceived += (long)len;
            try {
                this._out.write(data, offset, len);
            }
            catch (IOException ioe) {
                SAMStreamSink.this._log.error("Error writing received data");
                this.closed();
                return;
            }
            SAMStreamSink.this._log.debug("Received " + len + " on " + this._connectionId + " after " + (SAMStreamSink.this._context.clock().now() - this._lastReceivedOn) + "ms with " + this._remoteDestination.substring(0, 6));
            this._lastReceivedOn = SAMStreamSink.this._context.clock().now();
        }
    }

    private class SinkEventHandler
    extends SAMEventHandler {
        public SinkEventHandler(I2PAppContext ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamClosedReceived(String result, int id, String message) {
            Sink sink = null;
            Map map = SAMStreamSink.this._remotePeers;
            synchronized (map) {
                sink = (Sink)SAMStreamSink.this._remotePeers.remove(new Integer(id));
            }
            if (sink != null) {
                sink.closed();
                SAMStreamSink.this._log.debug("Connection " + sink.getConnectionId() + " closed to " + sink.getDestination());
            } else {
                SAMStreamSink.this._log.error("wtf, not connected to " + id + " but we were just closed?");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamDataReceived(int id, byte[] data, int offset, int length) {
            Sink sink = null;
            Map map = SAMStreamSink.this._remotePeers;
            synchronized (map) {
                sink = (Sink)SAMStreamSink.this._remotePeers.get(new Integer(id));
            }
            if (sink != null) {
                sink.received(data, offset, length);
            } else {
                SAMStreamSink.this._log.error("wtf, not connected to " + id + " but we received " + length + "?");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamConnectedReceived(String dest, int id) {
            SAMStreamSink.this._log.debug("Connection " + id + " received from " + dest);
            try {
                Sink sink = new Sink(id, dest);
                Map map = SAMStreamSink.this._remotePeers;
                synchronized (map) {
                    SAMStreamSink.this._remotePeers.put(new Integer(id), sink);
                }
            }
            catch (IOException ioe) {
                SAMStreamSink.this._log.error("Error creating a new sink", ioe);
            }
        }
    }
}

