/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv3Handler;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMv3StreamSession
extends SAMStreamSession
implements SAMv3Handler.Session {
    private static final Log _log = new Log(SAMv3StreamSession.class);
    protected final int BUFFER_SIZE = 1024;
    protected Object socketServerLock = new Object();
    protected I2PServerSocket socketServer = null;
    protected String nick;

    public String getNick() {
        return this.nick;
    }

    public SAMv3StreamSession(String login) throws IOException, DataFormatException, SAMException {
        this.initSAMStreamSession(login);
    }

    public static SAMv3Handler.SessionsDB getDB() {
        return SAMv3Handler.sSessionsHash;
    }

    private void initSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        int i2cpPort;
        SAMv3Handler.SessionRecord rec = SAMv3StreamSession.getDB().get(login);
        String dest = rec.getDest();
        ByteArrayInputStream ba_dest = new ByteArrayInputStream(Base64.decode(dest));
        this.recv = rec.getHandler();
        _log.debug("SAM STREAM session instantiated");
        Properties allprops = new Properties();
        allprops.putAll((Map<?, ?>)System.getProperties());
        allprops.putAll((Map<?, ?>)rec.getProps());
        String i2cpHost = allprops.getProperty("i2cp.tcp.host", "127.0.0.1");
        String port = allprops.getProperty("i2cp.tcp.port", "7654");
        try {
            i2cpPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new SAMException("Invalid I2CP port specified [" + port + "]");
        }
        _log.debug("Creating I2PSocketManager...");
        this.socketMgr = I2PSocketManagerFactory.createManager(ba_dest, i2cpHost, i2cpPort, allprops);
        if (this.socketMgr == null) {
            throw new SAMException("Error creating I2PSocketManager towards " + i2cpHost + ":" + i2cpPort);
        }
        this.socketMgr.addDisconnectListener(new SAMStreamSession.DisconnectListener());
        this.nick = login;
    }

    public void connect(SAMv3Handler handler, String dest, Properties props) throws I2PException, ConnectException, NoRouteToHostException, DataFormatException, InterruptedIOException, IOException {
        boolean verbose = props.getProperty("SILENT", "false").equals("false");
        Destination d = SAMUtils.getDest(dest);
        I2PSocketOptions opts = this.socketMgr.buildOptions(props);
        if (props.getProperty("i2p.streaming.connectTimeout") == null) {
            opts.setConnectTimeout(60000L);
        }
        _log.debug("Connecting new I2PSocket...");
        I2PSocket i2ps = this.socketMgr.connect(d, opts);
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null) {
            throw new InterruptedIOException();
        }
        handler.notifyStreamResult(verbose, "OK", null);
        handler.stealSocket();
        SocketChannel fromClient = handler.getClientSocket();
        ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
        SocketChannel toClient = handler.getClientSocket();
        WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
        new Thread(rec.getThreadGroup(), new I2PAppThread(new Pipe(fromClient, toI2P, "SAMPipeClientToI2P"), "SAMPipeClientToI2P"), "SAMPipeClientToI2P").start();
        new Thread(rec.getThreadGroup(), new I2PAppThread(new Pipe(fromI2P, toClient, "SAMPipeI2PToClient"), "SAMPipeI2PToClient"), "SAMPipeI2PToClient").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SAMv3Handler handler, boolean verbose) throws I2PException, InterruptedIOException, IOException, SAMException {
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer != null) {
                _log.debug("a socket server is already defined for this destination");
                throw new SAMException("a socket server is already defined for this destination");
            }
            this.socketServer = this.socketMgr.getServerSocket();
        }
        I2PSocket i2ps = this.socketServer.accept();
        Object object2 = this.socketServerLock;
        synchronized (object2) {
            this.socketServer = null;
        }
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null || i2ps == null) {
            throw new InterruptedIOException();
        }
        if (verbose) {
            handler.notifyStreamIncomingConnection(i2ps.getPeerDestination());
        }
        handler.stealSocket();
        SocketChannel fromClient = handler.getClientSocket();
        ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
        SocketChannel toClient = handler.getClientSocket();
        WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
        new Thread(rec.getThreadGroup(), new I2PAppThread(new Pipe(fromClient, toI2P, "SAMPipeClientToI2P"), "SAMPipeClientToI2P"), "SAMPipeClientToI2P").start();
        new Thread(rec.getThreadGroup(), new I2PAppThread(new Pipe(fromI2P, toClient, "SAMPipeI2PToClient"), "SAMPipeI2PToClient"), "SAMPipeI2PToClient").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startForwardingIncoming(Properties props) throws SAMException, InterruptedIOException {
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        boolean verbose = props.getProperty("SILENT", "false").equals("false");
        if (rec == null) {
            throw new InterruptedIOException();
        }
        String portStr = props.getProperty("PORT");
        if (portStr == null) {
            _log.debug("receiver port not specified");
            throw new SAMException("receiver port not specified");
        }
        int port = Integer.parseInt(portStr);
        String host = props.getProperty("HOST");
        if (host == null) {
            host = rec.getHandler().getClientIP();
            _log.debug("no host specified. Taken from the client socket : " + host + ':' + port);
        }
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer != null) {
                _log.debug("a socket server is already defined for this destination");
                throw new SAMException("a socket server is already defined for this destination");
            }
            this.socketServer = this.socketMgr.getServerSocket();
        }
        SocketForwarder forwarder = new SocketForwarder(host, port, this, verbose);
        new Thread(rec.getThreadGroup(), new I2PAppThread(forwarder, "SAMStreamForwarder"), "SAMStreamForwarder").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PServerSocket getSocketServer() {
        Object object = this.socketServerLock;
        synchronized (object) {
            return this.socketServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopForwardingIncoming() throws SAMException, InterruptedIOException {
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null) {
            throw new InterruptedIOException();
        }
        I2PServerSocket server = null;
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer == null) {
                _log.debug("no socket server is defined for this destination");
                throw new SAMException("no socket server is defined for this destination");
            }
            server = this.socketServer;
            this.socketServer = null;
            _log.debug("nulling socketServer in stopForwardingIncoming. Object " + this);
        }
        try {
            server.close();
        }
        catch (I2PException i2PException) {
            // empty catch block
        }
    }

    public void close() {
        this.socketMgr.destroySocketManager();
    }

    public boolean sendBytes(String s, byte[] b) throws DataFormatException {
        throw new DataFormatException(null);
    }

    public class Pipe
    extends Thread {
        ReadableByteChannel in;
        WritableByteChannel out;
        ByteBuffer buf;

        public Pipe(ReadableByteChannel in, WritableByteChannel out, String name) {
            super(name);
            this.in = in;
            this.out = out;
            this.buf = ByteBuffer.allocate(1024);
        }

        public void run() {
            try {
                while (!(Thread.interrupted() || this.in.read(this.buf) < 0 && this.buf.position() == 0)) {
                    this.buf.flip();
                    this.out.write(this.buf);
                    this.buf.compact();
                }
            }
            catch (IOException e) {
                this.interrupt();
            }
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.buf.flip();
                while (this.buf.hasRemaining()) {
                    this.out.write(this.buf);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class SocketForwarder
    extends Thread {
        String host = null;
        int port = 0;
        SAMv3StreamSession session;
        boolean verbose;

        SocketForwarder(String host, int port, SAMv3StreamSession session, boolean verbose) {
            this.host = host;
            this.port = port;
            this.session = session;
            this.verbose = verbose;
        }

        public void run() {
            while (this.session.getSocketServer() != null) {
                I2PSocket i2ps = null;
                try {
                    i2ps = this.session.getSocketServer().accept();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (i2ps == null) continue;
                InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
                SocketChannel clientServerSock = null;
                try {
                    clientServerSock = SocketChannel.open(addr);
                }
                catch (IOException e) {
                    continue;
                }
                if (clientServerSock == null) {
                    try {
                        i2ps.close();
                    }
                    catch (IOException ee) {}
                    continue;
                }
                try {
                    if (this.verbose) {
                        SAMv3Handler.notifyStreamIncomingConnection(clientServerSock, i2ps.getPeerDestination());
                    }
                    SocketChannel fromClient = clientServerSock;
                    ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
                    SocketChannel toClient = clientServerSock;
                    WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
                    new I2PAppThread(new Pipe(fromClient, toI2P, "SAMPipeClientToI2P"), "SAMPipeClientToI2P").start();
                    new I2PAppThread(new Pipe(fromI2P, toClient, "SAMPipeI2PToClient"), "SAMPipeI2PToClient").start();
                }
                catch (IOException e) {
                    try {
                        clientServerSock.close();
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                    try {
                        i2ps.close();
                    }
                    catch (IOException ee) {}
                }
            }
        }
    }
}

