/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMv2StreamSession
extends SAMStreamSession {
    private static final Log _log = new Log(SAMv2StreamSession.class);

    public SAMv2StreamSession(String dest, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        super(dest, dir, props, recv);
    }

    public SAMv2StreamSession(InputStream destStream, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        super(destStream, dir, props, recv);
    }

    public boolean connect(int id, String dest, Properties props) throws DataFormatException, SAMInvalidDirectionException {
        if (!this.canCreate) {
            _log.debug("Trying to create an outgoing connection using a receive-only session");
            throw new SAMInvalidDirectionException("Trying to create connections through a receive-only session");
        }
        if (this.checkSocketHandlerId(id)) {
            _log.debug("The specified id (" + id + ") is already in use");
            return false;
        }
        Destination d = new Destination();
        d.fromBase64(dest);
        I2PSocketOptions opts = this.socketMgr.buildOptions(props);
        if (props.getProperty("i2p.streaming.connectTimeout") == null) {
            opts.setConnectTimeout(60000L);
        }
        _log.debug("Connecting new I2PSocket...");
        StreamConnector connector = new StreamConnector(id, d, opts);
        I2PAppThread connectThread = new I2PAppThread(connector, "StreamConnector" + id);
        connectThread.start();
        return true;
    }

    protected SAMStreamSession.StreamSender newStreamSender(I2PSocket s, int id) throws IOException {
        return new v2StreamSender(s, id);
    }

    protected SAMStreamSession.SAMStreamSessionSocketReader newSAMStreamSessionSocketReader(I2PSocket s, int id) throws IOException {
        return new SAMv2StreamSessionSocketReader(s, id);
    }

    public boolean setReceiveLimit(int id, long limit, boolean nolimit) {
        SAMStreamSession.SAMStreamSessionSocketReader reader = this.getSocketReader(id);
        if (reader == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Trying to set a limit to a nonexistent reader " + id);
            }
            return false;
        }
        ((SAMv2StreamSessionSocketReader)reader).setLimit(limit, nolimit);
        return true;
    }

    public class SAMv2StreamSessionSocketReader
    extends SAMStreamSession.SAMv1StreamSessionSocketReader {
        protected boolean nolimit;
        protected long limit;
        protected long totalReceived;

        public SAMv2StreamSessionSocketReader(I2PSocket s, int id) throws IOException {
            super(s, id);
            this.nolimit = false;
            this.limit = 0L;
            this.totalReceived = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLimit(long limit, boolean nolimit) {
            Object object = this.runningLock;
            synchronized (object) {
                this.limit = limit;
                this.nolimit = nolimit;
                this.runningLock.notify();
            }
            _log.debug("new limit set for socket reader " + this.id + " : " + (nolimit ? "NOLIMIT" : limit + " bytes"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            _log.debug("run() called for socket reader " + this.id);
            int read = -1;
            ByteBuffer data = ByteBuffer.allocateDirect(32768);
            try {
                InputStream in = this.i2pSocket.getInputStream();
                while (this.stillRunning) {
                    Object object = this.runningLock;
                    synchronized (object) {
                        while (this.stillRunning && !this.nolimit && this.totalReceived >= this.limit) {
                            try {
                                this.runningLock.wait();
                            }
                            catch (InterruptedException ie) {}
                        }
                        if (!this.stillRunning) {
                            break;
                        }
                    }
                    data.clear();
                    read = Channels.newChannel(in).read(data);
                    if (read == -1) {
                        _log.debug("Handler " + this.id + ": connection closed");
                        break;
                    }
                    this.totalReceived += (long)read;
                    data.flip();
                    SAMv2StreamSession.this.recv.receiveStreamBytes(this.id, data);
                }
            }
            catch (IOException e) {
                _log.debug("Caught IOException", e);
            }
            try {
                this.i2pSocket.close();
            }
            catch (IOException e) {
                _log.debug("Caught IOException", e);
            }
            if (this.stillRunning) {
                SAMv2StreamSession.this.removeSocketHandler(this.id);
                try {
                    SAMv2StreamSession.this.recv.notifyStreamDisconnection(this.id, "OK", null);
                }
                catch (IOException e) {
                    _log.debug("Error sending disconnection notice for handler " + this.id, e);
                }
            }
            _log.debug("Shutting down SAM STREAM session socket handler " + this.id);
        }
    }

    protected class v2StreamSender
    extends SAMStreamSession.StreamSender {
        private List<ByteArray> _data;
        private int _dataSize;
        private int _id;
        private ByteCache _cache;
        private OutputStream _out;
        private boolean _stillRunning;
        private boolean _shuttingDownGracefully;
        private Object runningLock;
        private I2PSocket i2pSocket;

        public v2StreamSender(I2PSocket s, int id) throws IOException {
            super(s, id);
            this._out = null;
            this.runningLock = new Object();
            this.i2pSocket = null;
            this._data = new ArrayList<ByteArray>(1);
            this._dataSize = 0;
            this._id = id;
            this._cache = ByteCache.getInstance(10, 32768);
            this._out = s.getOutputStream();
            this._stillRunning = true;
            this._shuttingDownGracefully = false;
            this.i2pSocket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendBytes(InputStream in, int size) throws IOException {
            ByteArray ba;
            int read;
            if (_log.shouldLog(10)) {
                _log.debug("Handler " + this._id + ": sending " + size + " bytes");
            }
            if ((read = DataHelper.read(in, (ba = this._cache.acquire()).getData(), 0, size)) != size) {
                throw new IOException("Insufficient data from the SAM client (" + read + "/" + size + ")");
            }
            ba.setValid(read);
            List<ByteArray> list = this._data;
            synchronized (list) {
                if (this._dataSize >= 32768) {
                    this._cache.release(ba, false);
                    SAMv2StreamSession.this.recv.streamSendAnswer(this._id, "FAILED", "BUFFER_FULL");
                } else {
                    this._dataSize += size;
                    this._data.add(ba);
                    this._data.notifyAll();
                    if (this._dataSize >= 32768) {
                        SAMv2StreamSession.this.recv.streamSendAnswer(this._id, "OK", "BUFFER_FULL");
                    } else {
                        SAMv2StreamSession.this.recv.streamSendAnswer(this._id, "OK", "READY");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            _log.debug("stopRunning() invoked on socket sender " + this._id);
            Object object = this.runningLock;
            synchronized (object) {
                if (this._stillRunning) {
                    this._stillRunning = false;
                    try {
                        this.i2pSocket.close();
                    }
                    catch (IOException e) {
                        _log.debug("Caught IOException", e);
                    }
                    List<ByteArray> list = this._data;
                    synchronized (list) {
                        this._data.clear();
                        this._data.notifyAll();
                    }
                }
            }
        }

        public void shutDownGracefully() {
            _log.debug("shutDownGracefully() invoked on socket sender " + this._id);
            this._shuttingDownGracefully = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<ByteArray> list;
            _log.debug("run() called for socket sender " + this._id);
            ByteArray data = null;
            while (this._stillRunning) {
                data = null;
                try {
                    list = this._data;
                    synchronized (list) {
                        if (this._data.size() > 0) {
                            int formerSize = this._dataSize;
                            data = this._data.remove(0);
                            this._dataSize -= data.getValid();
                            if (formerSize >= 32768 && this._dataSize < 32768) {
                                SAMv2StreamSession.this.recv.notifyStreamSendBufferFree(this._id);
                            }
                        } else {
                            if (this._shuttingDownGracefully) {
                                this.stopRunning();
                                break;
                            }
                            this._data.wait(5000L);
                        }
                    }
                    if (data == null) continue;
                    try {
                        this._out.write(data.getData(), 0, data.getValid());
                        if (!SAMv2StreamSession.this.forceFlush) continue;
                        this._out.flush();
                    }
                    catch (IOException ioe) {
                        if (_log.shouldLog(30)) {
                            _log.warn("Stream failed", ioe);
                        }
                        SAMv2StreamSession.this.removeSocketHandler(this._id);
                        this.stopRunning();
                    }
                    finally {
                        this._cache.release(data, false);
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (IOException iOException) {}
            }
            list = this._data;
            synchronized (list) {
                this._data.clear();
            }
        }
    }

    public class StreamConnector
    implements Runnable {
        private int id;
        private Destination dest;
        private I2PSocketOptions opts;

        public StreamConnector(int id, Destination dest, I2PSocketOptions opts) {
            _log.debug("Instantiating new SAM STREAM connector");
            this.id = id;
            this.opts = opts;
            this.dest = dest;
        }

        public void run() {
            _log.debug("run() called for socket connector " + this.id);
            try {
                try {
                    I2PSocket i2ps = SAMv2StreamSession.this.socketMgr.connect(this.dest, this.opts);
                    SAMv2StreamSession.this.createSocketHandler(i2ps, this.id);
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "OK", null);
                }
                catch (DataFormatException e) {
                    _log.debug("Invalid destination in STREAM CONNECT message");
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "INVALID_KEY", e.getMessage());
                }
                catch (ConnectException e) {
                    _log.debug("STREAM CONNECT failed: " + e.getMessage());
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "CONNECTION_REFUSED", e.getMessage());
                }
                catch (NoRouteToHostException e) {
                    _log.debug("STREAM CONNECT failed: " + e.getMessage());
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "CANT_REACH_PEER", e.getMessage());
                }
                catch (InterruptedIOException e) {
                    _log.debug("STREAM CONNECT failed: " + e.getMessage());
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "TIMEOUT", e.getMessage());
                }
                catch (I2PException e) {
                    _log.debug("STREAM CONNECT failed: " + e.getMessage());
                    SAMv2StreamSession.this.recv.notifyStreamOutgoingConnection(this.id, "I2P_ERROR", e.getMessage());
                }
            }
            catch (IOException e) {
                _log.debug("Error sending disconnection notice for handler " + this.id, e);
            }
            _log.debug("Shutting down SAM STREAM session connector " + this.id);
        }
    }
}

