/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMStreamSession {
    private static final Log _log = new Log(SAMStreamSession.class);
    protected static final int SOCKET_HANDLER_BUF_SIZE = 32768;
    protected SAMStreamReceiver recv = null;
    protected SAMStreamSessionServer server = null;
    protected I2PSocketManager socketMgr = null;
    private Object handlersMapLock = new Object();
    private HashMap<Integer, SAMStreamSessionSocketReader> handlersMap = new HashMap();
    private HashMap<Integer, StreamSender> sendersMap = new HashMap();
    private Object idLock = new Object();
    private int lastNegativeId = 0;
    protected boolean canCreate = false;
    protected boolean forceFlush = false;
    public static String PROP_FORCE_FLUSH = "sam.forceFlush";
    public static String DEFAULT_FORCE_FLUSH = "false";

    public SAMStreamSession() {
    }

    public SAMStreamSession(String dest, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(dest));
        this.initSAMStreamSession(bais, dir, props, recv);
    }

    public SAMStreamSession(InputStream destStream, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        this.initSAMStreamSession(destStream, dir, props, recv);
    }

    private void initSAMStreamSession(InputStream destStream, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        this.recv = recv;
        _log.debug("SAM STREAM session instantiated");
        Properties allprops = new Properties();
        allprops.putAll((Map<?, ?>)System.getProperties());
        allprops.putAll((Map<?, ?>)props);
        String i2cpHost = allprops.getProperty("i2cp.tcp.host", "127.0.0.1");
        int i2cpPort = 7654;
        String port = allprops.getProperty("i2cp.tcp.port", "7654");
        try {
            i2cpPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new SAMException("Invalid I2CP port specified [" + port + "]");
        }
        _log.debug("Creating I2PSocketManager...");
        this.socketMgr = I2PSocketManagerFactory.createManager(destStream, i2cpHost, i2cpPort, allprops);
        if (this.socketMgr == null) {
            throw new SAMException("Error creating I2PSocketManager");
        }
        this.socketMgr.addDisconnectListener(new DisconnectListener());
        this.forceFlush = Boolean.valueOf(allprops.getProperty(PROP_FORCE_FLUSH, DEFAULT_FORCE_FLUSH));
        boolean canReceive = false;
        if (dir.equals("BOTH")) {
            this.canCreate = true;
            canReceive = true;
        } else if (dir.equals("CREATE")) {
            this.canCreate = true;
        } else if (dir.equals("RECEIVE")) {
            canReceive = true;
        } else {
            _log.error("BUG! Wrong direction passed to SAMStreamSession: " + dir);
            throw new SAMException("BUG! Wrong direction specified!");
        }
        if (canReceive) {
            this.server = new SAMStreamSessionServer();
            I2PAppThread t = new I2PAppThread(this.server, "SAMStreamSessionServer");
            t.start();
        }
    }

    public Destination getDestination() {
        return this.socketMgr.getSession().getMyDestination();
    }

    public boolean connect(int id, String dest, Properties props) throws I2PException, ConnectException, NoRouteToHostException, DataFormatException, InterruptedIOException, SAMInvalidDirectionException, IOException {
        if (!this.canCreate) {
            _log.debug("Trying to create an outgoing connection using a receive-only session");
            throw new SAMInvalidDirectionException("Trying to create connections through a receive-only session");
        }
        if (this.checkSocketHandlerId(id)) {
            _log.debug("The specified id (" + id + ") is already in use");
            return false;
        }
        Destination d = new Destination();
        d.fromBase64(dest);
        I2PSocketOptions opts = this.socketMgr.buildOptions(props);
        if (props.getProperty("i2p.streaming.connectTimeout") == null) {
            opts.setConnectTimeout(60000L);
        }
        _log.debug("Connecting new I2PSocket...");
        I2PSocket i2ps = this.socketMgr.connect(d, opts);
        this.createSocketHandler(i2ps, id);
        this.recv.notifyStreamOutgoingConnection(id, "OK", null);
        return true;
    }

    public boolean sendBytes(int id, InputStream in, int size) throws IOException {
        StreamSender sender = this.getSender(id);
        if (sender == null) {
            int c;
            if (_log.shouldLog(30)) {
                _log.warn("Trying to send bytes through nonexistent handler " + id);
            }
            for (int i = 0; i < size && (c = in.read()) != -1; ++i) {
            }
            return false;
        }
        sender.sendBytes(in, size);
        return true;
    }

    public void close() {
        if (this.server != null) {
            this.server.stopRunning();
        }
        this.removeAllSocketHandlers();
        this.recv.stopStreamReceiving();
        this.socketMgr.destroySocketManager();
    }

    public boolean closeConnection(int id) {
        if (!this.checkSocketHandlerId(id)) {
            _log.debug("The specified id (" + id + ") does not exist!");
            return false;
        }
        this.removeSocketHandler(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createSocketHandler(I2PSocket s, int id) {
        SAMStreamSessionSocketReader reader = null;
        StreamSender sender = null;
        if (id == 0) {
            id = this.createUniqueId();
        }
        try {
            reader = this.newSAMStreamSessionSocketReader(s, id);
            sender = this.newStreamSender(s, id);
        }
        catch (IOException e) {
            _log.error("IOException when creating SAM STREAM session socket handler", e);
            this.recv.stopStreamReceiving();
            return 0;
        }
        Object e = this.handlersMapLock;
        synchronized (e) {
            this.handlersMap.put(new Integer(id), reader);
            this.sendersMap.put(new Integer(id), sender);
        }
        I2PAppThread t = new I2PAppThread(reader, "SAMReader" + id);
        t.start();
        t = new I2PAppThread(sender, "SAMSender" + id);
        t.start();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createUniqueId() {
        Object object = this.idLock;
        synchronized (object) {
            return --this.lastNegativeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SAMStreamSessionSocketReader getSocketReader(int id) {
        Object object = this.handlersMapLock;
        synchronized (object) {
            return this.handlersMap.get(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSender getSender(int id) {
        Object object = this.handlersMapLock;
        synchronized (object) {
            return this.sendersMap.get(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSocketHandlerId(int id) {
        Object object = this.handlersMapLock;
        synchronized (object) {
            return this.handlersMap.get(new Integer(id)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocketHandler(int id) {
        SAMStreamSessionSocketReader reader = null;
        StreamSender sender = null;
        Object object = this.handlersMapLock;
        synchronized (object) {
            reader = this.handlersMap.remove(new Integer(id));
            sender = this.sendersMap.remove(new Integer(id));
        }
        if (reader != null) {
            reader.stopRunning();
        }
        if (sender != null) {
            sender.shutDownGracefully();
        }
        _log.debug("Removed SAM STREAM session socket handler (gracefully) " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllSocketHandlers() {
        Object object = this.handlersMapLock;
        synchronized (object) {
            Set<Integer> keySet = this.handlersMap.keySet();
            for (Integer id : keySet) {
                this.handlersMap.get(id).stopRunning();
                this.sendersMap.get(id).shutDownGracefully();
            }
            this.handlersMap.clear();
            this.sendersMap.clear();
        }
    }

    boolean setReceiveLimit(int id, long limit, boolean nolimit) {
        _log.debug("Protocol v1 does not support a receive limit for streams");
        return false;
    }

    protected SAMStreamSessionSocketReader newSAMStreamSessionSocketReader(I2PSocket s, int id) throws IOException {
        return new SAMv1StreamSessionSocketReader(s, id);
    }

    protected StreamSender newStreamSender(I2PSocket s, int id) throws IOException {
        return new v1StreamSender(s, id);
    }

    protected class v1StreamSender
    extends StreamSender {
        private List<ByteArray> _data;
        private int _id;
        private ByteCache _cache;
        private OutputStream _out;
        private boolean _stillRunning;
        private boolean _shuttingDownGracefully;
        private Object runningLock;
        private I2PSocket i2pSocket;

        public v1StreamSender(I2PSocket s, int id) throws IOException {
            super(s, id);
            this._out = null;
            this.runningLock = new Object();
            this.i2pSocket = null;
            this._data = new ArrayList<ByteArray>(1);
            this._id = id;
            this._cache = ByteCache.getInstance(4, 32768);
            this._out = s.getOutputStream();
            this._stillRunning = true;
            this._shuttingDownGracefully = false;
            this.i2pSocket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendBytes(InputStream in, int size) throws IOException {
            ByteArray ba;
            int read;
            if (_log.shouldLog(10)) {
                _log.debug("Handler " + this._id + ": sending " + size + " bytes");
            }
            if ((read = DataHelper.read(in, (ba = this._cache.acquire()).getData(), 0, size)) != size) {
                throw new IOException("Insufficient data from the SAM client (" + read + "/" + size + ")");
            }
            ba.setValid(read);
            List<ByteArray> list = this._data;
            synchronized (list) {
                this._data.add(ba);
                this._data.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            _log.debug("stopRunning() invoked on socket sender " + this._id);
            Object object = this.runningLock;
            synchronized (object) {
                if (this._stillRunning) {
                    this._stillRunning = false;
                    try {
                        this.i2pSocket.close();
                    }
                    catch (IOException e) {
                        _log.debug("Caught IOException", e);
                    }
                    List<ByteArray> list = this._data;
                    synchronized (list) {
                        this._data.clear();
                        this._data.notifyAll();
                    }
                }
            }
        }

        public void shutDownGracefully() {
            _log.debug("shutDownGracefully() invoked on socket sender " + this._id);
            this._shuttingDownGracefully = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<ByteArray> list;
            _log.debug("run() called for socket sender " + this._id);
            ByteArray data = null;
            while (this._stillRunning) {
                data = null;
                try {
                    list = this._data;
                    synchronized (list) {
                        if (this._data.size() > 0) {
                            data = this._data.remove(0);
                        } else {
                            if (this._shuttingDownGracefully) {
                                this.stopRunning();
                                break;
                            }
                            this._data.wait(5000L);
                        }
                    }
                    if (data == null) continue;
                    try {
                        this._out.write(data.getData(), 0, data.getValid());
                        if (!SAMStreamSession.this.forceFlush) continue;
                        this._out.flush();
                    }
                    catch (IOException ioe) {
                        if (_log.shouldLog(30)) {
                            _log.warn("Stream failed", ioe);
                        }
                        SAMStreamSession.this.removeSocketHandler(this._id);
                        this.stopRunning();
                    }
                    finally {
                        this._cache.release(data);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            list = this._data;
            synchronized (list) {
                this._data.clear();
            }
        }
    }

    protected class StreamSender
    implements Runnable {
        public StreamSender(I2PSocket s, int id) throws IOException {
        }

        public void sendBytes(InputStream in, int size) throws IOException {
        }

        public void stopRunning() {
        }

        public void shutDownGracefully() {
        }

        public void run() {
        }
    }

    public class SAMv1StreamSessionSocketReader
    extends SAMStreamSessionSocketReader {
        public SAMv1StreamSessionSocketReader(I2PSocket s, int id) throws IOException {
            super(s, id);
            _log.debug("Instantiating new SAM STREAM session socket reader");
            this.i2pSocket = s;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            _log.debug("stopRunning() invoked on socket reader " + this.id);
            Object object = this.runningLock;
            synchronized (object) {
                if (this.stillRunning) {
                    this.stillRunning = false;
                }
                this.runningLock.notifyAll();
            }
        }

        public void run() {
            _log.debug("run() called for socket reader " + this.id);
            int read = -1;
            ByteBuffer data = ByteBuffer.allocateDirect(32768);
            try {
                InputStream in = this.i2pSocket.getInputStream();
                while (this.stillRunning) {
                    data.clear();
                    read = Channels.newChannel(in).read(data);
                    if (read == -1) {
                        _log.debug("Handler " + this.id + ": connection closed");
                        break;
                    }
                    data.flip();
                    SAMStreamSession.this.recv.receiveStreamBytes(this.id, data);
                }
            }
            catch (IOException e) {
                _log.debug("Caught IOException", e);
            }
            try {
                this.i2pSocket.close();
            }
            catch (IOException e) {
                _log.debug("Caught IOException", e);
            }
            if (this.stillRunning) {
                SAMStreamSession.this.removeSocketHandler(this.id);
                try {
                    SAMStreamSession.this.recv.notifyStreamDisconnection(this.id, "OK", null);
                }
                catch (IOException e) {
                    _log.debug("Error sending disconnection notice for handler " + this.id, e);
                }
            }
            _log.debug("Shutting down SAM STREAM session socket handler " + this.id);
        }
    }

    public class SAMStreamSessionSocketReader
    implements Runnable {
        protected I2PSocket i2pSocket = null;
        protected Object runningLock = new Object();
        protected boolean stillRunning = true;
        protected int id;

        public SAMStreamSessionSocketReader(I2PSocket s, int id) throws IOException {
        }

        public void stopRunning() {
        }

        public void run() {
        }
    }

    public class SAMStreamSessionServer
    implements Runnable {
        private Object runningLock = new Object();
        private boolean stillRunning = true;
        private I2PServerSocket serverSocket = null;

        public SAMStreamSessionServer() {
            _log.debug("Instantiating new SAM STREAM session server");
            this.serverSocket = SAMStreamSession.this.socketMgr.getServerSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            _log.debug("SAMStreamSessionServer.stopRunning() invoked");
            Object object = this.runningLock;
            synchronized (object) {
                if (this.stillRunning) {
                    this.stillRunning = false;
                    try {
                        this.serverSocket.close();
                    }
                    catch (I2PException e) {
                        _log.error("I2PException caught", e);
                    }
                }
            }
        }

        public void run() {
            _log.debug("SAM STREAM session server running");
            while (this.stillRunning) {
                try {
                    I2PSocket i2ps = this.serverSocket.accept();
                    if (i2ps == null) break;
                    _log.debug("New incoming connection");
                    int id = SAMStreamSession.this.createSocketHandler(i2ps, 0);
                    if (id == 0) {
                        _log.error("SAM STREAM session handler not created!");
                        i2ps.close();
                        continue;
                    }
                    _log.debug("New connection id: " + id);
                    SAMStreamSession.this.recv.notifyStreamIncomingConnection(id, i2ps.getPeerDestination());
                }
                catch (I2PException e) {
                    _log.debug("Caught I2PException", e);
                    break;
                }
                catch (IOException e) {
                    _log.debug("Caught IOException", e);
                    break;
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (I2PException e) {
                _log.debug("Caught I2PException", e);
            }
            SAMStreamSession.this.close();
            _log.debug("Shutting down SAM STREAM session server");
        }
    }

    protected class DisconnectListener
    implements I2PSocketManager.DisconnectListener {
        protected DisconnectListener() {
        }

        public void sessionDisconnected() {
            SAMStreamSession.this.close();
        }
    }
}

