/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMMessageSession;
import net.i2p.util.Log;

public class SAMDatagramSession
extends SAMMessageSession {
    private static final Log _log = new Log(SAMDatagramSession.class);
    public static int DGRAM_SIZE_MAX = 31744;
    protected SAMDatagramReceiver recv = null;
    private I2PDatagramMaker dgramMaker;
    private I2PDatagramDissector dgramDissector = new I2PDatagramDissector();

    public SAMDatagramSession(String dest, Properties props, SAMDatagramReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(dest, props);
        this.recv = recv;
        this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
    }

    public SAMDatagramSession(InputStream destStream, Properties props, SAMDatagramReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(destStream, props);
        this.recv = recv;
        this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBytes(String dest, byte[] data) throws DataFormatException {
        byte[] dgram;
        if (data.length > DGRAM_SIZE_MAX) {
            throw new DataFormatException("Datagram size exceeded (" + data.length + ")");
        }
        I2PDatagramMaker i2PDatagramMaker = this.dgramMaker;
        synchronized (i2PDatagramMaker) {
            dgram = this.dgramMaker.makeI2PDatagram(data);
        }
        return this.sendBytesThroughMessageSession(dest, dgram);
    }

    protected void messageReceived(byte[] msg) {
        byte[] payload;
        Destination sender;
        try {
            this.dgramDissector.loadI2PDatagram(msg);
            sender = this.dgramDissector.getSender();
            payload = this.dgramDissector.extractPayload();
        }
        catch (DataFormatException e) {
            if (_log.shouldLog(10)) {
                _log.debug("Dropping ill-formatted I2P repliable datagram");
            }
            return;
        }
        catch (I2PInvalidDatagramException e) {
            if (_log.shouldLog(10)) {
                _log.debug("Dropping ill-signed I2P repliable datagram");
            }
            return;
        }
        try {
            this.recv.receiveDatagramBytes(sender, payload);
        }
        catch (IOException e) {
            _log.error("Error forwarding message to receiver", e);
            this.close();
        }
    }

    protected void shutDown() {
        this.recv.stopDatagramReceiving();
    }
}

