/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PServerSocketFull;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketFull;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.TooManyStreamsException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class I2PSocketManagerFull
implements I2PSocketManager {
    private I2PAppContext _context = null;
    private Log _log;
    private I2PSession _session = null;
    private I2PServerSocketFull _serverSocket;
    private ConnectionOptions _defaultOptions;
    private long _acceptTimeout;
    private String _name;
    private int _maxStreams;
    private static int __managerId = 0;
    private ConnectionManager _connectionManager;
    private static final long ACCEPT_TIMEOUT_DEFAULT = 5000L;
    public static final String PROP_MAX_STREAMS = "i2p.streaming.maxConcurrentStreams";

    public I2PSocketManagerFull() {
    }

    public I2PSocketManagerFull(I2PAppContext context, I2PSession session, Properties opts, String name) {
        this();
        this.init(context, session, opts, name);
    }

    public void init(I2PAppContext context, I2PSession session, Properties opts, String name) {
        this._context = context;
        this._session = session;
        this._log = this._context.logManager().getLog(I2PSocketManagerFull.class);
        this._maxStreams = -1;
        try {
            String num = opts != null ? opts.getProperty(PROP_MAX_STREAMS, "-1") : "-1";
            this._maxStreams = Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid max # of concurrent streams, defaulting to unlimited", (Throwable)nfe);
            }
            this._maxStreams = -1;
        }
        this._name = name + " " + ++__managerId;
        this._acceptTimeout = 5000L;
        this._defaultOptions = new ConnectionOptions(opts);
        this._connectionManager = new ConnectionManager(this._context, this._session, this._maxStreams, this._defaultOptions);
        this._serverSocket = new I2PServerSocketFull(this);
        if (this._log.shouldLog(20)) {
            this._log.info("Socket manager created.  \ndefault options: " + (Object)((Object)this._defaultOptions) + "\noriginal properties: " + opts);
        }
    }

    public I2PSocketOptions buildOptions() {
        return this.buildOptions(null);
    }

    public I2PSocketOptions buildOptions(Properties opts) {
        ConnectionOptions curOpts = new ConnectionOptions(this._defaultOptions);
        curOpts.setProperties(opts);
        return curOpts;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public I2PSocket receiveSocket() throws I2PException, SocketTimeoutException {
        this.verifySession();
        Connection con = this._connectionManager.getConnectionHandler().accept(this._connectionManager.MgetSoTimeout());
        if (this._log.shouldLog(10)) {
            this._log.debug("receiveSocket() called: " + con);
        }
        if (con != null) {
            I2PSocketFull sock = new I2PSocketFull(con);
            con.setSocket(sock);
            return sock;
        }
        if (this._connectionManager.MgetSoTimeout() == -1L) {
            return null;
        }
        throw new SocketTimeoutException("I2PSocket timed out");
    }

    public boolean ping(Destination peer, long timeoutMs) {
        return this._connectionManager.ping(peer, timeoutMs);
    }

    public void setAcceptTimeout(long ms) {
        this._acceptTimeout = ms;
    }

    public long getAcceptTimeout() {
        return this._acceptTimeout;
    }

    public void setDefaultOptions(I2PSocketOptions options) {
        this._defaultOptions = new ConnectionOptions((ConnectionOptions)options);
    }

    public I2PSocketOptions getDefaultOptions() {
        return this._defaultOptions;
    }

    public I2PServerSocket getServerSocket() {
        this._connectionManager.setAllowIncomingConnections(true);
        return this._serverSocket;
    }

    private void verifySession() throws I2PException {
        if (!this._connectionManager.getSession().isClosed()) {
            return;
        }
        this._connectionManager.getSession().connect();
    }

    public I2PSocket connect(Destination peer, I2PSocketOptions options) throws I2PException, NoRouteToHostException {
        Connection con;
        this.verifySession();
        if (options == null) {
            options = this._defaultOptions;
        }
        ConnectionOptions opts = null;
        opts = options instanceof ConnectionOptions ? new ConnectionOptions((ConnectionOptions)((Object)options)) : new ConnectionOptions((I2PSocketOptions)options);
        if (this._log.shouldLog(20)) {
            this._log.info("Connecting to " + peer.calculateHash().toBase64().substring(0, 6) + " with options: " + (Object)((Object)opts));
        }
        if ((con = this._connectionManager.connect(peer, opts)) == null) {
            throw new TooManyStreamsException("Too many streams (max " + this._maxStreams + ")");
        }
        I2PSocketFull socket = new I2PSocketFull(con);
        con.setSocket(socket);
        if (con.getConnectionError() != null) {
            con.disconnect(false);
            throw new NoRouteToHostException(con.getConnectionError());
        }
        return socket;
    }

    public I2PSocket connect(Destination peer) throws I2PException, NoRouteToHostException {
        return this.connect(peer, (I2PSocketOptions)this._defaultOptions);
    }

    public void destroySocketManager() {
        this._connectionManager.setAllowIncomingConnections(false);
        this._connectionManager.disconnectAllHard();
        if (this._session != null && !this._session.isClosed()) {
            try {
                this._session.destroySession();
            }
            catch (I2PSessionException ise) {
                this._log.warn("Unable to destroy the session", (Throwable)ise);
            }
        }
    }

    public Set listSockets() {
        Set connections = this._connectionManager.listConnections();
        HashSet<I2PSocketFull> rv = new HashSet<I2PSocketFull>(connections.size());
        for (Connection con : connections) {
            if (con.getSocket() == null) continue;
            rv.add(con.getSocket());
        }
        return rv;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().addDisconnectListener(lsnr);
    }

    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().removeDisconnectListener(lsnr);
    }
}

