/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionHandler;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.ConnectionPacketHandler;
import net.i2p.client.streaming.MessageHandler;
import net.i2p.client.streaming.MessageInputStream;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketHandler;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.client.streaming.PacketQueue;
import net.i2p.client.streaming.SchedulerChooser;
import net.i2p.client.streaming.TCBShare;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class ConnectionManager {
    private I2PAppContext _context;
    private Log _log;
    private I2PSession _session;
    private MessageHandler _messageHandler;
    private PacketHandler _packetHandler;
    private ConnectionHandler _connectionHandler;
    private PacketQueue _outboundQueue;
    private SchedulerChooser _schedulerChooser;
    private ConnectionPacketHandler _conPacketHandler;
    private TCBShare _tcbShare;
    private Map _connectionByInboundId;
    private final Map _pendingPings;
    private boolean _allowIncoming;
    private int _maxConcurrentStreams;
    private ConnectionOptions _defaultOptions;
    private volatile int _numWaiting;
    private final Object _connectionLock;
    private long SoTimeout;
    private static final long DEFAULT_STREAM_DELAY_MAX = 10000L;

    public ConnectionManager(I2PAppContext context, I2PSession session, int maxConcurrent, ConnectionOptions defaultOptions) {
        this._context = context;
        this._session = session;
        this._maxConcurrentStreams = maxConcurrent;
        this._defaultOptions = defaultOptions;
        this._log = this._context.logManager().getLog(ConnectionManager.class);
        this._connectionByInboundId = new HashMap(32);
        this._pendingPings = new HashMap(4);
        this._connectionLock = new Object();
        this._messageHandler = new MessageHandler(this._context, this);
        this._packetHandler = new PacketHandler(this._context, this);
        this._connectionHandler = new ConnectionHandler(this._context, this);
        this._schedulerChooser = new SchedulerChooser(this._context);
        this._conPacketHandler = new ConnectionPacketHandler(this._context);
        this._tcbShare = new TCBShare(this._context);
        this._session.setSessionListener((I2PSessionListener)this._messageHandler);
        this._outboundQueue = new PacketQueue(this._context, this._session, this);
        this._allowIncoming = false;
        this._numWaiting = 0;
        this.SoTimeout = -1L;
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesSent", "How many messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesReceived", "How many messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesSent", "How many bytes do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesReceived", "How many bytes do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesSent", "How many duplicate messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesReceived", "How many duplicate messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeRTT", "What is the final RTT when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeCongestionSeenAt", "When was the last congestion seen at when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeSendWindowSize", "What is the final send window size when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.receiveActive", "How many streams are active when a new one is received (period being not yet dropped)", "Stream", new long[]{3600000L, 86400000L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnectionByInboundId(long id) {
        Object object = this._connectionLock;
        synchronized (object) {
            return (Connection)this._connectionByInboundId.get(new Long(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnectionByOutboundId(long id) {
        Object object = this._connectionLock;
        synchronized (object) {
            for (Connection con : this._connectionByInboundId.values()) {
                if (!DataHelper.eq((long)con.getSendStreamId(), (long)id)) continue;
                return con;
            }
        }
        return null;
    }

    public void MsetSoTimeout(long x) {
        this.SoTimeout = x;
    }

    public long MgetSoTimeout() {
        return this.SoTimeout;
    }

    public void setAllowIncomingConnections(boolean allow) {
        this._connectionHandler.setActive(allow);
    }

    public boolean getAllowIncomingConnections() {
        return this._connectionHandler.getActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection receiveConnection(Packet synPacket) {
        Connection con = new Connection(this._context, this, this._schedulerChooser, this._outboundQueue, this._conPacketHandler, new ConnectionOptions(this._defaultOptions));
        this._tcbShare.updateOptsFromShare(con);
        con.setInbound();
        long receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        boolean reject = false;
        int active = 0;
        int total = 0;
        Object object = this._connectionLock;
        synchronized (object) {
            total = this._connectionByInboundId.size();
            Iterator iter = this._connectionByInboundId.values().iterator();
            while (iter.hasNext()) {
                if (!((Connection)iter.next()).getIsConnected()) continue;
                ++active;
            }
            if (this.locked_tooManyStreams()) {
                reject = true;
            } else {
                Connection oldCon;
                while ((oldCon = this._connectionByInboundId.put(new Long(receiveId), con)) != null) {
                    this._connectionByInboundId.put(new Long(receiveId), oldCon);
                    receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
                }
            }
        }
        this._context.statManager().addRateData("stream.receiveActive", (long)active, (long)total);
        if (reject) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Refusing connection since we have exceeded our max of " + this._maxConcurrentStreams + " connections");
            }
            PacketLocal reply = new PacketLocal(this._context, synPacket.getOptionalFrom());
            reply.setFlag(4);
            reply.setFlag(8);
            reply.setAckThrough(synPacket.getSequenceNum());
            reply.setSendStreamId(synPacket.getReceiveStreamId());
            reply.setReceiveStreamId(0L);
            reply.setOptionalFrom(this._session.getMyDestination());
            this._outboundQueue.enqueue(reply);
            return null;
        }
        con.setReceiveStreamId(receiveId);
        try {
            con.getPacketHandler().receivePacket(synPacket, con);
        }
        catch (I2PException ie) {
            Object object2 = this._connectionLock;
            synchronized (object2) {
                this._connectionByInboundId.remove(new Long(receiveId));
            }
            return null;
        }
        this._context.statManager().addRateData("stream.connectionReceived", 1L, 0L);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(Destination peer, ConnectionOptions opts) {
        Connection con = null;
        long receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        long expiration = this._context.clock().now() + opts.getConnectTimeout();
        if (opts.getConnectTimeout() <= 0L) {
            expiration = this._context.clock().now() + 10000L;
        }
        ++this._numWaiting;
        while (true) {
            long remaining;
            if ((remaining = expiration - this._context.clock().now()) <= 0L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Refusing to connect since we have exceeded our max of " + this._maxConcurrentStreams + " connections");
                }
                --this._numWaiting;
                return null;
            }
            boolean reject = false;
            Object object = this._connectionLock;
            synchronized (object) {
                if (this.locked_tooManyStreams()) {
                    if (this._numWaiting > this._maxConcurrentStreams) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Refusing connection since we have exceeded our max of " + this._maxConcurrentStreams + " and there are " + this._numWaiting + " waiting already");
                        }
                        --this._numWaiting;
                        return null;
                    }
                    try {
                        this._connectionLock.wait(remaining);
                    }
                    catch (InterruptedException ie) {}
                } else {
                    con = new Connection(this._context, this, this._schedulerChooser, this._outboundQueue, this._conPacketHandler, opts);
                    con.setRemotePeer(peer);
                    while (this._connectionByInboundId.containsKey(new Long(receiveId))) {
                        receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
                    }
                    this._connectionByInboundId.put(new Long(receiveId), con);
                    break;
                }
            }
        }
        con.setReceiveStreamId(receiveId);
        con.eventOccurred();
        this._log.debug("Connect() conDelay = " + opts.getConnectDelay());
        if (opts.getConnectDelay() <= 0) {
            con.waitForConnect();
        }
        if (this._numWaiting > 0) {
            --this._numWaiting;
        }
        this._context.statManager().addRateData("stream.connectionCreated", 1L, 0L);
        return con;
    }

    private boolean locked_tooManyStreams() {
        if (this._maxConcurrentStreams <= 0) {
            return false;
        }
        if (this._connectionByInboundId.size() < this._maxConcurrentStreams) {
            return false;
        }
        int active = 0;
        for (Connection con : this._connectionByInboundId.values()) {
            if (!con.getIsConnected()) continue;
            ++active;
        }
        if (this._connectionByInboundId.size() > 100 && this._log.shouldLog(20)) {
            this._log.info("More than 100 connections!  " + active + " total: " + this._connectionByInboundId.size());
        }
        return active >= this._maxConcurrentStreams;
    }

    public MessageHandler getMessageHandler() {
        return this._messageHandler;
    }

    public PacketHandler getPacketHandler() {
        return this._packetHandler;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public void updateOptsFromShare(Connection con) {
        this._tcbShare.updateOptsFromShare(con);
    }

    public void updateShareOpts(Connection con) {
        this._tcbShare.updateShareOpts(con);
    }

    public ConnectionHandler getConnectionHandler() {
        return this._connectionHandler;
    }

    public PacketQueue getPacketQueue() {
        return this._outboundQueue;
    }

    public boolean answerPings() {
        return this._defaultOptions.getAnswerPings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAllHard() {
        Object object = this._connectionLock;
        synchronized (object) {
            for (Connection con : this._connectionByInboundId.values()) {
                con.disconnect(false, false);
            }
            this._connectionByInboundId.clear();
            this._connectionLock.notifyAll();
        }
        this._tcbShare.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection con) {
        boolean removed = false;
        Object object = this._connectionLock;
        synchronized (object) {
            Object o = this._connectionByInboundId.remove(new Long(con.getReceiveStreamId()));
            boolean bl = removed = o == con;
            if (this._log.shouldLog(10)) {
                this._log.debug("Connection removed? " + removed + " remaining: " + this._connectionByInboundId.size() + ": " + con);
            }
            if (!removed && this._log.shouldLog(10)) {
                this._log.debug("Failed to remove " + con + "\n" + this._connectionByInboundId.values());
            }
            this._connectionLock.notifyAll();
        }
        if (removed) {
            this._context.statManager().addRateData("stream.con.lifetimeMessagesSent", 1L + con.getLastSendId(), con.getLifetime());
            MessageInputStream stream = con.getInputStream();
            if (stream != null) {
                long rcvd = 1L + stream.getHighestBlockId();
                long[] nacks = stream.getNacks();
                if (nacks != null) {
                    rcvd -= (long)nacks.length;
                }
                this._context.statManager().addRateData("stream.con.lifetimeMessagesReceived", rcvd, con.getLifetime());
            }
            this._context.statManager().addRateData("stream.con.lifetimeBytesSent", con.getLifetimeBytesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeBytesReceived", con.getLifetimeBytesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesSent", con.getLifetimeDupMessagesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesReceived", con.getLifetimeDupMessagesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeRTT", (long)con.getOptions().getRTT(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeCongestionSeenAt", (long)con.getLastCongestionSeenAt(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeSendWindowSize", (long)con.getOptions().getWindowSize(), con.getLifetime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listConnections() {
        Object object = this._connectionLock;
        synchronized (object) {
            return new HashSet(this._connectionByInboundId.values());
        }
    }

    public boolean ping(Destination peer, long timeoutMs) {
        return this.ping(peer, timeoutMs, true, null);
    }

    public boolean ping(Destination peer, long timeoutMs, boolean blocking) {
        return this.ping(peer, timeoutMs, blocking, null);
    }

    public boolean ping(Destination peer, long timeoutMs, boolean blocking, SessionKey keyToUse, Set tagsToSend, PingNotifier notifier) {
        return this.ping(peer, timeoutMs, blocking, notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(Destination peer, long timeoutMs, boolean blocking, PingNotifier notifier) {
        Long id = new Long(this._context.random().nextLong(0xFFFFFFFEL) + 1L);
        PacketLocal packet = new PacketLocal(this._context, peer);
        packet.setSendStreamId(id);
        packet.setFlag(512);
        packet.setFlag(8);
        packet.setOptionalFrom(this._session.getMyDestination());
        PingRequest req = new PingRequest(peer, packet, notifier);
        Object object = this._pendingPings;
        synchronized (object) {
            this._pendingPings.put(id, req);
        }
        this._outboundQueue.enqueue(packet);
        packet.releasePayload();
        if (blocking) {
            object = req;
            synchronized (object) {
                if (!req.pongReceived()) {
                    try {
                        req.wait(timeoutMs);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            object = this._pendingPings;
            synchronized (object) {
                this._pendingPings.remove(id);
            }
        }
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new PingFailed(id, notifier), timeoutMs);
        boolean ok = req.pongReceived();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePong(long pingId) {
        PingRequest req = null;
        Map map = this._pendingPings;
        synchronized (map) {
            req = (PingRequest)this._pendingPings.remove(new Long(pingId));
        }
        if (req != null) {
            req.pong();
        }
    }

    private class PingRequest {
        private boolean _ponged = false;
        private Destination _peer;
        private PacketLocal _packet;
        private PingNotifier _notifier;

        public PingRequest(Destination peer, PacketLocal packet, PingNotifier notifier) {
            this._peer = peer;
            this._packet = packet;
            this._notifier = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pong() {
            ConnectionManager.this._log.debug("Ping successful");
            PingRequest pingRequest = this;
            synchronized (pingRequest) {
                this._ponged = true;
                this.notifyAll();
            }
            if (this._notifier != null) {
                this._notifier.pingComplete(true);
            }
        }

        public boolean pongReceived() {
            return this._ponged;
        }
    }

    private class PingFailed
    implements SimpleTimer.TimedEvent {
        private Long _id;
        private PingNotifier _notifier;

        public PingFailed(Long id, PingNotifier notifier) {
            this._id = id;
            this._notifier = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            boolean removed = false;
            Map map = ConnectionManager.this._pendingPings;
            synchronized (map) {
                Object o = ConnectionManager.this._pendingPings.remove(this._id);
                if (o != null) {
                    removed = true;
                }
            }
            if (removed) {
                if (this._notifier != null) {
                    this._notifier.pingComplete(false);
                }
                if (ConnectionManager.this._log.shouldLog(20)) {
                    ConnectionManager.this._log.info("Ping failed");
                }
            }
        }
    }

    public static interface PingNotifier {
        public void pingComplete(boolean var1);
    }
}

