/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ArrayList;
import java.util.Random;

public final class StringUtils {
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_US_ASCII = "US-ASCII";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String FILE_DELIMITERS = " -,._+/*()[]\\";
    private static Random randomizer = new Random();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes(ENCODING_ISO_8859_1);
        }
        catch (Exception e) {
            return s.getBytes();
        }
    }

    public static byte[] getBytesInUsAscii(String s) {
        try {
            return s.getBytes(ENCODING_US_ASCII);
        }
        catch (Exception e) {
            return s.getBytes();
        }
    }

    public static boolean isFileDelimiter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(String val) {
        return val == null || val.length() == 0;
    }

    public static String createNaturalSearchTerm(String searchTerm) {
        return StringUtils.replaceChars(searchTerm, FILE_DELIMITERS, ' ');
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String replace(String text, String repl, String with, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(repl, start);
        if (end == -1) {
            return text;
        }
        int increase = with.length() - repl.length();
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
            end = text.indexOf(repl, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceChars(String str, String searchChars, char replaceChar) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        boolean modified = false;
        int strLength = str.length();
        StringBuffer buf = new StringBuffer(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                buf.append(replaceChar);
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String generateRandomUUIDString() {
        byte[] uuid = new byte[16];
        randomizer.nextBytes(uuid);
        uuid[6] = (byte)(uuid[6] & 0xF);
        uuid[6] = (byte)(uuid[6] | 0x40);
        uuid[8] = (byte)(uuid[8] & 0x3F);
        uuid[8] = (byte)(uuid[8] | 0xFFFFFF80);
        StringBuffer buf = new StringBuffer(36);
        for (int i = 0; i < 16; ++i) {
            int val = uuid[i] & 0xFF;
            buf.append(HEX_CHARS[val >> 4]);
            buf.append(HEX_CHARS[val & 0xF]);
        }
        buf.insert(8, '-');
        buf.insert(13, '-');
        buf.insert(18, '-');
        buf.insert(23, '-');
        return buf.toString();
    }
}

