/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import phex.common.log.NLogger;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Localizer {
    private static Map<String, String> langKeyMap;
    private static Locale usedLocale;
    private static List<Locale> availableLocales;
    private static DecimalFormatSymbols decimalFormatSymbols;
    private static NumberFormat integerNumberFormat;

    public static void initialize(String localeStr) {
        Locale locale;
        Localizer.setUsedLocale(Locale.US);
        if (localeStr == null || localeStr.length() == 0 || localeStr.length() != 2 && localeStr.length() != 5 && localeStr.length() != 8) {
            locale = Locale.US;
        } else {
            String lang = localeStr.substring(0, 2);
            String country = "";
            if (localeStr.length() >= 5) {
                country = localeStr.substring(3, 5);
            }
            String variant = "";
            if (localeStr.length() == 8) {
                variant = localeStr.substring(6, 8);
            }
            locale = new Locale(lang, country, variant);
        }
        Localizer.setUsedLocale(locale);
    }

    public static void setUsedLocale(Locale locale) {
        usedLocale = locale;
        Localizer.buildResourceBundle(locale);
        decimalFormatSymbols = new DecimalFormatSymbols(usedLocale);
        integerNumberFormat = NumberFormat.getIntegerInstance(usedLocale);
    }

    public static Locale getUsedLocale() {
        return usedLocale;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return decimalFormatSymbols;
    }

    public static NumberFormat getIntegerNumberFormat() {
        return integerNumberFormat;
    }

    private static void buildResourceBundle(Locale locale) {
        ArrayList<String> fileList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer("Lang");
        fileList.add(buffer.toString());
        String language = locale.getLanguage();
        if (language.length() > 0) {
            buffer.append('_');
            buffer.append(language);
            fileList.add(buffer.toString());
            String country = locale.getCountry();
            if (country.length() > 0) {
                buffer.append('_');
                buffer.append(country);
                fileList.add(buffer.toString());
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    buffer.append('_');
                    buffer.append(variant);
                    fileList.add(buffer.toString());
                }
            }
        }
        langKeyMap = new HashMap<String, String>();
        HashMap<Object, Object> tmpMap = new HashMap();
        int size = fileList.size();
        for (int i = 0; i < size; ++i) {
            String resourceName = "/phex/resources/" + (String)fileList.get(i) + ".properties";
            tmpMap = Localizer.loadProperties(resourceName);
            if (tmpMap != null) {
                langKeyMap.putAll(tmpMap);
                NLogger.debug(Localizer.class, (Object)("Loaded language map: " + resourceName + "."));
            }
            if ((tmpMap = Localizer.loadProperties(resourceName = "/" + (String)fileList.get(i) + ".properties")) == null) continue;
            langKeyMap.putAll(tmpMap);
            NLogger.debug(Localizer.class, (Object)("Loaded language map: " + resourceName + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> loadProperties(String name) {
        InputStream stream = Localizer.class.getResourceAsStream(name);
        if (stream == null) {
            return null;
        }
        stream = new BufferedInputStream(stream);
        Properties props = new Properties();
        try {
            props.load(stream);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(props);
            return hashMap;
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.closeQuietly(stream);
        }
        return null;
    }

    public static List<Locale> getAvailableLocales() {
        if (availableLocales != null) {
            return availableLocales;
        }
        availableLocales = new ArrayList<Locale>();
        List<Locale> list = Localizer.loadLocalList("/language.list");
        availableLocales.addAll(list);
        list = Localizer.loadLocalList("/phex/resources/language.list");
        availableLocales.addAll(list);
        return availableLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Locale> loadLocalList(String name) {
        InputStream stream = Localizer.class.getResourceAsStream(name);
        if (stream == null) {
            return Collections.emptyList();
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
            ArrayList<Locale> list = new ArrayList<Locale>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() != 2 && line.length() != 5 && line.length() != 8) continue;
                String lang = line.substring(0, 2);
                String country = "";
                if (line.length() >= 5) {
                    country = line.substring(3, 5);
                }
                String variant = "";
                if (line.length() == 8) {
                    variant = line.substring(6, 8);
                }
                Locale locale = new Locale(lang, country, variant);
                list.add(locale);
            }
            ArrayList<Locale> arrayList = list;
            return arrayList;
        }
        catch (IOException exp) {
            NLogger.error(Localizer.class, (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(stream);
        }
        return Collections.emptyList();
    }

    public static String getString(String key) {
        String value = langKeyMap.get(key);
        if (value == null) {
            NLogger.error(Localizer.class, (Object)("Missing language key: " + key));
            value = key;
        }
        return value;
    }

    public static char getChar(String key) {
        String str = Localizer.getString(key);
        return str.charAt(0);
    }

    public static String getFormatedString(String key, Object ... obj) {
        String value = null;
        String lookupValue = langKeyMap.get(key);
        if (lookupValue != null) {
            value = MessageFormat.format(lookupValue, obj);
        } else {
            NLogger.info(Localizer.class, (Object)("Missing language key: " + key));
            value = key;
        }
        return value;
    }
}

