/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.HorizonTracker;
import phex.statistic.StatisticProvider;

public class HorizonStatisticProvider
implements StatisticProvider {
    private static final short HOST_COUNT = 0;
    private static final short FILE_COUNT = 1;
    private static final short FILE_SIZE = 2;
    protected static final HorizonStatisticProvider HORIZON_HOST_COUNT_PROVIDER = new HorizonStatisticProvider(0);
    protected static final HorizonStatisticProvider HORIZON_FILE_COUNT_PROVIDER = new HorizonStatisticProvider(1);
    protected static final HorizonStatisticProvider HORIZON_FILE_SIZE_PROVIDER = new HorizonStatisticProvider(2);
    private short type;

    public HorizonStatisticProvider(short type) {
        this.type = type;
    }

    public Object getValue() {
        switch (this.type) {
            case 0: {
                return HorizonTracker.getInstance().getTotalHostCount();
            }
            case 1: {
                return HorizonTracker.getInstance().getTotalFileCount();
            }
            case 2: {
                return HorizonTracker.getInstance().getTotalFileSize();
            }
        }
        return null;
    }

    public Object getAverageValue() {
        switch (this.type) {
            case 2: {
                HorizonTracker tracker = HorizonTracker.getInstance();
                long count = tracker.getTotalFileCount();
                if (count == 0L) break;
                int val = (int)((double)tracker.getTotalFileSize() / (double)count);
                return val;
            }
            case 1: {
                HorizonTracker tracker = HorizonTracker.getInstance();
                int hostCount = tracker.getTotalHostCount();
                if (hostCount == 0) break;
                int val = (int)((double)tracker.getTotalFileCount() / (double)hostCount);
                return val;
            }
        }
        return null;
    }

    public Object getMaxValue() {
        return null;
    }

    public String toStatisticString(Object value) {
        return value.toString();
    }
}

