/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.share.ShareFile;
import phex.share.export.SharedFilesPipeFiller;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportEngine {
    public static final String USE_MAGNET_URL_WITH_XS = "UseMagnetURLWithXS";
    public static final String USE_MAGNET_URL_WITH_FREEBASE = "UseMagnetURLWithFreeBase";
    private final DestAddress serventAddress;
    private InputStream styleSheetStream;
    private OutputStream destinationStream;
    private List<ShareFile> exportData;
    private Map<String, String> exportOptions;

    public ExportEngine(DestAddress serventAddress, OutputStream destinationStream, List<ShareFile> exportData) {
        this(serventAddress, null, destinationStream, exportData, null);
    }

    public ExportEngine(DestAddress serventAddress, InputStream styleSheetStream, OutputStream destinationStream, List<ShareFile> exportData, Map<String, String> exportOptions) {
        if (destinationStream == null) {
            throw new NullPointerException("No destination to export to");
        }
        if (exportData == null) {
            throw new NullPointerException("No data to export given.");
        }
        if (styleSheetStream == null) {
            styleSheetStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
        }
        this.serventAddress = serventAddress;
        this.styleSheetStream = styleSheetStream;
        this.destinationStream = destinationStream;
        this.exportData = exportData;
        this.exportOptions = exportOptions;
    }

    public void setExportOptions(Map<String, String> options) {
        this.exportOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExport() {
        PipedOutputStream pipedOutStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutStream.connect(pipedInputStream);
            SharedFilesPipeFiller fillerRunnable = new SharedFilesPipeFiller(this.serventAddress, pipedOutStream, this.exportData, this.exportOptions);
            Environment.getInstance().executeOnThreadPool(fillerRunnable, "SharedFilesPipeFiller");
            StreamSource styleSheetSource = new StreamSource(this.styleSheetStream);
            StreamSource dataSource = new StreamSource(pipedInputStream);
            StreamResult result = new StreamResult(this.destinationStream);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(styleSheetSource);
                transformer.transform(dataSource, result);
            }
            catch (TransformerException exp) {
                NLogger.error(ExportEngine.class, (Object)exp, (Throwable)exp);
            }
        }
        catch (IOException exp) {
            NLogger.error(ExportEngine.class, (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(pipedInputStream);
            IOUtil.closeQuietly(pipedOutStream);
        }
    }
}

