/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.lang.ref.SoftReference;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.security.HittingIpCidrPair;
import phex.security.IpSecurityRule;
import phex.xml.sax.security.DIpAccessRule;
import phex.xml.sax.security.DSecurityRule;

public class IpSystemSecurityRule
implements IpSecurityRule {
    private final HittingIpCidrPair ipCidrPair;
    private SoftReference<String> addressString;

    public IpSystemSecurityRule(int ip, byte cidr) {
        this.ipCidrPair = new HittingIpCidrPair(ip, cidr);
    }

    public String getAddressString() {
        if (this.addressString == null || this.addressString.get() == null) {
            this.addressString = this.ipCidrPair.cidr == 32 ? new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr)) : new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr) + " / " + String.valueOf(this.ipCidrPair.cidr));
        }
        return this.addressString.get();
    }

    public HittingIpCidrPair getIpCidrPair() {
        return this.ipCidrPair;
    }

    public int getIp() {
        return this.ipCidrPair.ipAddr;
    }

    public int getTriggerCount() {
        return this.ipCidrPair.getHits();
    }

    public void setTriggerCount(int count) {
        this.ipCidrPair.setHits(count);
    }

    public boolean isDenyingRule() {
        return true;
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean isSystemRule() {
        return true;
    }

    public boolean isDeletedOnExpiry() {
        return false;
    }

    public ExpiryDate getExpiryDate() {
        return ExpiryDate.NEVER_EXPIRY_DATE;
    }

    public String getDescription() {
        return "System rule.";
    }

    public DSecurityRule createDSecurityRule() {
        DIpAccessRule dRule = new DIpAccessRule();
        dRule.setSystemRule(true);
        dRule.setIp(AddressUtils.intIp2ByteIp(this.ipCidrPair.ipAddr));
        dRule.setCidr(this.ipCidrPair.cidr);
        dRule.setTriggerCount(this.ipCidrPair.getHits());
        return dRule;
    }
}

