/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import phex.common.address.AddressUtils;

public class IpCidrPair {
    public final int ipAddr;
    public final byte cidr;

    public IpCidrPair(int ip, byte cidr) {
        this.ipAddr = ip;
        this.cidr = cidr;
    }

    public IpCidrPair(int ip) {
        this.ipAddr = ip;
        this.cidr = (byte)32;
    }

    public int getNetMask() {
        return AddressUtils.CIDR2MASK[this.cidr];
    }

    public boolean contains(IpCidrPair ip) {
        return (ip.ipAddr & this.getNetMask()) == this.ipAddr && (ip.getNetMask() & this.getNetMask()) == this.getNetMask();
    }

    public boolean contains(int ip, int netMask) {
        return (ip & this.getNetMask()) == this.ipAddr && (netMask & this.getNetMask()) == this.getNetMask();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpCidrPair)) {
            return false;
        }
        IpCidrPair pair = (IpCidrPair)obj;
        if (this.cidr != pair.cidr) {
            return false;
        }
        return (this.ipAddr & this.getNetMask()) == (pair.ipAddr & pair.getNetMask());
    }

    public int hashCode() {
        return this.ipAddr ^ this.getNetMask();
    }

    public String toString() {
        return AddressUtils.ip2string(this.ipAddr) + "/" + this.cidr;
    }
}

