/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFilenameCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameCondition
implements Condition {
    private ListOrderedSet terms = new ListOrderedSet();

    public FilenameCondition() {
    }

    public FilenameCondition(FilenameCondition condition) {
        this();
        this.update(condition);
    }

    public synchronized void update(FilenameCondition condition) {
        this.terms.clear();
        this.terms.addAll((Collection)condition.terms);
    }

    public synchronized int getTermsCount() {
        return this.terms.size();
    }

    public synchronized Set<String> getTerms() {
        return Collections.unmodifiableSet(this.terms);
    }

    public synchronized List<String> getTermsList() {
        return this.terms.asList();
    }

    public synchronized FilenameCondition addTerm(String term) {
        term = term.toLowerCase();
        this.terms.add((Object)term);
        return this;
    }

    public synchronized void removeTerm(String term) {
        this.terms.remove((Object)term);
    }

    @Override
    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        String filename = remoteFile.getFilename();
        filename = filename.toLowerCase();
        for (String term : this.terms) {
            if (filename.indexOf(term) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.getTermsCount() > 0;
    }

    @Override
    public synchronized Object clone() {
        try {
            FilenameCondition clone = (FilenameCondition)super.clone();
            clone.terms = new ListOrderedSet();
            clone.terms.addAll((Collection)this.terms);
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized DCondition createDCondition() {
        DFilenameCondition dCond = new DFilenameCondition();
        ArrayList<String> newList = new ArrayList<String>((Collection<String>)this.terms);
        dCond.setTerms(newList);
        return dCond;
    }
}

