/*
 * Decompiled with CFR 0.152.
 */
package phex.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.rules.DefaultSearchFilterRules;
import phex.rules.Rule;
import phex.rules.condition.AndConcatCondition;
import phex.rules.condition.Condition;
import phex.rules.consequence.Consequence;
import phex.servent.Servent;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.rules.DAndConcatCondition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DConsequence;
import phex.xml.sax.rules.DConsequencesList;
import phex.xml.sax.rules.DSearchRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilterRules {
    private boolean hasChangedSinceLastSave;
    private List<Rule> searchFilterRules = new ArrayList<Rule>();

    public SearchFilterRules() {
        this.searchFilterRules.add(DefaultSearchFilterRules.ADULT_FILTER_RULE);
        this.searchFilterRules.add(DefaultSearchFilterRules.SCAM_FILE_FILTER_RULE);
        this.searchFilterRules.add(DefaultSearchFilterRules.SPAM_FILE_FILTER_RULE);
        this.searchFilterRules.add(DefaultSearchFilterRules.NASTY_FILE_FILTER_RULE);
        this.hasChangedSinceLastSave = false;
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public synchronized void setRuleList(List<Rule> newList) {
        this.searchFilterRules = newList;
        this.hasChangedSinceLastSave = true;
    }

    public synchronized List<Rule> getAsList() {
        return Collections.unmodifiableList(this.searchFilterRules);
    }

    public synchronized List<Rule> getPermanentList() {
        ArrayList<Rule> list = new ArrayList<Rule>();
        for (Rule rule : this.searchFilterRules) {
            if (!rule.isPermanentlyEnabled()) continue;
            list.add(rule);
        }
        return list;
    }

    public synchronized int getCount() {
        return this.searchFilterRules.size();
    }

    public synchronized Rule getRuleAt(int index) {
        if (index < 0 || index >= this.searchFilterRules.size()) {
            return null;
        }
        return this.searchFilterRules.get(index);
    }

    public synchronized Rule getRuleById(String id) {
        for (Rule rule : this.searchFilterRules) {
            if (!id.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public synchronized void save() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        NLogger.debug(SearchFilterRules.class, (Object)"Saving search filters.");
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList<DSearchRule> dList = new DSubElementList<DSearchRule>("search-rule-list");
            dPhex.setSearchRuleList(dList);
            List<DSearchRule> searchRuleList = dList.getSubElementList();
            for (Rule rule : this.searchFilterRules) {
                DSearchRule dRule = new DSearchRule();
                dRule.setId(rule.getId());
                dRule.setName(rule.getName());
                dRule.setDescription(rule.getDescription());
                dRule.setPermanentlyEnabled(rule.isPermanentlyEnabled());
                DAndConcatCondition andCondition = new DAndConcatCondition();
                List<DCondition> dCondList = andCondition.getSubElementList();
                for (Condition cond : rule.getConditions()) {
                    DCondition dCond = cond.createDCondition();
                    dCondList.add(dCond);
                }
                dRule.setAndConcatCondition(andCondition);
                DConsequencesList dConsequ = new DConsequencesList();
                List<DConsequence> dConsequList = dConsequ.getSubElementList();
                for (Consequence consequ : rule.getConsequences()) {
                    DConsequence dCond = consequ.createDConsequence();
                    dConsequList.add(dCond);
                }
                dRule.setConsequencesList(dConsequ);
                searchRuleList.add(dRule);
            }
            Servent servent = Servent.getInstance();
            File outputFile = servent.getGnutellaNetwork().getSearchFilterFile();
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(outputFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException exp) {
            NLogger.error(SearchFilterRules.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error(SearchFilterRules.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public synchronized void load() {
        NLogger.debug(SearchFilterRules.class, (Object)"Loading search filters.");
        Servent servent = Servent.getInstance();
        File inputFile = servent.getGnutellaNetwork().getSearchFilterFile();
        try {
            if (!inputFile.exists()) {
                return;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(inputFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(SearchFilterRules.class, (Object)"No DPhex found.");
                return;
            }
            DSubElementList<DSearchRule> dRuleList = dPhex.getSearchRuleList();
            if (dRuleList == null) {
                NLogger.warn(SearchFilterRules.class, (Object)"No DSearchRule list found.");
                return;
            }
            ArrayList<Rule> newRules = new ArrayList<Rule>();
            for (DSearchRule dRule : dRuleList.getSubElementList()) {
                Rule rule = null;
                boolean isNew = false;
                String id = dRule.getId();
                if (id != null) {
                    rule = this.getRuleById(id);
                }
                if (rule == null) {
                    isNew = true;
                    rule = new Rule();
                }
                if (!rule.isDefaultRule()) {
                    String name = dRule.getName();
                    rule.setName(name);
                    DAndConcatCondition dCondition = dRule.getAndConcatCondition();
                    AndConcatCondition andCond = (AndConcatCondition)dCondition.createCondition();
                    for (Condition cond : andCond.getConditions()) {
                        rule.addCondition(cond);
                    }
                    DConsequencesList consequencesList = dRule.getConsequencesList();
                    for (DConsequence dConsequ : consequencesList.getSubElementList()) {
                        Consequence conseq = dConsequ.createConsequence();
                        rule.addConsequence(conseq);
                    }
                }
                if (dRule.isHasPermanentlyEnabled()) {
                    rule.setPermanentlyEnabled(dRule.isPermanentlyEnabled());
                }
                if (!isNew) continue;
                newRules.add(rule);
            }
            this.searchFilterRules.addAll(newRules);
        }
        catch (IOException exp) {
            NLogger.error(SearchFilterRules.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error(SearchFilterRules.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                Environment.getInstance().executeOnThreadPool(new SaveRunner(), "SaveSearchFilterRules");
            }
            catch (Throwable th) {
                NLogger.error(SearchFilterRules.class, (Object)th, th);
            }
        }
    }

    private class SaveRunner
    implements Runnable {
        private SaveRunner() {
        }

        public void run() {
            SearchFilterRules.this.save();
        }
    }
}

